/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.bop.cost.BTreeCostModel;
import com.bigdata.bop.cost.DiskCostModel;
import com.bigdata.bop.cost.ScanCostReport;
import com.bigdata.btree.BTree;
import com.bigdata.btree.ChunkedLocalRangeIterator;
import com.bigdata.btree.ICounter;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILinearList;
import com.bigdata.btree.IReadWriteLockManager;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.ReadWriteLockManager;
import com.bigdata.btree.ResultSet;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IIndexProcedure;
import com.bigdata.btree.proc.IKeyRangeIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.counters.CounterSet;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.service.Split;
import cutthecrap.utils.striterators.IFilter;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;

public class UnisolatedReadWriteIndex
implements IIndex,
ILinearList,
IReadWriteLockManager {
    private final ReadWriteLockManager lockManager;
    private final BTree ndx;
    private final int defaultCapacity;
    protected static final int DEFAULT_CAPACITY = 1000;

    @Override
    public Lock readLock() {
        return this.lockManager.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lockManager.writeLock();
    }

    @Override
    public int getReadLockCount() {
        return this.lockManager.getReadLockCount();
    }

    @Override
    public boolean isReadOnly() {
        return this.lockManager.isReadOnly();
    }

    private Lock lock(IIndexProcedure<?> proc) {
        if (proc == null) {
            throw new IllegalArgumentException();
        }
        if (proc.isReadOnly()) {
            return this.readLock();
        }
        return this.writeLock();
    }

    private void unlock(Lock lock) {
        lock.unlock();
    }

    public UnisolatedReadWriteIndex(BTree ndx) {
        this(ndx, 1000);
    }

    public UnisolatedReadWriteIndex(BTree ndx, int defaultCapacity) {
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        if (defaultCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.ndx = ndx;
        this.defaultCapacity = defaultCapacity;
        this.lockManager = ReadWriteLockManager.getLockManager(ndx);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.ndx.toString() + "}";
    }

    @Override
    public IndexMetadata getIndexMetadata() {
        return this.ndx.getIndexMetadata();
    }

    @Override
    public IResourceMetadata[] getResourceMetadata() {
        return this.getIndexMetadata().getPartitionMetadata().getResources();
    }

    @Override
    public CounterSet getCounters() {
        return this.ndx.getCounters();
    }

    @Override
    public ICounter getCounter() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object key) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            boolean bl = this.ndx.contains(key);
            return bl;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object insert(Object key, Object value) {
        Lock lock = this.writeLock();
        lock.lock();
        try {
            Object object = this.ndx.insert(key, value);
            return object;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(Object key) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            Object object = this.ndx.lookup(key);
            return object;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        Lock lock = this.writeLock();
        lock.lock();
        try {
            Object object = this.ndx.remove(key);
            return object;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(byte[] key) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            boolean bl = this.ndx.contains(key);
            return bl;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] lookup(byte[] key) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            byte[] byArray = this.ndx.lookup(key);
            return byArray;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] insert(byte[] key, byte[] value) {
        Lock lock = this.writeLock();
        lock.lock();
        try {
            byte[] byArray = this.ndx.insert(key, value);
            return byArray;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] remove(byte[] key) {
        Lock lock = this.writeLock();
        lock.lock();
        try {
            byte[] byArray = this.ndx.remove(key);
            return byArray;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rangeCount() {
        Lock lock = this.readLock();
        lock.lock();
        try {
            long l = this.ndx.rangeCount();
            return l;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rangeCount(byte[] fromKey, byte[] toKey) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            long l = this.ndx.rangeCount(fromKey, toKey);
            return l;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rangeCountExact(byte[] fromKey, byte[] toKey) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            long l = this.ndx.rangeCountExact(fromKey, toKey);
            return l;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rangeCountExactWithDeleted(byte[] fromKey, byte[] toKey) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            long l = this.ndx.rangeCountExactWithDeleted(fromKey, toKey);
            return l;
        }
        finally {
            this.unlock(lock);
        }
    }

    @Override
    public final ITupleIterator rangeIterator() {
        return this.rangeIterator(null, null);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey) {
        return this.rangeIterator(fromKey, toKey, 0, 3, null);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        if (capacity == 0) {
            capacity = this.defaultCapacity;
        }
        if ((flags & 0x10) != 0) {
            flags |= 1;
        }
        return new ChunkedIterator(this.ndx, fromKey, toKey, capacity, flags, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object submit(byte[] key, ISimpleIndexProcedure proc) {
        Lock lock = this.lock(proc);
        lock.lock();
        try {
            Object object = this.ndx.submit(key, proc);
            return object;
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(byte[] fromKey, byte[] toKey, IKeyRangeIndexProcedure proc, IResultHandler handler) {
        Lock lock = this.lock(proc);
        lock.lock();
        try {
            this.ndx.submit(fromKey, toKey, proc, handler);
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(int fromIndex, int toIndex, byte[][] keys, byte[][] vals, AbstractKeyArrayIndexProcedureConstructor ctor, IResultHandler aggregator) {
        if (ctor == null) {
            throw new IllegalArgumentException();
        }
        Object proc = ctor.newInstance(this, fromIndex, toIndex, keys, vals);
        Lock lock = this.lock((IIndexProcedure<?>)proc);
        lock.lock();
        try {
            Object result = proc.apply(this.ndx);
            if (aggregator != null) {
                aggregator.aggregate(result, new Split(null, fromIndex, toIndex));
            }
        }
        finally {
            this.unlock(lock);
        }
    }

    public ScanCostReport estimateCost(DiskCostModel diskCostModel, long rangeCount) {
        BTree stats = this.ndx;
        double cost = new BTreeCostModel(diskCostModel).rangeScan(rangeCount, stats.getBranchingFactor(), stats.getHeight(), stats.getUtilization().getLeafUtilization());
        return new ScanCostReport(rangeCount, cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long indexOf(byte[] key) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            long l = this.ndx.indexOf(key);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] keyAt(long index) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            byte[] byArray = this.ndx.keyAt(index);
            return byArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] valueAt(long index) {
        Lock lock = this.readLock();
        lock.lock();
        try {
            byte[] byArray = this.ndx.valueAt(index);
            return byArray;
        }
        finally {
            lock.unlock();
        }
    }

    private class ChunkedIterator<E>
    extends ChunkedLocalRangeIterator<E> {
        private ChunkedIterator(IIndex ndx, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
            super(ndx, fromKey, toKey, capacity, flags, filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void deleteBehind(int n, Iterator<byte[]> keys) {
            Lock lock = UnisolatedReadWriteIndex.this.writeLock();
            lock.lock();
            try {
                super.deleteBehind(n, keys);
            }
            finally {
                UnisolatedReadWriteIndex.this.unlock(lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void deleteLast(byte[] key) {
            Lock lock = UnisolatedReadWriteIndex.this.writeLock();
            lock.lock();
            try {
                super.deleteLast(key);
            }
            finally {
                UnisolatedReadWriteIndex.this.unlock(lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ResultSet getResultSet(long timestamp, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
            boolean mutation = (flags & 0x10) != 0;
            Lock lock = mutation ? UnisolatedReadWriteIndex.this.writeLock() : UnisolatedReadWriteIndex.this.readLock();
            lock.lock();
            try {
                ResultSet resultSet = super.getResultSet(timestamp, fromKey, toKey, capacity, flags, filter);
                return resultSet;
            }
            finally {
                UnisolatedReadWriteIndex.this.unlock(lock);
            }
        }
    }
}

