/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.keys;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;

public class ThreadLocalKeyBuilderFactory
implements IKeyBuilderFactory {
    private final IKeyBuilderFactory delegate;
    private ThreadLocal<IKeyBuilder> threadLocalKeyBuilder = new ThreadLocal<IKeyBuilder>(){

        @Override
        protected synchronized IKeyBuilder initialValue() {
            return ThreadLocalKeyBuilderFactory.this.delegate.getKeyBuilder();
        }
    };
    private ThreadLocal<IKeyBuilder> threadLocalPrimaryKeyBuilder = new ThreadLocal<IKeyBuilder>(){

        @Override
        protected synchronized IKeyBuilder initialValue() {
            return ThreadLocalKeyBuilderFactory.this.delegate.getPrimaryKeyBuilder();
        }
    };

    public ThreadLocalKeyBuilderFactory(IKeyBuilderFactory delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    @Override
    public IKeyBuilder getKeyBuilder() {
        return this.threadLocalKeyBuilder.get();
    }

    @Override
    public IKeyBuilder getPrimaryKeyBuilder() {
        return this.threadLocalPrimaryKeyBuilder.get();
    }
}

