/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.proc;

import com.bigdata.btree.proc.AbstractIndexProcedure;
import com.bigdata.btree.proc.IKeyArrayIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.ReadOnlyKeysRaba;
import com.bigdata.btree.raba.ReadOnlyValuesRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.FixedByteArrayBuffer;
import com.bigdata.service.Split;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractKeyArrayIndexProcedure<T>
extends AbstractIndexProcedure<T>
implements IKeyArrayIndexProcedure<T>,
Externalizable {
    private IRabaCoder keysCoder;
    private IRabaCoder valsCoder;
    private IRaba keys;
    private IRaba vals;
    private static final byte VERSION0 = 0;

    @Override
    public final IRaba getKeys() {
        return this.keys;
    }

    @Override
    public final IRaba getValues() {
        return this.vals;
    }

    @Override
    public final int getKeyCount() {
        return this.keys.size();
    }

    @Override
    public final byte[] getKey(int i) {
        return this.keys.get(i);
    }

    @Override
    public final byte[] getValue(int i) {
        if (this.vals == null) {
            throw new UnsupportedOperationException();
        }
        return this.vals.get(i);
    }

    protected AbstractKeyArrayIndexProcedure() {
    }

    protected AbstractKeyArrayIndexProcedure(IRabaCoder keysCoder, IRabaCoder valsCoder, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
        if (keysCoder == null) {
            throw new IllegalArgumentException();
        }
        if (valsCoder == null && vals != null) {
            throw new IllegalArgumentException();
        }
        if (keys == null) {
            throw new IllegalArgumentException("keys is null");
        }
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex is invalid");
        }
        if (fromIndex >= toIndex) {
            throw new IllegalArgumentException("fromIndex is invalid");
        }
        if (toIndex > keys.length) {
            throw new IllegalArgumentException("toIndex is invalid");
        }
        if (vals != null && toIndex > vals.length) {
            throw new IllegalArgumentException("toIndex is invalid");
        }
        this.keysCoder = keysCoder;
        this.valsCoder = valsCoder;
        this.keys = new ReadOnlyKeysRaba(fromIndex, toIndex, keys);
        this.vals = vals == null ? null : new ReadOnlyValuesRaba(fromIndex, toIndex, vals);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readMetadata(in);
        boolean haveVals = in.readBoolean();
        int len = in.readInt();
        byte[] a = new byte[len];
        in.readFully(a);
        this.keys = this.keysCoder.decode(FixedByteArrayBuffer.wrap(a));
        if (haveVals) {
            len = in.readInt();
            a = new byte[len];
            in.readFully(a);
            this.vals = this.valsCoder.decode(FixedByteArrayBuffer.wrap(a));
        } else {
            this.vals = null;
        }
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        this.writeMetadata(out);
        out.writeBoolean(this.vals != null);
        DataOutputBuffer buf = new DataOutputBuffer();
        AbstractFixedByteArrayBuffer slice = this.keysCoder.encode(this.keys, buf);
        out.writeInt(slice.len());
        slice.writeOn(out);
        if (this.vals != null) {
            buf.reset();
            slice = this.valsCoder.encode(this.vals, buf);
            out.writeInt(slice.len());
            slice.writeOn(out);
        }
    }

    protected void readMetadata(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new IOException();
            }
        }
        this.keysCoder = (IRabaCoder)in.readObject();
        this.valsCoder = (IRabaCoder)in.readObject();
    }

    protected void writeMetadata(ObjectOutput out) throws IOException {
        out.write(0);
        out.writeObject(this.keysCoder);
        out.writeObject(this.valsCoder);
    }

    public static class ResultBitBufferCounter
    implements IResultHandler<ResultBitBuffer, Long> {
        private final AtomicLong ntrue = new AtomicLong();

        @Override
        public void aggregate(ResultBitBuffer result, Split split) {
            int delta = 0;
            for (int i = 0; i < result.n; ++i) {
                if (!result.a[i]) continue;
                ++delta;
            }
            this.ntrue.addAndGet(delta);
        }

        @Override
        public Long getResult() {
            return this.ntrue.get();
        }
    }

    public static class ResultBitBufferHandler
    implements IResultHandler<ResultBitBuffer, ResultBitBuffer> {
        private final boolean[] results;
        private final int multiplier;
        private final AtomicInteger onCount = new AtomicInteger();

        public ResultBitBufferHandler(int nkeys) {
            this(nkeys, 1);
        }

        public ResultBitBufferHandler(int nkeys, int multiplier) {
            this.results = new boolean[nkeys * multiplier];
            this.multiplier = multiplier;
        }

        @Override
        public void aggregate(ResultBitBuffer result, Split split) {
            System.arraycopy(result.getResult(), 0, this.results, split.fromIndex * this.multiplier, split.ntuples * this.multiplier);
            this.onCount.addAndGet(result.getOnCount());
        }

        @Override
        public ResultBitBuffer getResult() {
            return new ResultBitBuffer(this.results.length, this.results, this.onCount.get());
        }
    }

    public static class ResultBufferHandler
    implements IResultHandler<ResultBuffer, ResultBuffer> {
        private final byte[][] results;
        private final IRabaCoder valsCoder;

        public ResultBufferHandler(int nkeys, IRabaCoder valsCoder) {
            this.results = new byte[nkeys][];
            this.valsCoder = valsCoder;
        }

        @Override
        public void aggregate(ResultBuffer result, Split split) {
            IRaba src = result.getValues();
            int i = 0;
            int j = split.fromIndex;
            while (i < split.ntuples) {
                this.results[j] = src.get(i);
                ++i;
                ++j;
            }
        }

        @Override
        public ResultBuffer getResult() {
            return new ResultBuffer(this.results.length, this.results, this.valsCoder);
        }
    }

    public static class ResultBitBuffer
    implements Externalizable {
        private static final long serialVersionUID = 1918403771057371471L;
        private int n;
        private boolean[] a;
        private transient int onCount;
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public ResultBitBuffer() {
        }

        public ResultBitBuffer(int n, boolean[] a, int onCount) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (a == null) {
                throw new IllegalArgumentException();
            }
            if (onCount < 0 || onCount > n) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.a = a;
            this.onCount = onCount;
        }

        public int getResultCount() {
            return this.n;
        }

        public boolean[] getResult() {
            return this.a;
        }

        public int getOnCount() {
            return this.onCount;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
            InputBitStream ibs = new InputBitStream((InputStream)((Object)in), 0, false);
            this.n = ibs.readNibble();
            this.a = new boolean[this.n];
            for (int i = 0; i < this.n; ++i) {
                boolean bit = ibs.readBit() == 1;
                this.a[i] = bit;
                if (!this.a[i]) continue;
                ++this.onCount;
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            OutputBitStream obs = new OutputBitStream((OutputStream)((Object)out), 0, false);
            obs.writeNibble(this.n);
            for (int i = 0; i < this.n; ++i) {
                obs.writeBit(this.a[i]);
            }
            obs.flush();
        }
    }

    public static class ResultBuffer
    implements Externalizable {
        private static final long serialVersionUID = 3545214696708412869L;
        private IRaba vals;
        private IRabaCoder valsCoder;
        private static final byte VERSION0 = 0;

        public ResultBuffer() {
        }

        public ResultBuffer(int n, byte[][] a, IRabaCoder valsCoder) {
            assert (n >= 0);
            assert (a != null);
            assert (valsCoder != null);
            this.vals = new ReadOnlyValuesRaba(0, n, a);
            this.valsCoder = valsCoder;
        }

        public IRaba getValues() {
            return this.vals;
        }

        public int getResultCount() {
            return this.vals.size();
        }

        public byte[] getResult(int index) {
            return this.vals.get(index);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            this.valsCoder = (IRabaCoder)in.readObject();
            int len = in.readInt();
            byte[] b = new byte[len];
            in.readFully(b);
            this.vals = this.valsCoder.decode(FixedByteArrayBuffer.wrap(b));
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            out.writeObject(this.valsCoder);
            AbstractFixedByteArrayBuffer slice = this.valsCoder.encode(this.vals, new DataOutputBuffer());
            out.writeInt(slice.len());
            slice.writeOn(out);
        }
    }
}

