/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.proc;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.proc.AbstractIndexProcedure;
import com.bigdata.btree.proc.IKeyRangeIndexProcedure;
import com.bigdata.mdi.ISeparatorKeys;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractKeyRangeIndexProcedure<T>
extends AbstractIndexProcedure<T>
implements IKeyRangeIndexProcedure<T>,
Externalizable {
    protected byte[] fromKey;
    protected byte[] toKey;
    private static final short VERSION0 = 0;

    @Override
    public byte[] getFromKey() {
        return this.fromKey;
    }

    @Override
    public byte[] getToKey() {
        return this.toKey;
    }

    public AbstractKeyRangeIndexProcedure() {
    }

    public AbstractKeyRangeIndexProcedure(byte[] fromKey, byte[] toKey) {
        this.fromKey = fromKey;
        this.toKey = toKey;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readKeys(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeKeys(out);
    }

    protected void readKeys(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version != 0) {
            throw new IOException("Unknown version: " + version);
        }
        int len = in.readInt();
        if (len > 0) {
            this.fromKey = new byte[len - 1];
            in.readFully(this.fromKey);
        }
        if ((len = in.readInt()) > 0) {
            this.toKey = new byte[len - 1];
            in.readFully(this.toKey);
        }
    }

    protected void writeKeys(ObjectOutput out) throws IOException {
        out.writeShort(0);
        out.writeInt(this.fromKey == null ? 0 : this.fromKey.length + 1);
        if (this.fromKey != null) {
            out.write(this.fromKey);
        }
        out.writeInt(this.toKey == null ? 0 : this.toKey.length + 1);
        if (this.toKey != null) {
            out.write(this.toKey);
        }
    }

    public static byte[] constrainFromKey(byte[] fromKey, ISeparatorKeys pmd) {
        if (pmd == null) {
            return fromKey;
        }
        if (fromKey != null) {
            int ret = BytesUtil.compareBytes(fromKey, pmd.getLeftSeparatorKey());
            if (ret < 0) {
                fromKey = pmd.getLeftSeparatorKey();
            }
        } else {
            fromKey = pmd.getLeftSeparatorKey();
        }
        return fromKey;
    }

    public static byte[] constrainToKey(byte[] toKey, ISeparatorKeys pmd) {
        if (pmd == null) {
            return toKey;
        }
        if (toKey != null) {
            int ret;
            if (pmd.getRightSeparatorKey() != null && (ret = BytesUtil.compareBytes(toKey, pmd.getRightSeparatorKey())) > 0) {
                toKey = pmd.getRightSeparatorKey();
            }
        } else {
            toKey = pmd.getRightSeparatorKey();
        }
        return toKey;
    }
}

