/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba;

import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.LongPacker;
import java.io.DataInput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Iterator;

public class ConditionalRabaCoder
implements IRabaCoder,
Externalizable {
    private static final long serialVersionUID = 167667045118062564L;
    private int bigSize;
    private IRabaCoder smallCoder;
    private IRabaCoder bigCoder;
    private static final byte VERSION0 = 0;

    protected boolean isSmall(int size) {
        return size < this.bigSize;
    }

    @Override
    public final boolean isKeyCoder() {
        return this.smallCoder.isKeyCoder() && this.bigCoder.isKeyCoder();
    }

    @Override
    public final boolean isValueCoder() {
        return this.smallCoder.isValueCoder() && this.bigCoder.isValueCoder();
    }

    @Override
    public boolean isDuplicateKeys() {
        return this.smallCoder.isDuplicateKeys() && this.bigCoder.isDuplicateKeys();
    }

    public ConditionalRabaCoder() {
    }

    public ConditionalRabaCoder(IRabaCoder smallCoder, IRabaCoder bigCoder, int bigSize) {
        boolean isValueCoder;
        boolean isKeyCoder = smallCoder.isKeyCoder() && bigCoder.isKeyCoder();
        boolean bl = isValueCoder = smallCoder.isValueCoder() && bigCoder.isValueCoder();
        if (!isKeyCoder && !isValueCoder) {
            throw new IllegalArgumentException();
        }
        this.smallCoder = smallCoder;
        this.bigCoder = bigCoder;
        this.bigSize = bigSize;
    }

    @Override
    public ICodedRaba decode(AbstractFixedByteArrayBuffer data) {
        boolean isSmall = data.getByte(0) == 1;
        AbstractFixedByteArrayBuffer delegateSlice = data.slice(1, data.len() - 1);
        ICodedRaba codedRaba = isSmall ? this.smallCoder.decode(delegateSlice) : this.bigCoder.decode(delegateSlice);
        return new CodedRabaSlice(data, codedRaba);
    }

    @Override
    public ICodedRaba encodeLive(IRaba raba, DataOutputBuffer buf) {
        int size = raba.size();
        boolean isSmall = this.isSmall(size);
        int O_origin = buf.pos();
        buf.putByte((byte)(isSmall ? 1 : 0));
        ICodedRaba delegateCodedRaba = isSmall ? this.smallCoder.encodeLive(raba, buf) : this.bigCoder.encodeLive(raba, buf);
        AbstractFixedByteArrayBuffer delegateSlice = delegateCodedRaba.data();
        return new CodedRabaSlice(buf.slice(O_origin, delegateSlice.len() + 1), delegateCodedRaba);
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(IRaba raba, DataOutputBuffer buf) {
        int size = raba.size();
        boolean isSmall = this.isSmall(size);
        int O_origin = buf.pos();
        buf.putByte((byte)(isSmall ? 1 : 0));
        AbstractFixedByteArrayBuffer slice = isSmall ? this.smallCoder.encode(raba, buf) : this.bigCoder.encode(raba, buf);
        return buf.slice(O_origin, slice.len() + 1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new IOException();
            }
        }
        this.bigSize = (int)LongPacker.unpackLong(in);
        this.smallCoder = (IRabaCoder)in.readObject();
        this.bigCoder = (IRabaCoder)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        LongPacker.packLong(out, (long)this.bigSize);
        out.writeObject(this.smallCoder);
        out.writeObject(this.bigCoder);
    }

    private static class CodedRabaSlice
    implements ICodedRaba {
        private final IRaba delegate;
        private final AbstractFixedByteArrayBuffer data;

        CodedRabaSlice(AbstractFixedByteArrayBuffer data, IRaba delegate) {
            this.delegate = delegate;
            this.data = data;
        }

        @Override
        public AbstractFixedByteArrayBuffer data() {
            return this.data;
        }

        @Override
        public int add(byte[] value, int off, int len) {
            return this.delegate.add(value, off, len);
        }

        @Override
        public int add(byte[] a) {
            return this.delegate.add(a);
        }

        @Override
        public int add(DataInput in, int len) throws IOException {
            return this.delegate.add(in, len);
        }

        @Override
        public int capacity() {
            return this.delegate.capacity();
        }

        @Override
        public int copy(int index, OutputStream os) {
            return this.delegate.copy(index, os);
        }

        @Override
        public byte[] get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean isFull() {
            return this.delegate.isFull();
        }

        @Override
        public boolean isKeys() {
            return this.delegate.isKeys();
        }

        @Override
        public boolean isNull(int index) {
            return this.delegate.isNull(index);
        }

        @Override
        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        @Override
        public Iterator<byte[]> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public int length(int index) {
            return this.delegate.length(index);
        }

        @Override
        public int search(byte[] searchKey) {
            return this.delegate.search(searchKey);
        }

        @Override
        public void set(int index, byte[] a) {
            this.delegate.set(index, a);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

