/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.raba.AbstractRaba;

public class ReadOnlyKeysRaba
extends AbstractRaba {
    public static final transient ReadOnlyKeysRaba EMPTY = new ReadOnlyKeysRaba(BytesUtil.EMPTY2);

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public final boolean isKeys() {
        return true;
    }

    public ReadOnlyKeysRaba(byte[][] a) {
        this(0, a.length, a.length, a);
    }

    public ReadOnlyKeysRaba(int size, byte[][] a) {
        this(0, size, a.length, a);
    }

    public ReadOnlyKeysRaba(int fromIndex, int toIndex, byte[][] a) {
        this(fromIndex, toIndex, a.length - fromIndex, a);
    }

    public ReadOnlyKeysRaba(int fromIndex, int toIndex, int capacity, byte[][] a) {
        super(fromIndex, toIndex, capacity, a);
    }

    protected boolean assertTotalOrder(int fromIndex, int toIndex, byte[][] a) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (i <= fromIndex) continue;
            int ret = BytesUtil.compareBytes(a[i - 1], a[i]);
            assert (ret < 0) : "unsigned byte[]s are out of order at index=" + i + ", ret=" + ret + "\na[" + (i - 1) + "]=" + BytesUtil.toString(a[i - 1]) + "\na[" + i + "]=" + BytesUtil.toString(a[i]);
        }
        return true;
    }
}

