/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.BigdataStatics;
import com.bigdata.LRUNexus;
import com.bigdata.cache.IGlobalLRU;
import com.bigdata.cache.IHardReferenceGlobalLRU;
import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.IDataRecordAccess;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IRawStore;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class BCHMGlobalLRU2<K, V>
implements IHardReferenceGlobalLRU<K, V> {
    protected static final Logger log = Logger.getLogger(BCHMGlobalLRU2.class);
    private final ConcurrentHashMap<UUID, LRUCacheImpl<K, V>> cacheSet;
    private final int concurrencyLevel;
    private final boolean threadLocalBuffers;
    private final int threadLocalBufferCapacity;
    private final int threadLocalBufferTryLockSize;
    private final GlobalLRUCounters<K, V> globalLRUCounters;
    private final AccessPolicy<K, V> accessPolicy;
    private final ReentrantLock lock = new ReentrantLock(false);
    private final long maximumBytesInMemory;
    private final long minCleared;
    private final int initialCacheCapacity;
    private final float loadFactor;
    private final Semaphore[] permits;
    private final TLB<DLN<K, V>>[] buffers;
    private final ConcurrentHashMap<Thread, TLB<DLN<K, V>>> threadLocalBufferMap;

    protected TLB<DLN<K, V>> newTLB(int id, int capacity, int tryLockSize, Lock lock) {
        return new TLB<DLN<K, V>>(id, this.threadLocalBufferCapacity, this.threadLocalBufferTryLockSize, lock){

            protected void batchUpdates(int n, DLN<K, V>[] a) {
                for (int i = 0; i < n; ++i) {
                    DLN ref = a[i];
                    if (ref == null) continue;
                    while (BCHMGlobalLRU2.this.globalLRUCounters.bytesInMemory > BCHMGlobalLRU2.this.maximumBytesInMemory) {
                        BCHMGlobalLRU2.this.accessPolicy.evictEntry();
                    }
                    BCHMGlobalLRU2.this.accessPolicy.relink(ref);
                    a[i] = null;
                }
            }
        };
    }

    private final TLB<DLN<K, V>> getTLB() {
        Thread t = Thread.currentThread();
        TLB<DLN<K, V>> tmp = this.threadLocalBufferMap.get(t);
        if (tmp == null && this.threadLocalBufferMap.put(t, tmp = this.newTLB(0, this.threadLocalBufferCapacity, this.threadLocalBufferTryLockSize, this.lock)) != null) {
            throw new AssertionError();
        }
        return tmp;
    }

    private TLB<DLN<K, V>> acquire() throws InterruptedException {
        int i = (int)(Thread.currentThread().getId() % (long)this.concurrencyLevel);
        this.permits[i].acquire();
        return this.buffers[i];
    }

    private void release(TLB<DLN<K, V>> b) {
        this.permits[b.id].release();
    }

    private void add(DLN<K, V> entry) {
        if (this.threadLocalBuffers) {
            this.getTLB().add(entry);
        } else {
            TLB<DLN<K, V>> t = null;
            try {
                t = this.acquire();
                t.add(entry);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (t != null) {
                    this.release(t);
                }
            }
        }
    }

    private Iterator<TLB<DLN<K, V>>> bufferIterator() {
        if (this.threadLocalBuffers) {
            return Collections.unmodifiableCollection(this.threadLocalBufferMap.values()).iterator();
        }
        return Collections.unmodifiableList(Arrays.asList(this.buffers)).iterator();
    }

    public BCHMGlobalLRU2(LRUNexus.CacheSettings s) {
        this(s.accessPolicy, s.maximumBytesInMemory, s.minCleared, s.minCacheSetSize, s.initialCacheCapacity, s.loadFactor, s.concurrencyLevel, s.threadLocalBuffers, s.threadLocalBufferCapacity);
    }

    public BCHMGlobalLRU2(LRUNexus.AccessPolicyEnum accessPolicyEnum, long maximumBytesInMemory, long minCleared, int minimumCacheSetCapacity, int initialCacheCapacity, float loadFactor, int concurrencyLevel, boolean threadLocalBuffers, int threadLocalBufferCapacity) {
        if (maximumBytesInMemory <= 0L) {
            throw new IllegalArgumentException();
        }
        if (minCleared < 0L) {
            throw new IllegalArgumentException();
        }
        if (minCleared > maximumBytesInMemory) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel < 1) {
            throw new IllegalArgumentException();
        }
        if (threadLocalBufferCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumBytesInMemory = maximumBytesInMemory;
        this.minCleared = minCleared;
        this.initialCacheCapacity = initialCacheCapacity;
        this.loadFactor = loadFactor;
        this.concurrencyLevel = concurrencyLevel;
        this.threadLocalBuffers = threadLocalBuffers;
        this.globalLRUCounters = new GlobalLRUCounters(this);
        switch (accessPolicyEnum) {
            case LRU: {
                this.accessPolicy = new LRUAccessPolicy<K, V>(this.lock, this.globalLRUCounters);
                break;
            }
            case LIRS: {
                this.accessPolicy = new LIRSAccessPolicy<K, V>(this.lock, this.globalLRUCounters);
                break;
            }
            default: {
                throw new UnsupportedOperationException(accessPolicyEnum.toString());
            }
        }
        this.threadLocalBufferCapacity = threadLocalBufferCapacity;
        this.threadLocalBufferTryLockSize = threadLocalBufferCapacity >> 1;
        this.cacheSet = new ConcurrentHashMap(minimumCacheSetCapacity, loadFactor, concurrencyLevel);
        if (threadLocalBuffers) {
            this.permits = null;
            this.buffers = null;
            this.threadLocalBufferMap = new ConcurrentHashMap();
        } else {
            this.permits = new Semaphore[concurrencyLevel];
            this.buffers = new TLB[concurrencyLevel];
            this.threadLocalBufferMap = null;
            for (int i = 0; i < concurrencyLevel; ++i) {
                this.permits[i] = new Semaphore(1, false);
                this.buffers[i] = this.newTLB(i, threadLocalBufferCapacity, this.threadLocalBufferTryLockSize, this.lock);
            }
        }
    }

    @Override
    public LRUCacheImpl<K, V> getCache(UUID uuid, IAddressManager am) {
        LRUCacheImpl<K, V> oldVal;
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        LRUCacheImpl<K, V> cache = this.cacheSet.get(uuid);
        if (cache == null && (oldVal = this.cacheSet.putIfAbsent(uuid, cache = new LRUCacheImpl(uuid, am, this, this.lock, this.initialCacheCapacity, this.loadFactor, this.concurrencyLevel))) != null) {
            cache = oldVal;
        }
        return cache;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public boolean isTrueThreadLocalBuffer() {
        return this.threadLocalBuffers;
    }

    @Override
    public int getRecordCount() {
        return this.accessPolicy.size();
    }

    @Override
    public long getEvictionCount() {
        return ((GlobalLRUCounters)this.globalLRUCounters).evictionCount;
    }

    public long getEvictionByteCount() {
        return ((GlobalLRUCounters)this.globalLRUCounters).evictionByteCount;
    }

    @Override
    public long getBytesInMemory() {
        return ((GlobalLRUCounters)this.globalLRUCounters).bytesInMemory;
    }

    @Override
    public long getBytesOnDisk() {
        return ((GlobalLRUCounters)this.globalLRUCounters).bytesInMemory;
    }

    public long getMinCleared() {
        return this.minCleared;
    }

    @Override
    public long getMaximumBytesInMemory() {
        return this.maximumBytesInMemory;
    }

    @Override
    public int getCacheSetSize() {
        return this.cacheSet.size();
    }

    @Override
    public void deleteCache(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        LRUCacheImpl<K, V> cache = this.cacheSet.remove(uuid);
        if (cache != null) {
            cache.clear();
            if (BigdataStatics.debug) {
                System.err.println("Cleared cache: " + uuid);
            }
        } else if (BigdataStatics.debug) {
            System.err.println("No cache: " + uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardAllCaches() {
        this.lock.lock();
        try {
            Iterator<Object> itr = this.bufferIterator();
            while (itr.hasNext()) {
                TLB<DLN<K, V>> tLB = itr.next();
                tLB.clear();
            }
            for (LRUCacheImpl lRUCacheImpl : this.cacheSet.values()) {
                if (lRUCacheImpl == null) continue;
                lRUCacheImpl.map.clear();
            }
            this.cacheSet.clear();
            this.accessPolicy.clear();
            this.globalLRUCounters.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public CounterSet getCounterSet() {
        CounterSet root = this.globalLRUCounters.getCounterSet();
        for (LRUCacheImpl<K, V> cache : this.cacheSet.values()) {
            if (cache == null) continue;
            root.makePath(((LRUCacheImpl)cache).storeUUID.toString()).attach(((LRUCacheImpl)cache).cacheCounters.getCounters());
        }
        return root;
    }

    public String toString() {
        return this.getCounterSet().toString();
    }

    static class LRUCacheImpl<K, V>
    implements IGlobalLRU.ILRUCache<K, V> {
        private final LRUCacheCounters cacheCounters = new LRUCacheCounters();
        private final UUID storeUUID;
        private final IAddressManager am;
        private final BCHMGlobalLRU2<K, V> globalLRU;
        private final Lock lock;
        private final AccessPolicy<K, V> accessPolicy;
        private final ConcurrentHashMap<K, DLN<K, V>> map;

        public LRUCacheImpl(UUID storeUUID, IAddressManager am, BCHMGlobalLRU2<K, V> lru, Lock lock, int initialCapacity, float loadFactor, int concurrencyLevel) {
            if (storeUUID == null) {
                throw new IllegalArgumentException();
            }
            if (lru == null) {
                throw new IllegalArgumentException();
            }
            if (lock == null) {
                throw new IllegalArgumentException();
            }
            assert (!(am instanceof IRawStore)) : am.getClass().getName() + " implements " + IRawStore.class.getName();
            if (lru == null) {
                throw new IllegalArgumentException();
            }
            this.storeUUID = storeUUID;
            this.am = am;
            this.globalLRU = lru;
            this.lock = lock;
            this.accessPolicy = ((BCHMGlobalLRU2)lru).accessPolicy;
            this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        }

        @Override
        public IAddressManager getAddressManager() {
            return this.am;
        }

        @Override
        public UUID getStoreUUID() {
            return this.storeUUID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            this.lock.lock();
            try {
                Iterator<DLN<K, V>> itr = this.map.values().iterator();
                while (itr.hasNext()) {
                    DLN<K, V> e = itr.next();
                    itr.remove();
                    e.delete = true;
                    this.accessPolicy.relink(e);
                }
                this.cacheCounters.clear();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public V putIfAbsent(K k, V v) {
            if (k == null) {
                throw new IllegalArgumentException();
            }
            if (v == null) {
                throw new IllegalArgumentException();
            }
            DLN<K, V> entry = this.map.get(k);
            if (entry != null) {
                ((BCHMGlobalLRU2)this.globalLRU).add(entry);
                return entry.v();
            }
            entry = this.accessPolicy.newDLN(this, k, v);
            this.map.put(k, entry);
            ((BCHMGlobalLRU2)this.globalLRU).add(entry);
            int count = this.map.size();
            if (count > this.cacheCounters.highTide.get() + 50) {
                this.cacheCounters.highTide.set(count);
            }
            this.cacheCounters.ninserts.increment();
            return null;
        }

        @Override
        public V get(K key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            DLN<K, V> entry = this.map.get(key);
            this.cacheCounters.ntests.increment();
            if (entry == null) {
                return null;
            }
            ((BCHMGlobalLRU2)this.globalLRU).add(entry);
            this.cacheCounters.nsuccess.increment();
            return entry.v();
        }

        @Override
        public V remove(K key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            DLN<K, V> entry = this.map.remove(key);
            if (entry == null) {
                return null;
            }
            entry.delete = true;
            ((BCHMGlobalLRU2)this.globalLRU).add(entry);
            return entry.v();
        }

        public String toString() {
            return super.toString() + "{" + this.cacheCounters.toString() + "}";
        }

        DLN<K, V> inspect(K key) {
            return this.map.get(key);
        }

        AccessPolicy<K, V> getAccessPolicy() {
            return this.accessPolicy;
        }

        private class LRUCacheCounters {
            private final AtomicInteger highTide = new AtomicInteger();
            private final CAT ninserts = new CAT();
            private final CAT ntests = new CAT();
            private final CAT nsuccess = new CAT();

            private LRUCacheCounters() {
            }

            public void clear() {
                this.highTide.set(0);
                this.ninserts.set(0L);
                this.ntests.set(0L);
                this.nsuccess.set(0L);
            }

            public CounterSet getCounters() {
                CounterSet c = new CounterSet();
                c.addCounter("highTide", new Instrument<Integer>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheCounters.this.highTide.get());
                    }
                });
                c.addCounter("size", new Instrument<Integer>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheImpl.this.size());
                    }
                });
                c.addCounter("ninserts", new Instrument<Long>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheCounters.this.ninserts.get());
                    }
                });
                c.addCounter("ntests", new Instrument<Long>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheCounters.this.ntests.get());
                    }
                });
                c.addCounter("nsuccess", new Instrument<Long>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheCounters.this.nsuccess.get());
                    }
                });
                c.addCounter("hitRatio", new Instrument<Double>(){

                    @Override
                    protected void sample() {
                        long tmp = LRUCacheCounters.this.ntests.get();
                        this.setValue(tmp == 0L ? 0.0 : (double)LRUCacheCounters.this.nsuccess.get() / (double)tmp);
                    }
                });
                return c;
            }

            public String toString() {
                return this.getCounters().toString();
            }
        }
    }

    static class LIRSAccessPolicy<K, V>
    implements AccessPolicy<K, V> {
        private volatile int sizeLRU = 0;
        private volatile int sizeHIR = 0;
        private DLNLirs<K, V> firstLRU = null;
        private DLNLirs<K, V> lastLRU = null;
        private DLNLirs<K, V> firstHIR = null;
        private DLNLirs<K, V> lastHIR = null;
        private final ReentrantLock lock;
        private final GlobalLRUCounters<K, V> counters;

        protected LIRSAccessPolicy(ReentrantLock lock, GlobalLRUCounters<K, V> counters) {
            this.lock = lock;
            this.counters = counters;
        }

        @Override
        public int size() {
            return this.sizeLRU;
        }

        public int getLRUSize() {
            return this.sizeLRU;
        }

        public int getHIRSize() {
            return this.sizeHIR;
        }

        @Override
        public void clear() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            while (this.lastLRU != null) {
                this.lastLRU.delete = true;
                this.removeEntry(this.lastLRU);
            }
        }

        @Override
        public void relink(DLN<K, V> e) {
            if (e.delete) {
                this.removeEntry((DLNLirs)e);
            } else if (e.prior == null && e.next == null) {
                this.addEntry((DLNLirs)e);
            } else {
                this.touchEntry((DLNLirs)e);
            }
        }

        @Override
        public DLNLirs<K, V> newDLN(LRUCacheImpl<K, V> cache, K k, V v) {
            boolean lir = true;
            return new DLNLirs<K, V>(cache, k, v, lir);
        }

        void addEntry(DLNLirs<K, V> e) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("LRUSize=" + this.sizeLRU + ",HIRSize=" + this.sizeHIR + ",e=" + e.toString()));
            }
            if (this.firstLRU == null) {
                this.firstLRU = e;
                this.lastLRU = e;
            } else {
                this.lastLRU.next = e;
                e.prior = this.lastLRU;
                this.lastLRU = e;
            }
            ++this.sizeLRU;
            ((GlobalLRUCounters)this.counters).bytesInMemory += e.bytesInMemory;
            ((GlobalLRUCounters)this.counters).bytesOnDisk += e.bytesOnDisk;
        }

        void removeEntry(DLNLirs<K, V> e) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (e.cache == null) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("LRUSize=" + this.sizeLRU + ",HIRSize=" + this.sizeHIR + ",e=" + e.toString()));
            }
            DLNLirs prior = (DLNLirs)e.prior;
            DLNLirs next = (DLNLirs)e.next;
            if (e == this.firstLRU) {
                this.firstLRU = next;
            }
            if (this.lastLRU == e) {
                this.lastLRU = prior;
            }
            if (prior != null) {
                prior.next = next;
            }
            if (next != null) {
                next.prior = prior;
            }
            e.prior = null;
            e.next = null;
            e.v = null;
            --this.sizeLRU;
            ((GlobalLRUCounters)this.counters).bytesInMemory -= e.bytesInMemory;
            ((GlobalLRUCounters)this.counters).bytesOnDisk -= e.bytesOnDisk;
        }

        void touchEntry(DLNLirs<K, V> e) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (this.lastLRU == e) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("LRUSize=" + this.sizeLRU + ",HIRSize=" + this.sizeHIR + ",e=" + e.toString()));
            }
            boolean onBottom = this.firstLRU == e;
            DLNLirs prior = (DLNLirs)e.prior;
            DLNLirs next = (DLNLirs)e.next;
            if (e == this.firstLRU) {
                this.firstLRU = next;
            }
            if (this.lastLRU == e) {
                this.lastLRU = prior;
            }
            if (prior != null) {
                prior.next = next;
            }
            if (next != null) {
                next.prior = prior;
            }
            if (this.firstLRU == null) {
                this.firstLRU = e;
                this.lastLRU = e;
            } else {
                this.lastLRU.next = e;
                e.prior = this.lastLRU;
                e.next = null;
                this.lastLRU = e;
            }
            if (onBottom) {
                while (!this.firstLRU.lir) {
                    this.evictEntry();
                }
            }
        }

        private void pruneStack() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DLNLirs<K, V> evictEntry() {
            DLNLirs<K, V> e = this.firstLRU;
            assert (e != null);
            if (log.isTraceEnabled()) {
                log.trace((Object)("LRUSize=" + this.sizeLRU + ",HIRSize=" + this.sizeHIR + ",e=" + e.toString()));
            }
            LRUCacheImpl evictedFromCache = e.cache;
            this.removeEntry(e);
            e.lir = false;
            evictedFromCache.map.remove(e.k);
            ((GlobalLRUCounters)this.counters).evictionCount++;
            ((GlobalLRUCounters)this.counters).evictionByteCount += e.bytesOnDisk;
            return e;
        }
    }

    static class LRUAccessPolicy<K, V>
    implements AccessPolicy<K, V> {
        private volatile int size = 0;
        private DLNLru<K, V> first = null;
        private DLNLru<K, V> last = null;
        private final ReentrantLock lock;
        private final GlobalLRUCounters<K, V> counters;

        protected LRUAccessPolicy(ReentrantLock lock, GlobalLRUCounters<K, V> counters) {
            this.lock = lock;
            this.counters = counters;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void clear() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            while (this.first != null) {
                this.first.delete = true;
                this.removeEntry(this.first);
            }
        }

        @Override
        public void relink(DLN<K, V> e) {
            if (e.delete) {
                this.removeEntry((DLNLru)e);
            } else if (e.prior == null && e.next == null) {
                this.addEntry((DLNLru)e);
            } else {
                this.touchEntry((DLNLru)e);
            }
        }

        @Override
        public DLNLru<K, V> newDLN(LRUCacheImpl<K, V> cache, K k, V v) {
            return new DLNLru<K, V>(cache, k, v);
        }

        void addEntry(DLNLru<K, V> e) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (this.first == null) {
                this.first = e;
                this.last = e;
            } else {
                this.last.next = e;
                e.prior = this.last;
                this.last = e;
            }
            ++this.size;
            ((GlobalLRUCounters)this.counters).bytesInMemory += e.bytesInMemory;
            ((GlobalLRUCounters)this.counters).bytesOnDisk += e.bytesOnDisk;
        }

        void removeEntry(DLNLru<K, V> e) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            DLNLru prior = (DLNLru)e.prior;
            DLNLru next = (DLNLru)e.next;
            if (e == this.first) {
                this.first = next;
            }
            if (this.last == e) {
                this.last = prior;
            }
            if (prior != null) {
                prior.next = next;
            }
            if (next != null) {
                next.prior = prior;
            }
            e.prior = null;
            e.next = null;
            --this.size;
            ((GlobalLRUCounters)this.counters).bytesInMemory -= e.bytesInMemory;
            ((GlobalLRUCounters)this.counters).bytesOnDisk -= e.bytesOnDisk;
        }

        void touchEntry(DLNLru<K, V> e) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (this.last == e) {
                return;
            }
            DLNLru prior = (DLNLru)e.prior;
            DLNLru next = (DLNLru)e.next;
            if (e == this.first) {
                this.first = next;
            }
            if (this.last == e) {
                this.last = prior;
            }
            if (prior != null) {
                prior.next = next;
            }
            if (next != null) {
                next.prior = prior;
            }
            if (this.first == null) {
                this.first = e;
                this.last = e;
            } else {
                this.last.next = e;
                e.prior = this.last;
                e.next = null;
                this.last = e;
            }
        }

        @Override
        public DLNLru<K, V> evictEntry() {
            DLNLru<K, V> e = this.first;
            assert (e != null);
            LRUCacheImpl evictedFromCache = e.cache;
            this.removeEntry(e);
            evictedFromCache.map.remove(e.k);
            ((GlobalLRUCounters)this.counters).evictionCount++;
            ((GlobalLRUCounters)this.counters).evictionByteCount += e.bytesOnDisk;
            return e;
        }
    }

    static interface AccessPolicy<K, V> {
        public void clear();

        public int size();

        public void relink(DLN<K, V> var1);

        public DLN<K, V> evictEntry();

        public DLN<K, V> newDLN(LRUCacheImpl<K, V> var1, K var2, V var3);
    }

    private static class GlobalLRUCounters<K, V> {
        private volatile long bytesOnDisk = 0L;
        private volatile long bytesInMemory = 0L;
        private volatile long evictionCount = 0L;
        private volatile long evictionByteCount = 0L;
        private final BCHMGlobalLRU2<K, V> globalLRU;

        public GlobalLRUCounters(BCHMGlobalLRU2<K, V> cache) {
            this.globalLRU = cache;
        }

        public void clear() {
            this.evictionByteCount = 0L;
            this.evictionCount = 0L;
            this.bytesInMemory = 0L;
            this.bytesOnDisk = 0L;
        }

        public CounterSet getCounterSet() {
            CounterSet counters = new CounterSet();
            counters.addCounter("Concurrency Level", new OneShotInstrument<Integer>(this.globalLRU.getConcurrencyLevel()));
            counters.addCounter("Bytes On Disk", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(GlobalLRUCounters.this.globalLRU.getBytesOnDisk());
                }
            });
            counters.addCounter("Bytes In Memory", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(GlobalLRUCounters.this.globalLRU.getBytesInMemory());
                }
            });
            counters.addCounter("Bytes In Memory Percent Used", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue((double)((int)((double)(10000L * GlobalLRUCounters.this.globalLRU.getBytesInMemory()) / (double)GlobalLRUCounters.this.globalLRU.getMaximumBytesInMemory())) / 10000.0);
                }
            });
            counters.addCounter("Bytes In Memory Maximum Allowed", new OneShotInstrument<Long>(this.globalLRU.getMaximumBytesInMemory()));
            counters.addCounter("Buffered Record Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(GlobalLRUCounters.this.globalLRU.getRecordCount());
                }
            });
            counters.addCounter("Buffered Record Eviction Count", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(GlobalLRUCounters.this.globalLRU.getEvictionCount());
                }
            });
            counters.addCounter("Buffered Record Eviction Byte Count", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(GlobalLRUCounters.this.globalLRU.getEvictionByteCount());
                }
            });
            counters.addCounter("Average Record Size In Memory", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = GlobalLRUCounters.this.globalLRU.getRecordCount();
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(GlobalLRUCounters.this.globalLRU.getBytesInMemory() / tmp));
                }
            });
            counters.addCounter("Average Record Size On Disk", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = GlobalLRUCounters.this.globalLRU.getRecordCount();
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(GlobalLRUCounters.this.globalLRU.getBytesOnDisk() / tmp));
                }
            });
            counters.addCounter("Cache Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(GlobalLRUCounters.this.globalLRU.getCacheSetSize());
                }
            });
            return counters;
        }

        public String toString() {
            return this.getCounterSet().toString();
        }
    }

    private static abstract class TLB<T> {
        public final int id;
        private final int capacity;
        private final int tryLockSize;
        private final Lock lock;
        private T[] a;
        private int size;

        protected TLB(int id, int capacity, int tryLockSize, Lock lock) {
            this.id = id;
            this.capacity = capacity;
            this.tryLockSize = tryLockSize;
            this.lock = lock;
            this.size = 0;
        }

        protected void evict() {
            this.batchUpdates(this.size, this.a);
            this.size = 0;
        }

        protected void clear() {
            if (this.a != null) {
                for (int i = 0; i < this.capacity; ++i) {
                    this.a[i] = null;
                }
            }
            this.size = 0;
        }

        protected abstract void batchUpdates(int var1, T[] var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(T ref) {
            if (this.a == null) {
                this.a = (Object[])Array.newInstance(ref.getClass(), this.capacity);
            }
            this.a[this.size++] = ref;
            if (this.tryLockSize != 0 && this.size == this.tryLockSize) {
                if (this.lock.tryLock()) {
                    try {
                        this.evict();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                return;
            }
            if (this.size == this.capacity) {
                this.lock.lock();
                try {
                    this.evict();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    static class DLNLirs<K, V>
    extends DLN<K, V> {
        V v;
        boolean lir;

        @Override
        protected V v() {
            return this.v;
        }

        DLNLirs(LRUCacheImpl<K, V> cache, K k, V v, boolean lir) {
            super(cache, k, v);
            this.v = v;
            this.lir = lir;
        }
    }

    static class DLNLru<K, V>
    extends DLN<K, V> {
        final V v;

        @Override
        protected V v() {
            return this.v;
        }

        DLNLru(LRUCacheImpl<K, V> cache, K k, V v) {
            super(cache, k, v);
            this.v = v;
        }
    }

    static abstract class DLN<K, V> {
        final LRUCacheImpl<K, V> cache;
        final int bytesInMemory;
        final int bytesOnDisk;
        final K k;
        DLN<K, V> prior;
        DLN<K, V> next;
        volatile boolean delete;

        DLN(LRUCacheImpl<K, V> cache, K k, V v) {
            if (cache == null || k == null || v == null) {
                throw new IllegalArgumentException();
            }
            this.k = k;
            this.next = null;
            this.prior = null;
            this.cache = cache;
            this.bytesInMemory = v instanceof IDataRecordAccess ? ((IDataRecordAccess)v).data().len() : 0;
            this.bytesOnDisk = ((LRUCacheImpl)cache).am != null ? ((LRUCacheImpl)cache).am.getByteCount((Long)k) : 0;
        }

        abstract V v();

        public String toString() {
            return "DLN{key=" + this.k + ",val=" + this.v() + ",prior=" + (this.prior == null ? "N/A" : "" + this.prior.k) + ",next=" + (this.next == null ? "N/A" : "" + this.next.k) + ",bytesInMemory=" + this.bytesInMemory + ",bytesOnDisk=" + this.bytesOnDisk + "}";
        }
    }
}

