/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.BigdataStatics;
import com.bigdata.LRUNexus;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.cache.IGlobalLRU;
import com.bigdata.cache.IHardReferenceGlobalLRU;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.IDataRecordAccess;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IRawStore;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class HardReferenceGlobalLRU<K, V>
implements IHardReferenceGlobalLRU<K, V> {
    private final ConcurrentWeakValueCache<UUID, LRUCacheImpl<K, V>> cacheSet;
    private final LRUCounters counters = new LRUCounters();
    private final ReentrantLock lock = new ReentrantLock(false);
    private final long maximumBytesInMemory;
    private final int initialCacheCapacity;
    private final float loadFactor;
    private volatile int size = 0;
    private volatile Entry<K, V> first = null;
    private volatile Entry<K, V> last = null;

    public HardReferenceGlobalLRU(LRUNexus.CacheSettings s) {
        this(s.maximumBytesInMemory, s.minCacheSetSize, s.initialCacheCapacity, s.loadFactor);
    }

    public HardReferenceGlobalLRU(long maximumBytesInMemory, int minimumCacheSetCapacity, int initialCacheCapacity, float loadFactor) {
        if (maximumBytesInMemory <= 0L) {
            throw new IllegalArgumentException();
        }
        this.maximumBytesInMemory = maximumBytesInMemory;
        this.initialCacheCapacity = initialCacheCapacity;
        this.loadFactor = loadFactor;
        this.cacheSet = new ConcurrentWeakValueCache(minimumCacheSetCapacity);
    }

    @Override
    public IGlobalLRU.ILRUCache<K, V> getCache(UUID uuid, IAddressManager am) {
        LRUCacheImpl<K, V> oldVal;
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        LRUCacheImpl<K, V> cache = this.cacheSet.get(uuid);
        if (cache == null && (oldVal = this.cacheSet.putIfAbsent(uuid, cache = new LRUCacheImpl(uuid, am, this, this.initialCacheCapacity, this.loadFactor))) != null) {
            cache = oldVal;
        }
        return cache;
    }

    @Override
    public int getRecordCount() {
        return this.size;
    }

    @Override
    public long getEvictionCount() {
        return this.counters.evictionCount.get();
    }

    @Override
    public long getBytesOnDisk() {
        return this.counters.bytesOnDisk.get();
    }

    @Override
    public long getBytesInMemory() {
        return this.counters.bytesInMemory.get();
    }

    @Override
    public long getMaximumBytesInMemory() {
        return this.maximumBytesInMemory;
    }

    @Override
    public int getCacheSetSize() {
        return this.cacheSet.size();
    }

    @Override
    public void deleteCache(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        LRUCacheImpl<K, V> cache = this.cacheSet.remove(uuid);
        if (cache != null) {
            cache.clear();
            if (BigdataStatics.debug) {
                System.err.println("Cleared cache: " + uuid);
            }
        } else if (BigdataStatics.debug) {
            System.err.println("No cache: " + uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardAllCaches() {
        this.lock.lock();
        try {
            Iterator<WeakReference<LRUCacheImpl<K, V>>> itr = this.cacheSet.iterator();
            while (itr.hasNext()) {
                LRUCacheImpl cache = (LRUCacheImpl)itr.next().get();
                if (cache == null) continue;
                cache.clear();
            }
            assert (this.size == 0);
            assert (this.first == null);
            assert (this.last == null);
            this.counters.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public CounterSet getCounterSet() {
        CounterSet root = this.counters.getCounterSet();
        Iterator<WeakReference<LRUCacheImpl<K, V>>> itr = this.cacheSet.iterator();
        while (itr.hasNext()) {
            LRUCacheImpl cache = (LRUCacheImpl)itr.next().get();
            if (cache == null) continue;
            root.makePath(cache.storeUUID.toString()).attach(cache.counters.getCounters());
        }
        return root;
    }

    public String toString() {
        return this.getCounterSet().toString();
    }

    private void addEntry(Entry<K, V> e) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (this.first == null) {
            this.first = e;
            this.last = e;
        } else {
            ((Entry)this.last).next = (Entry)e;
            ((Entry)e).prior = (Entry)this.last;
            this.last = e;
        }
        ++this.size;
        this.counters.bytesInMemory.addAndGet(((Entry)e).bytesInMemory);
        this.counters.bytesOnDisk.addAndGet(((Entry)e).bytesOnDisk);
    }

    private V removeEntry(Entry<K, V> e) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (((Entry)e).cache == null) {
            return null;
        }
        Entry prior = ((Entry)e).prior;
        Entry next = ((Entry)e).next;
        if (e == this.first) {
            this.first = next;
        }
        if (this.last == e) {
            this.last = prior;
        }
        if (prior != null) {
            prior.next = next;
        }
        if (next != null) {
            next.prior = prior;
        }
        Object clearedValue = ((Entry)e).v;
        ((Entry)e).prior = null;
        ((Entry)e).next = null;
        ((Entry)e).cache = null;
        ((Entry)e).k = null;
        ((Entry)e).v = null;
        --this.size;
        this.counters.bytesInMemory.addAndGet(-((Entry)e).bytesInMemory);
        this.counters.bytesOnDisk.addAndGet(-((Entry)e).bytesOnDisk);
        return (V)clearedValue;
    }

    private void touchEntry(Entry<K, V> e) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (this.last == e) {
            return;
        }
        Entry prior = ((Entry)e).prior;
        Entry next = ((Entry)e).next;
        if (e == this.first) {
            this.first = next;
        }
        if (this.last == e) {
            this.last = prior;
        }
        if (prior != null) {
            prior.next = next;
        }
        if (next != null) {
            next.prior = prior;
        }
        if (this.first == null) {
            this.first = e;
            this.last = e;
        } else {
            ((Entry)this.last).next = (Entry)e;
            ((Entry)e).prior = (Entry)this.last;
            ((Entry)e).next = null;
            this.last = e;
        }
    }

    private static class LRUCacheImpl<K, V>
    implements IGlobalLRU.ILRUCache<K, V> {
        private final LRUCacheCounters counters = new LRUCacheCounters();
        private final UUID storeUUID;
        private final IAddressManager am;
        private final HardReferenceGlobalLRU<K, V> globalLRU;
        private final ConcurrentHashMap<K, Entry<K, V>> map;

        public LRUCacheImpl(UUID storeUUID, IAddressManager am, HardReferenceGlobalLRU<K, V> lru, int initialCapacity, float loadFactor) {
            if (storeUUID == null) {
                throw new IllegalArgumentException();
            }
            assert (!(am instanceof IRawStore)) : am.getClass().getName() + " implements " + IRawStore.class.getName();
            if (lru == null) {
                throw new IllegalArgumentException();
            }
            this.storeUUID = storeUUID;
            this.am = am;
            this.globalLRU = lru;
            this.map = new ConcurrentHashMap(initialCapacity, loadFactor);
        }

        @Override
        public IAddressManager getAddressManager() {
            return this.am;
        }

        @Override
        public UUID getStoreUUID() {
            return this.storeUUID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ((HardReferenceGlobalLRU)this.globalLRU).lock.lock();
            try {
                Iterator<Entry<K, V>> itr = this.map.values().iterator();
                while (itr.hasNext()) {
                    Entry<K, V> e = itr.next();
                    itr.remove();
                    ((HardReferenceGlobalLRU)this.globalLRU).removeEntry(e);
                }
                this.counters.clear();
            }
            finally {
                ((HardReferenceGlobalLRU)this.globalLRU).lock.unlock();
            }
        }

        @Override
        public int size() {
            return this.map.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K k, V v) {
            if (k == null) {
                throw new IllegalArgumentException();
            }
            if (v == null) {
                throw new IllegalArgumentException();
            }
            ((HardReferenceGlobalLRU)this.globalLRU).lock.lock();
            try {
                Entry<K, V> entry = this.map.get(k);
                if (entry != null) {
                    ((HardReferenceGlobalLRU)this.globalLRU).touchEntry(entry);
                    Object object = ((Entry)entry).v;
                    return (V)object;
                }
                if (((HardReferenceGlobalLRU)this.globalLRU).counters.bytesInMemory.get() >= ((HardReferenceGlobalLRU)this.globalLRU).maximumBytesInMemory) {
                    Object evictedKey;
                    while (((HardReferenceGlobalLRU)this.globalLRU).counters.bytesInMemory.get() >= ((HardReferenceGlobalLRU)this.globalLRU).maximumBytesInMemory) {
                        entry = ((HardReferenceGlobalLRU)this.globalLRU).first;
                        evictedKey = ((Entry)entry).k;
                        LRUCacheImpl evictedFromCache = ((Entry)entry).cache;
                        ((HardReferenceGlobalLRU)this.globalLRU).removeEntry(entry);
                        evictedFromCache.remove(evictedKey);
                        ((HardReferenceGlobalLRU)this.globalLRU).counters.evictionCount.incrementAndGet();
                    }
                    assert (entry != null);
                    entry = new Entry<K, V>(this, k, v);
                    this.map.put(k, entry);
                    ((HardReferenceGlobalLRU)this.globalLRU).addEntry(entry);
                    this.counters.ninserts++;
                    evictedKey = null;
                    return (V)evictedKey;
                }
                entry = new Entry<K, V>(this, k, v);
                this.map.put(k, entry);
                ((HardReferenceGlobalLRU)this.globalLRU).addEntry(entry);
                int count = this.map.size();
                if (count > this.counters.highTide) {
                    this.counters.highTide = count;
                }
                this.counters.ninserts++;
                V v2 = null;
                return v2;
            }
            finally {
                ((HardReferenceGlobalLRU)this.globalLRU).lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(K key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            this.counters.ntests++;
            Entry<K, V> entry = this.map.get(key);
            if (entry == null) {
                return null;
            }
            ((HardReferenceGlobalLRU)this.globalLRU).lock.lock();
            try {
                ((HardReferenceGlobalLRU)this.globalLRU).touchEntry(entry);
                this.counters.nsuccess++;
                Object object = ((Entry)entry).v;
                return (V)object;
            }
            finally {
                ((HardReferenceGlobalLRU)this.globalLRU).lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(K key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            Entry<K, V> entry = this.map.remove(key);
            if (entry == null) {
                return null;
            }
            ((HardReferenceGlobalLRU)this.globalLRU).lock.lock();
            try {
                Object object = ((HardReferenceGlobalLRU)this.globalLRU).removeEntry(entry);
                return (V)object;
            }
            finally {
                ((HardReferenceGlobalLRU)this.globalLRU).lock.unlock();
            }
        }

        public String toString() {
            return super.toString() + "{" + this.counters.toString() + "}";
        }

        private class LRUCacheCounters {
            private int highTide = 0;
            private long ninserts = 0L;
            private long ntests = 0L;
            private long nsuccess = 0L;

            private LRUCacheCounters() {
            }

            public void clear() {
                this.highTide = 0;
                this.nsuccess = 0L;
                this.ntests = 0L;
                this.ninserts = 0L;
            }

            public CounterSet getCounters() {
                CounterSet c = new CounterSet();
                c.addCounter("highTide", new Instrument<Integer>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheCounters.this.highTide);
                    }
                });
                c.addCounter("size", new Instrument<Integer>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheImpl.this.size());
                    }
                });
                c.addCounter("ninserts", new Instrument<Long>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheCounters.this.ninserts);
                    }
                });
                c.addCounter("ntests", new Instrument<Long>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheCounters.this.ntests);
                    }
                });
                c.addCounter("nsuccess", new Instrument<Long>(){

                    @Override
                    protected void sample() {
                        this.setValue(LRUCacheCounters.this.nsuccess);
                    }
                });
                c.addCounter("hitRatio", new Instrument<Double>(){

                    @Override
                    protected void sample() {
                        long tmp = LRUCacheCounters.this.ntests;
                        this.setValue(tmp == 0L ? 0.0 : (double)LRUCacheCounters.this.nsuccess / (double)tmp);
                    }
                });
                return c;
            }

            public String toString() {
                return this.getCounters().toString();
            }
        }
    }

    private static final class Entry<K, V> {
        private Entry<K, V> prior;
        private Entry<K, V> next;
        private K k;
        private V v;
        private LRUCacheImpl<K, V> cache;
        private final int bytesInMemory;
        private final int bytesOnDisk;

        Entry(LRUCacheImpl<K, V> cache, K k, V v) {
            this.k = k;
            this.v = v;
            this.cache = cache;
            this.bytesInMemory = v instanceof IDataRecordAccess ? ((IDataRecordAccess)v).data().len() : 0;
            this.bytesOnDisk = ((LRUCacheImpl)cache).am != null ? ((LRUCacheImpl)cache).am.getByteCount((Long)k) : 0;
        }

        public String toString() {
            return "Entry{key=" + this.k + ",val=" + this.v + ",prior=" + (this.prior == null ? "N/A" : "" + this.prior.k) + ",next=" + (this.next == null ? "N/A" : "" + this.next.k) + ",bytesInMemory=" + this.bytesInMemory + ",bytesOnDisk=" + this.bytesOnDisk + "}";
        }
    }

    private class LRUCounters {
        private final AtomicLong bytesOnDisk = new AtomicLong();
        private final AtomicLong bytesInMemory = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();

        private LRUCounters() {
        }

        public void clear() {
            this.bytesOnDisk.set(0L);
            this.bytesInMemory.set(0L);
            this.evictionCount.set(0L);
        }

        public CounterSet getCounterSet() {
            CounterSet counters = new CounterSet();
            counters.addCounter("Bytes On Disk", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.bytesOnDisk.get());
                }
            });
            counters.addCounter("Bytes In Memory", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.bytesInMemory.get());
                }
            });
            counters.addCounter("Bytes In Memory Percent Used", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue((double)((int)((double)(10000L * LRUCounters.this.bytesInMemory.get()) / (double)HardReferenceGlobalLRU.this.maximumBytesInMemory)) / 10000.0);
                }
            });
            counters.addCounter("Bytes In Memory Maximum Allowed", new OneShotInstrument<Long>(HardReferenceGlobalLRU.this.maximumBytesInMemory));
            counters.addCounter("Buffered Record Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(HardReferenceGlobalLRU.this.size);
                }
            });
            counters.addCounter("Buffered Record Eviction Count", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.evictionCount.get());
                }
            });
            counters.addCounter("Average Record Size In Memory", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = HardReferenceGlobalLRU.this.size;
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(LRUCounters.this.bytesInMemory.get() / tmp));
                }
            });
            counters.addCounter("Average Record Size On Disk", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = HardReferenceGlobalLRU.this.size;
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(LRUCounters.this.bytesOnDisk.get() / tmp));
                }
            });
            counters.addCounter("Cache Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(HardReferenceGlobalLRU.this.cacheSet.size());
                }
            });
            return counters;
        }

        public String toString() {
            return this.getCounterSet().toString();
        }
    }
}

