/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSet;
import com.bigdata.rawstore.IAddressManager;
import java.util.UUID;

public interface IGlobalLRU<K, V> {
    public ILRUCache<K, V> getCache(UUID var1, IAddressManager var2);

    public void deleteCache(UUID var1);

    public void discardAllCaches();

    public CounterSet getCounterSet();

    public int getRecordCount();

    public long getEvictionCount();

    public long getBytesInMemory();

    public long getBytesOnDisk();

    public long getMaximumBytesInMemory();

    public int getCacheSetSize();

    public static interface IGlobalLRUCounters
    extends ICounterSet {
        public static final String CONCURRENCY_LEVEL = "Concurrency Level";
        public static final String BYTES_ON_DISK = "Bytes On Disk";
        public static final String BYTES_IN_MEMORY = "Bytes In Memory";
        public static final String MAXIMUM_ALLOWED_BYTES_IN_MEMORY = "Bytes In Memory Maximum Allowed";
        public static final String PERCENT_BYTES_IN_MEMORY = "Bytes In Memory Percent Used";
        public static final String BUFFERED_RECORD_COUNT = "Buffered Record Count";
        public static final String BUFFERED_RECORD_EVICTION_COUNT = "Buffered Record Eviction Count";
        public static final String BUFFERED_RECORD_EVICTION_BYTE_COUNT = "Buffered Record Eviction Byte Count";
        public static final String AVERAGE_RECORD_SIZE_ON_DISK = "Average Record Size On Disk";
        public static final String AVERAGE_RECORD_SIZE_IN_MEMORY = "Average Record Size In Memory";
        public static final String CACHE_COUNT = "Cache Count";
    }

    public static interface ILRUCache<K, V> {
        public UUID getStoreUUID();

        public IAddressManager getAddressManager();

        public V putIfAbsent(K var1, V var2);

        public V get(K var1);

        public V remove(K var1);

        public void clear();

        public int size();
    }
}

