/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.BigdataStatics;
import com.bigdata.LRUNexus;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.cache.IGlobalLRU;
import com.bigdata.cache.IHardReferenceGlobalLRU;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.IDataRecordAccess;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IRawStore;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class StoreAndAddressLRUCache<V>
implements IHardReferenceGlobalLRU<Long, V> {
    private final long maximumBytesInMemory;
    private final ConcurrentWeakValueCache<UUID, InnerCacheImpl> cacheSet;
    private final Map<K, V> map;
    private final LRUCounters counters = new LRUCounters();

    public StoreAndAddressLRUCache(LRUNexus.CacheSettings s) {
        this(s.maximumBytesInMemory, s.minCacheSetSize, s.initialCacheCapacity, s.loadFactor);
    }

    public StoreAndAddressLRUCache(long maximumBytesInMemory, int minimumCacheSetCapacity, int initialCacheCapacity, float loadFactor) {
        if (maximumBytesInMemory <= 0L) {
            throw new IllegalArgumentException();
        }
        this.maximumBytesInMemory = maximumBytesInMemory;
        this.cacheSet = new ConcurrentWeakValueCache(minimumCacheSetCapacity);
        this.map = Collections.synchronizedMap(new LinkedHashMap<K, V>(initialCacheCapacity, loadFactor, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (StoreAndAddressLRUCache.this.counters.bytesInMemory.get() >= StoreAndAddressLRUCache.this.maximumBytesInMemory) {
                    StoreAndAddressLRUCache.this.counters.bytesInMemory.addAndGet(eldest.getKey().bytesInMemory);
                    StoreAndAddressLRUCache.this.counters.bytesOnDisk.addAndGet(eldest.getKey().bytesOnDisk);
                    StoreAndAddressLRUCache.this.counters.evictionCount.incrementAndGet();
                    StoreAndAddressLRUCache.this.counters.evictionByteCount.addAndGet(eldest.getKey().bytesInMemory);
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public int getRecordCount() {
        return this.map.size();
    }

    @Override
    public long getEvictionCount() {
        return this.counters.evictionCount.get();
    }

    public long getEvictionByteCount() {
        return this.counters.evictionByteCount.get();
    }

    @Override
    public long getBytesOnDisk() {
        return this.counters.bytesOnDisk.get();
    }

    @Override
    public long getBytesInMemory() {
        return this.counters.bytesInMemory.get();
    }

    @Override
    public long getMaximumBytesInMemory() {
        return this.maximumBytesInMemory;
    }

    @Override
    public int getCacheSetSize() {
        return this.cacheSet.size();
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public IGlobalLRU.ILRUCache<Long, V> getCache(UUID uuid, IAddressManager am) {
        InnerCacheImpl oldVal;
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        InnerCacheImpl cache = this.cacheSet.get(uuid);
        if (cache == null && (oldVal = this.cacheSet.putIfAbsent(uuid, cache = new InnerCacheImpl(uuid, am))) != null) {
            cache = oldVal;
        }
        return cache;
    }

    @Override
    public void deleteCache(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        InnerCacheImpl cache = this.cacheSet.remove(uuid);
        if (cache != null) {
            cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardAllCaches() {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.cacheSet.clear();
            this.map.clear();
            this.counters.clear();
        }
    }

    @Override
    public CounterSet getCounterSet() {
        return this.counters.getCounterSet();
    }

    public String toString() {
        String t = this.getCounterSet().toString();
        if (!BigdataStatics.debug) {
            return t;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(t);
        Iterator<WeakReference<InnerCacheImpl>> itr = this.cacheSet.iterator();
        while (itr.hasNext()) {
            InnerCacheImpl cache = (InnerCacheImpl)itr.next().get();
            if (cache == null) continue;
            sb.append("\ncache: storeClass=" + cache.getStoreUUID() + ", size=" + cache.size());
        }
        return sb.toString();
    }

    private class InnerCacheImpl
    implements IGlobalLRU.ILRUCache<Long, V> {
        private final UUID storeUUID;
        private final IAddressManager am;

        @Override
        public IAddressManager getAddressManager() {
            return this.am;
        }

        @Override
        public UUID getStoreUUID() {
            return this.storeUUID;
        }

        public InnerCacheImpl(UUID storeUUID, IAddressManager am) {
            if (storeUUID == null) {
                throw new IllegalArgumentException();
            }
            assert (!(am instanceof IRawStore)) : am.getClass().getName() + " implements " + IRawStore.class.getName();
            this.storeUUID = storeUUID;
            this.am = am;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Map map = StoreAndAddressLRUCache.this.map;
            synchronized (map) {
                Iterator itr = StoreAndAddressLRUCache.this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry e = itr.next();
                    if (!((K)e.getKey()).storeUUID.equals(this.storeUUID)) continue;
                    itr.remove();
                    StoreAndAddressLRUCache.this.counters.bytesOnDisk.addAndGet(-((K)e.getKey()).bytesOnDisk);
                    StoreAndAddressLRUCache.this.counters.bytesInMemory.addAndGet(-((K)e.getKey()).bytesInMemory);
                }
            }
        }

        @Override
        public V get(Long k) {
            return StoreAndAddressLRUCache.this.map.get(new K(this.storeUUID, k));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(Long k, V v) {
            Map map = StoreAndAddressLRUCache.this.map;
            synchronized (map) {
                K k1 = new K(this.storeUUID, k, this.bytesOnDisk(k), this.bytesInMemory(v));
                Object old = StoreAndAddressLRUCache.this.map.get(k1);
                if (old != null) {
                    return old;
                }
                StoreAndAddressLRUCache.this.counters.bytesOnDisk.addAndGet(k1.bytesOnDisk);
                StoreAndAddressLRUCache.this.counters.bytesInMemory.addAndGet(k1.bytesInMemory);
                return StoreAndAddressLRUCache.this.map.put(k1, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Long k) {
            Map map = StoreAndAddressLRUCache.this.map;
            synchronized (map) {
                Object v = StoreAndAddressLRUCache.this.map.remove(new K(this.storeUUID, k));
                if (v != null) {
                    StoreAndAddressLRUCache.this.counters.bytesOnDisk.addAndGet(-this.bytesOnDisk(k));
                    StoreAndAddressLRUCache.this.counters.bytesInMemory.addAndGet(-this.bytesInMemory(v));
                }
                return v;
            }
        }

        private int bytesOnDisk(long addr) {
            if (this.am != null) {
                return this.am.getByteCount(addr);
            }
            return 0;
        }

        private int bytesInMemory(V v) {
            if (v instanceof IDataRecordAccess) {
                return ((IDataRecordAccess)v).data().len();
            }
            return 0;
        }

        @Override
        public int size() {
            return StoreAndAddressLRUCache.this.map.size();
        }
    }

    private class LRUCounters {
        private final AtomicLong bytesOnDisk = new AtomicLong();
        private final AtomicLong bytesInMemory = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();
        private final AtomicLong evictionByteCount = new AtomicLong();

        private LRUCounters() {
        }

        public void clear() {
            this.bytesOnDisk.set(0L);
            this.bytesInMemory.set(0L);
            this.evictionCount.set(0L);
            this.evictionByteCount.set(0L);
        }

        public CounterSet getCounterSet() {
            CounterSet counters = new CounterSet();
            counters.addCounter("Bytes On Disk", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.bytesOnDisk.get());
                }
            });
            counters.addCounter("Bytes In Memory", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.bytesInMemory.get());
                }
            });
            counters.addCounter("Bytes In Memory Percent Used", new Instrument<Double>(){

                @Override
                protected void sample() {
                    this.setValue((double)((int)((double)(10000L * LRUCounters.this.bytesInMemory.get()) / (double)StoreAndAddressLRUCache.this.maximumBytesInMemory)) / 10000.0);
                }
            });
            counters.addCounter("Bytes In Memory Maximum Allowed", new OneShotInstrument<Long>(StoreAndAddressLRUCache.this.maximumBytesInMemory));
            counters.addCounter("Buffered Record Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(StoreAndAddressLRUCache.this.size());
                }
            });
            counters.addCounter("Buffered Record Eviction Count", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.evictionCount.get());
                }
            });
            counters.addCounter("Buffered Record Eviction Byte Count", new Instrument<Long>(){

                @Override
                protected void sample() {
                    this.setValue(LRUCounters.this.evictionByteCount.get());
                }
            });
            counters.addCounter("Average Record Size In Memory", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = StoreAndAddressLRUCache.this.size();
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(LRUCounters.this.bytesInMemory.get() / tmp));
                }
            });
            counters.addCounter("Average Record Size On Disk", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    long tmp = StoreAndAddressLRUCache.this.size();
                    if (tmp == 0L) {
                        this.setValue(0);
                        return;
                    }
                    this.setValue((int)(LRUCounters.this.bytesOnDisk.get() / tmp));
                }
            });
            counters.addCounter("Cache Count", new Instrument<Integer>(){

                @Override
                protected void sample() {
                    this.setValue(StoreAndAddressLRUCache.this.cacheSet.size());
                }
            });
            return counters;
        }

        public String toString() {
            return this.getCounterSet().toString();
        }
    }

    private static class K {
        static final int mask1 = 0x10101010;
        static final int mask2 = -269488145;
        final UUID storeUUID;
        final long addr;
        final int hash;
        int bytesInMemory;
        int bytesOnDisk;

        public K(UUID storeUUID, long addr) {
            this.storeUUID = storeUUID;
            this.addr = addr;
            int addrHash = (int)(addr ^ addr >>> 32);
            this.hash = storeUUID.hashCode() & 0x10101010 | addrHash & 0xEFEFEFEF;
        }

        public K(UUID storeUUID, long addr, int bytesOnDisk, int bytesInMemory) {
            this(storeUUID, addr);
            this.bytesOnDisk = bytesOnDisk;
            this.bytesInMemory = bytesInMemory;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof K)) {
                return false;
            }
            K o1 = (K)o;
            return this.addr == o1.addr && this.storeUUID.equals(o1.storeUUID);
        }
    }
}

