/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.ActiveProcess;
import com.bigdata.counters.IStatisticsCollector;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractProcessCollector
implements IStatisticsCollector {
    protected static final Logger log = Logger.getLogger(AbstractProcessCollector.class);
    private final int interval;
    protected ActiveProcess activeProcess;

    @Override
    public int getInterval() {
        return this.interval;
    }

    public AbstractProcessCollector(int interval) {
        if (interval == 0) {
            throw new IllegalArgumentException();
        }
        this.interval = interval;
    }

    protected void setEnvironment(Map<String, String> env) {
    }

    @Override
    public void start() {
        log.info((Object)"");
        this.activeProcess = new ActiveProcess(this.getCommand(), this);
        this.activeProcess.start(this.getProcessReader());
    }

    @Override
    public void stop() {
        log.info((Object)"");
        if (this.activeProcess != null) {
            this.activeProcess.stop();
            this.activeProcess = null;
        }
    }

    public abstract List<String> getCommand();

    public abstract AbstractProcessReader getProcessReader();
}

