/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.History;
import com.bigdata.counters.IHistoryEntry;
import com.bigdata.counters.TimestampOrderException;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class History<T> {
    protected static final Logger log = Logger.getLogger(History.class);
    private final History source;
    private final int capacity;
    private final long period;
    private final boolean overwrite;
    private final boolean _numeric;
    private final boolean _long;
    private final boolean _double;
    private History<T> sink;
    private final long[] timestamps;
    private final T[] data;
    private final int[] counts;
    private int size = 0;
    private long lastLogicalSlot = -1L;

    public long getPeriod() {
        return this.period;
    }

    public History getSource() {
        return this.source;
    }

    public int capacity() {
        return this.capacity;
    }

    public int size() {
        return this.size;
    }

    public boolean isNumeric() {
        return this._numeric;
    }

    public boolean isLong() {
        return this._long;
    }

    public boolean isDouble() {
        return this._double;
    }

    public Class getValueType() {
        return this.data.getClass().getComponentType();
    }

    public synchronized IHistoryEntry<T> getSample() {
        if (this.lastLogicalSlot == -1L) {
            return null;
        }
        int physicalSlot = (int)(this.lastLogicalSlot % (long)this.capacity);
        final long lastModified = this.timestamps[physicalSlot];
        final T value = this.data[physicalSlot];
        if (value == null) {
            return null;
        }
        final int count = this.counts[physicalSlot];
        assert (count >= 1);
        return new IHistoryEntry<T>(){

            @Override
            public long lastModified() {
                return lastModified;
            }

            @Override
            public T getValue() {
                if (History.this.isNumeric()) {
                    return History.this.valueOf(((Number)value).doubleValue() / (double)count);
                }
                return value;
            }

            @Override
            public T getTotal() {
                return value;
            }

            @Override
            public int getCount() {
                return count;
            }

            public String toString() {
                return "(" + value + ", count=" + count + "," + new Date(lastModified) + ")";
            }
        };
    }

    public synchronized SampleIterator iterator() {
        return new SampleIterator();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        SampleIterator itr = this.iterator();
        int n = 0;
        while (itr.hasNext()) {
            IHistoryEntry entry = (IHistoryEntry)itr.next();
            sb.append("(" + entry.getValue() + "," + entry.getCount() + ", " + new Date(entry.lastModified()) + ")");
            if (itr.hasNext()) {
                sb.append(",");
            }
            ++n;
        }
        T average = this.getAverage();
        sb.append("},average=" + average + ",n=" + n);
        return sb.toString();
    }

    public T getAverage() {
        return this.getAverage(this.capacity);
    }

    public synchronized T getAverage(int nperiods) {
        long firstLogicalSlot;
        if (!this.isNumeric()) {
            return null;
        }
        if (nperiods < 1 || nperiods > this.capacity) {
            throw new IllegalArgumentException("Must be in [0:" + this.capacity + "], not " + nperiods);
        }
        if (this.lastLogicalSlot == -1L) {
            return this.valueOf(0.0);
        }
        double total = 0.0;
        int n = 0;
        int tmpi = (int)(this.lastLogicalSlot % (long)this.capacity);
        assert (tmpi >= 0 && tmpi < this.capacity) : "index=" + tmpi + ", lastLogicalSlot=" + this.lastLogicalSlot + ", capacity=" + this.capacity;
        long currentLogicalSlot = this.timestamps[tmpi] / this.period;
        for (long ls = firstLogicalSlot = this.lastLogicalSlot - (long)nperiods + 1L; ls <= currentLogicalSlot; ++ls) {
            int physicalSlot = (int)(ls % (long)this.capacity);
            if (this.data[physicalSlot] == null) continue;
            int count = this.counts[physicalSlot];
            assert (count > 0);
            double value = ((Number)this.data[physicalSlot]).doubleValue();
            total += value;
            n += count;
        }
        if (n == 0) {
            return this.valueOf(0.0);
        }
        return this.valueOf(total / (double)n);
    }

    protected T valueOf(double d) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException();
        }
        if (this.isLong()) {
            return (T)Long.valueOf((long)d);
        }
        if (this.isDouble()) {
            return (T)Double.valueOf(d);
        }
        throw new AssertionError();
    }

    public synchronized void add(long timestamp, T value) {
        if (log.isInfoEnabled()) {
            log.info((Object)("timestamp=" + timestamp + ", value=" + value));
        }
        if (timestamp <= 0L) {
            throw new IllegalArgumentException("timestamp=" + timestamp + ", value=" + value);
        }
        long logicalSlot = timestamp / this.period;
        if (this.lastLogicalSlot != -1L && this.lastLogicalSlot - logicalSlot >= (long)this.capacity && log.isInfoEnabled()) {
            log.info((Object)"Timestamp out of order?", (Throwable)new TimestampOrderException("timestamp=" + timestamp + ", value=" + value));
        }
        int physicalSlot = (int)(logicalSlot % (long)this.capacity);
        if (this.lastLogicalSlot == -1L) {
            assert (this.lastLogicalSlot == -1L);
            assert (this.size == 0);
            this.timestamps[physicalSlot] = timestamp;
            this.counts[physicalSlot] = 1;
            this.data[physicalSlot] = value;
            this.size = 1;
        } else {
            int lastPhysicalSlot = (int)(this.lastLogicalSlot % (long)this.capacity);
            long lastModified = this.timestamps[lastPhysicalSlot];
            assert (lastModified > 0L) : "lastModified=" + lastModified;
            for (long ls = this.lastLogicalSlot + 1L; ls <= logicalSlot; ++ls) {
                int ps = (int)(ls % (long)this.capacity);
                if (ps == 0 && this.sink != null) {
                    long t = ls * this.period;
                    T avg = this.getAverage();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("overflow: t=" + t + ", avg=" + avg));
                    }
                    this.sink.add(t, avg);
                }
                if (this.data[ps] == null) continue;
                if (!this.overwrite) {
                    throw new RuntimeException("Would overwrite data: ps=" + ps + ", capacity=" + this.capacity + ", size=" + this.size);
                }
                --this.size;
                assert (this.size >= 0) : "size=" + this.size;
                this.data[ps] = null;
                this.counts[ps] = 0;
                this.timestamps[ps] = 0L;
            }
            if (this.data[physicalSlot] == null) {
                ++this.size;
            }
            this.data[physicalSlot] = this.data[physicalSlot] == null || !this.isNumeric() ? value : this.valueOf(((Number)this.data[physicalSlot]).doubleValue() + ((Number)value).doubleValue());
            int n = physicalSlot;
            this.counts[n] = this.counts[n] + 1;
            this.timestamps[physicalSlot] = timestamp;
            if (this.size > this.capacity) {
                log.warn((Object)("size=" + this.size + ", capacity=" + this.capacity));
            }
        }
        this.lastLogicalSlot = Math.max(this.lastLogicalSlot, logicalSlot);
    }

    public History(T[] data, long period, boolean overwrite) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        if (data.length == 0) {
            throw new IllegalArgumentException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        this.capacity = data.length;
        this.source = null;
        this.period = period;
        this.overwrite = overwrite;
        this.timestamps = new long[this.capacity];
        this.counts = new int[this.capacity];
        this.data = data;
        Class<?> ctype = data.getClass().getComponentType();
        this._long = ctype == Long.class;
        this._double = ctype == Double.class;
        this._numeric = this._long || this._double;
    }

    protected History(int capacity, History<T> source) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.source = source;
        this.period = source.period * (long)capacity;
        this.overwrite = true;
        this.timestamps = new long[capacity];
        this.counts = new int[capacity];
        this.data = (Object[])Array.newInstance(source.data.getClass().getComponentType(), capacity);
        source.sink = this;
        Class<?> ctype = this.data.getClass().getComponentType();
        this._long = ctype == Long.class;
        this._double = ctype == Double.class;
        this._numeric = this._long || this._double;
    }

    protected History<T> getSink() {
        return this.sink;
    }

    public class SampleIterator
    implements Iterator<IHistoryEntry<T>> {
        private final int n;
        private int current = -1;
        private final long[] _timestamps;
        private final int[] _counts;
        private final T[] _data;
        private final com.bigdata.counters.History$SampleIterator.Entry entry = new Entry();

        public int getSampleCount() {
            return this.n;
        }

        public long getFirstSampleTime() {
            if (this.n == 0) {
                return -1L;
            }
            return this._timestamps[0];
        }

        public long getLastSampleTime() {
            if (this.n == 0) {
                return -1L;
            }
            return this._timestamps[this.n - 1];
        }

        protected SampleIterator() {
            int physicalSlot;
            long ls;
            if (History.this.lastLogicalSlot == -1L) {
                this.n = 0;
                this._timestamps = null;
                this._counts = null;
                this._data = null;
                return;
            }
            long t = Long.MAX_VALUE;
            for (int i = 0; i < History.this.capacity; ++i) {
                if (!(History.this.timestamps[i] != 0L & History.this.timestamps[i] < t)) continue;
                t = History.this.timestamps[i];
            }
            long firstSampleTime = t;
            long firstLogicalSlot = firstSampleTime / History.this.period;
            long lastLogicalSlot = firstLogicalSlot + (long)History.this.capacity;
            int count = 0;
            for (ls = firstLogicalSlot; ls < lastLogicalSlot; ++ls) {
                physicalSlot = (int)(ls % (long)History.this.capacity);
                if (History.this.data[physicalSlot] == null) continue;
                ++count;
            }
            this.n = count;
            this._timestamps = new long[this.n];
            this._counts = new int[this.n];
            this._data = (Object[])Array.newInstance(History.this.data.getClass().getComponentType(), this.n);
            count = 0;
            for (ls = firstLogicalSlot; ls < lastLogicalSlot; ++ls) {
                physicalSlot = (int)(ls % (long)History.this.capacity);
                if (History.this.data[physicalSlot] == null) continue;
                this._timestamps[count] = History.this.timestamps[physicalSlot];
                this._counts[count] = History.this.counts[physicalSlot];
                this._data[count] = History.this.data[physicalSlot];
                ++count;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current + 1 < this.n;
        }

        @Override
        public IHistoryEntry<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.current;
            return this.entry.clone();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class Entry
        implements IHistoryEntry<T>,
        Cloneable {
            private Entry() {
            }

            public IHistoryEntry<T> clone() {
                final int count = SampleIterator.this._counts[SampleIterator.this.current];
                final long lastModified = SampleIterator.this._timestamps[SampleIterator.this.current];
                final Object total = SampleIterator.this._data[SampleIterator.this.current];
                final Object value = this.getValue();
                return new IHistoryEntry<T>(){

                    @Override
                    public int getCount() {
                        return count;
                    }

                    @Override
                    public T getTotal() {
                        return total;
                    }

                    @Override
                    public T getValue() {
                        return value;
                    }

                    @Override
                    public long lastModified() {
                        return lastModified;
                    }

                    public String toString() {
                        return "(" + this.getValue() + ", " + this.getCount() + "," + new Date(this.lastModified()) + ")";
                    }
                };
            }

            @Override
            public long lastModified() {
                return SampleIterator.this._timestamps[SampleIterator.this.current];
            }

            @Override
            public T getValue() {
                int count = SampleIterator.this._counts[SampleIterator.this.current];
                assert (count > 0);
                Object value = SampleIterator.this._data[SampleIterator.this.current];
                if (History.this.isNumeric()) {
                    return History.this.valueOf(((Number)value).doubleValue() / (double)count);
                }
                return value;
            }

            @Override
            public int getCount() {
                return SampleIterator.this._counts[SampleIterator.this.current];
            }

            @Override
            public T getTotal() {
                return SampleIterator.this._data[SampleIterator.this.current];
            }

            public String toString() {
                return "(" + this.getValue() + ", " + this.getCount() + "," + new Date(this.lastModified()) + ")";
            }
        }
    }
}

