/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.linux;

import com.bigdata.counters.AbstractProcessCollector;
import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.ActiveProcess;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterHierarchy;
import com.bigdata.counters.IHostCounters;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.IRequiredHostCounters;
import com.bigdata.counters.ProcessReaderHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class VMStatCollector
extends AbstractProcessCollector
implements ICounterHierarchy,
IRequiredHostCounters,
IHostCounters {
    private final Map<String, Object> vals = new ConcurrentHashMap<String, Object>();
    private final AtomicLong lastModified = new AtomicLong(System.currentTimeMillis());
    private final boolean cpuStats;
    static final Pattern pattern = Pattern.compile("\\s+");

    public VMStatCollector(int interval, boolean cpuStats) {
        super(interval);
        this.cpuStats = cpuStats;
    }

    @Override
    public List<String> getCommand() {
        LinkedList<String> command = new LinkedList<String>();
        command.add("/usr/bin/vmstat");
        command.add("-n");
        command.add("" + this.getInterval());
        return command;
    }

    @Override
    public CounterSet getCounters() {
        LinkedList<DI> inst = new LinkedList<DI>();
        inst.add(new DI("Memory/Major Page Faults Per Second", 1.0));
        inst.add(new DI("Memory/Swap Bytes Used", 1024.0));
        inst.add(new DI("Memory/Bytes Free", 1024.0));
        inst.add(new DI("PhysicalDisk/Bytes Read Per Second", 1024.0));
        inst.add(new DI("PhysicalDisk/Bytes Written Per Second", 1024.0));
        if (this.cpuStats) {
            inst.add(new DI("CPU/% Processor Time", 0.01));
            inst.add(new DI("CPU/% User Time", 0.01));
            inst.add(new DI("CPU/% System Time", 0.01));
            inst.add(new DI("CPU/% IO Wait", 0.01));
        }
        CounterSet root = new CounterSet();
        for (I i : inst) {
            root.addCounter(i.getPath(), i);
        }
        return root;
    }

    @Override
    public AbstractProcessReader getProcessReader() {
        return new VMStatReader();
    }

    private class VMStatReader
    extends ProcessReaderHelper {
        @Override
        protected ActiveProcess getActiveProcess() {
            if (VMStatCollector.this.activeProcess == null) {
                throw new IllegalStateException();
            }
            return VMStatCollector.this.activeProcess;
        }

        @Override
        protected void readProcess() throws Exception {
            if (log.isInfoEnabled()) {
                log.info((Object)"begin");
            }
            for (int i = 0; i < 10 && !this.getActiveProcess().isAlive(); ++i) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"waiting for the readerFuture to be set.");
                }
                Thread.sleep(100L);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"running");
            }
            String header = this.readLine();
            if (log.isInfoEnabled()) {
                log.info((Object)("header: " + header));
            }
            header = this.readLine();
            if (log.isInfoEnabled()) {
                log.info((Object)("header: " + header));
            }
            while (true) {
                String data = this.readLine();
                try {
                    VMStatCollector.this.lastModified.set(System.currentTimeMillis());
                    String[] fields = pattern.split(data.trim(), 0);
                    String swpd = fields[2];
                    String free = fields[3];
                    String si = fields[6];
                    String so = fields[7];
                    String bi = fields[8];
                    String bo = fields[9];
                    String user = fields[12];
                    String system = fields[13];
                    String idle = fields[14];
                    String iowait = fields[15];
                    if (log.isInfoEnabled()) {
                        log.info((Object)("\nswpd=" + swpd + ", free=" + free + ", si=" + si + ", so=" + so + ", bi=" + bi + ", bo=" + bo + ", %user=" + user + ", %system=" + system + ", idle=" + idle + ", iowait=" + iowait + "\n" + header + "\n" + data));
                    }
                    VMStatCollector.this.vals.put("Memory/Swap Bytes Used", Double.parseDouble(swpd));
                    VMStatCollector.this.vals.put("Memory/Bytes Free", Double.parseDouble(free));
                    VMStatCollector.this.vals.put("Memory/Major Page Faults Per Second", Double.parseDouble(si));
                    VMStatCollector.this.vals.put("PhysicalDisk/Bytes Read Per Second", Double.parseDouble(bi));
                    VMStatCollector.this.vals.put("PhysicalDisk/Bytes Written Per Second", Double.parseDouble(bo));
                    if (!VMStatCollector.this.cpuStats) continue;
                    VMStatCollector.this.vals.put("CPU/% User Time", Double.parseDouble(user));
                    VMStatCollector.this.vals.put("CPU/% System Time", Double.parseDouble(system));
                    VMStatCollector.this.vals.put("CPU/% IO Wait", Double.parseDouble(iowait));
                    VMStatCollector.this.vals.put("CPU/% Processor Time", 100.0 - Double.parseDouble(idle));
                    continue;
                }
                catch (Exception ex) {
                    log.warn((Object)(ex.getMessage() + "\nheader: " + header + "\n  data: " + data), (Throwable)ex);
                    continue;
                }
                break;
            }
        }
    }

    class DI
    extends I<Double> {
        protected final double scale;

        DI(String path, double scale) {
            super(path);
            this.scale = scale;
        }

        @Override
        public Double getValue() {
            Double value = (Double)VMStatCollector.this.vals.get(this.path);
            if (value == null) {
                return 0.0;
            }
            double d = value * this.scale;
            return d;
        }
    }

    abstract class I<T>
    implements IInstrument<T> {
        protected final String path;

        public String getPath() {
            return this.path;
        }

        public I(String path) {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            this.path = path;
        }

        @Override
        public long lastModified() {
            return VMStatCollector.this.lastModified.get();
        }

        @Override
        public void setValue(T value, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

