/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.osx;

import com.bigdata.counters.AbstractProcessCollector;
import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.ActiveProcess;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterHierarchy;
import com.bigdata.counters.IHostCounters;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.IRequiredHostCounters;
import com.bigdata.counters.ProcessReaderHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class IOStatCollector
extends AbstractProcessCollector
implements ICounterHierarchy,
IRequiredHostCounters,
IHostCounters {
    private final Map<String, Object> vals = new ConcurrentHashMap<String, Object>();
    private final AtomicLong lastModified = new AtomicLong(System.currentTimeMillis());
    static final Pattern pattern = Pattern.compile("\\s+");
    private final boolean cpuStats;

    public IOStatCollector(int interval, boolean cpuStats) {
        super(interval);
        this.cpuStats = cpuStats;
    }

    @Override
    public List<String> getCommand() {
        LinkedList<String> command = new LinkedList<String>();
        command.add("/usr/sbin/iostat");
        command.add("-d");
        command.add("-n");
        command.add("999");
        command.add("-C");
        command.add("-w");
        command.add("" + this.getInterval());
        return command;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        LinkedList<DI> inst = new LinkedList<DI>();
        inst.add(new DI("PhysicalDisk/Bytes Per Second", 1048576.0));
        inst.add(new DI("PhysicalDisk/Transfers Per Second"));
        if (this.cpuStats) {
            inst.add(new DI("CPU/% Processor Time", 0.01));
            inst.add(new DI("CPU/% User Time", 0.01));
            inst.add(new DI("CPU/% System Time", 0.01));
        }
        for (I i : inst) {
            root.addCounter(i.getPath(), i);
        }
        return root;
    }

    @Override
    public AbstractProcessReader getProcessReader() {
        return new IOStatReader();
    }

    private static void assertField(int index, String[] fields, String expected) {
        if (!expected.equals(fields[index])) {
            throw new RuntimeException("Expecting '" + expected + "', found: '" + fields[0] + "'");
        }
    }

    private class IOStatReader
    extends ProcessReaderHelper {
        @Override
        protected ActiveProcess getActiveProcess() {
            if (IOStatCollector.this.activeProcess == null) {
                throw new IllegalStateException();
            }
            return IOStatCollector.this.activeProcess;
        }

        @Override
        protected void readProcess() throws Exception {
            String h1;
            if (log.isInfoEnabled()) {
                log.info((Object)"begin");
            }
            for (int i = 0; i < 10 && !this.getActiveProcess().isAlive(); ++i) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"waiting for the readerFuture to be set.");
                }
                Thread.sleep(100L);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"running");
            }
            String h0 = this.readLine();
            if (log.isInfoEnabled()) {
                log.info((Object)("header: " + h0));
            }
            int ncpuFields = IOStatCollector.this.cpuStats ? 3 : 0;
            int nfieldsPerDevice = 3;
            String header1 = null;
            header1 = h1 = this.readLine();
            if (log.isInfoEnabled()) {
                log.info((Object)("header: " + h1));
            }
            String[] fields = pattern.split(h1.trim(), 0);
            int nfields = fields.length;
            int ndeviceFields = fields.length - ncpuFields;
            int ndevices = ndeviceFields / 3;
            if (ndevices * 3 != ndeviceFields) {
                throw new RuntimeException("Unexpected #of device fields: " + h1);
            }
            if (ndevices > 0) {
                IOStatCollector.assertField(0, fields, "KB/t");
                IOStatCollector.assertField(1, fields, "tps");
                IOStatCollector.assertField(2, fields, "MB/s");
            }
            if (IOStatCollector.this.cpuStats) {
                IOStatCollector.assertField(nfields - 3, fields, "us");
                IOStatCollector.assertField(nfields - 2, fields, "sy");
                IOStatCollector.assertField(nfields - 1, fields, "id");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("ndevices=" + ndevices));
            }
            boolean first = true;
            block3: while (true) {
                String s;
                if ((s = this.readLine()).contains("disk") || s.contains("cpu")) {
                    header1 = s = this.readLine();
                    s = this.readLine();
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Skipped headers.");
                    }
                }
                String data = s;
                if (first) {
                    first = false;
                    continue;
                }
                try {
                    IOStatCollector.this.lastModified.set(System.currentTimeMillis());
                    String[] fields2 = pattern.split(data.trim(), 0);
                    int nfields2 = fields2.length;
                    int ndeviceFields2 = fields2.length - ncpuFields;
                    int ndevices2 = ndeviceFields2 / 3;
                    if (IOStatCollector.this.cpuStats) {
                        String us = fields2[nfields2 - 3];
                        String sy = fields2[nfields2 - 2];
                        String id = fields2[nfields2 - 1];
                        if (IOStatCollector.this.cpuStats) {
                            IOStatCollector.this.vals.put("CPU/% User Time", Double.parseDouble(us));
                            IOStatCollector.this.vals.put("CPU/% System Time", Double.parseDouble(sy));
                            IOStatCollector.this.vals.put("CPU/% Processor Time", 100.0 - Double.parseDouble(id));
                        }
                    }
                    double totalKBPerXFer = 0.0;
                    double totalxferPerSec = 0.0;
                    double totalMBPerSec = 0.0;
                    int i = 0;
                    while (true) {
                        if (i >= ndevices2) continue block3;
                        int off = i * 3;
                        String kbPerXfer = fields2[off + 0];
                        String xferPerSec = fields2[off + 1];
                        String mbPerSec = fields2[off + 2];
                        double _kbPerXFer = Double.parseDouble(kbPerXfer);
                        double _xferPerSec = Double.parseDouble(xferPerSec);
                        double _mbPerSec = Double.parseDouble(mbPerSec);
                        totalKBPerXFer += _kbPerXFer;
                        totalxferPerSec += _xferPerSec;
                        totalMBPerSec += _mbPerSec;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("\ntotalKBPerXfer=" + totalKBPerXFer + ", totalXFerPerSec=" + totalxferPerSec + ", totalMBPerSec=" + totalMBPerSec + "\n" + header1 + "\n" + data));
                        }
                        IOStatCollector.this.vals.put("PhysicalDisk/Transfers Per Second", totalxferPerSec);
                        IOStatCollector.this.vals.put("PhysicalDisk/Bytes Per Second", totalMBPerSec);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    log.warn((Object)(ex.getMessage() + "\nheader: " + header1 + "\n  data: " + data), (Throwable)ex);
                    continue;
                }
                break;
            }
        }
    }

    class DI
    extends I<Double> {
        protected final double scale;

        DI(String path) {
            this(path, 1.0);
        }

        DI(String path, double scale) {
            super(path);
            this.scale = scale;
        }

        @Override
        public Double getValue() {
            Double value = (Double)IOStatCollector.this.vals.get(this.path);
            if (value == null) {
                return 0.0;
            }
            double d = value * this.scale;
            return d;
        }
    }

    abstract class I<T>
    implements IInstrument<T> {
        protected final String path;

        public String getPath() {
            return this.path;
        }

        public I(String path) {
            assert (path != null);
            this.path = path;
        }

        @Override
        public long lastModified() {
            return IOStatCollector.this.lastModified.get();
        }

        @Override
        public void setValue(T value, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

