/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.osx;

import com.bigdata.counters.AbstractProcessCollector;
import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.ActiveProcess;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterHierarchy;
import com.bigdata.counters.IHostCounters;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.IRequiredHostCounters;
import com.bigdata.counters.ProcessReaderHelper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class VMStatCollector
extends AbstractProcessCollector
implements ICounterHierarchy,
IRequiredHostCounters,
IHostCounters {
    private final Map<String, Integer> keys = new LinkedHashMap<String, Integer>();
    private final Map<String, Object> vals = new ConcurrentHashMap<String, Object>();
    private final AtomicLong lastModified = new AtomicLong(System.currentTimeMillis());
    static final Pattern pattern = Pattern.compile("\\s+");

    public VMStatCollector(int interval) {
        super(interval);
    }

    @Override
    public List<String> getCommand() {
        LinkedList<String> command = new LinkedList<String>();
        command.add("/usr/bin/vm_stat");
        command.add("" + this.getInterval());
        return command;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        LinkedList<DI> inst = new LinkedList<DI>();
        inst.add(new DI("Memory/Major Page Faults Per Second"));
        inst.add(new DI("Memory/Swap Bytes Used"));
        inst.add(new DI("Memory/Bytes Free"));
        for (I i : inst) {
            root.addCounter(i.getPath(), i);
        }
        return root;
    }

    @Override
    public AbstractProcessReader getProcessReader() {
        return new VMStatReader();
    }

    private static double parseDouble(String s) {
        int pos = s.indexOf("K");
        if (pos == -1) {
            return Long.valueOf(s).longValue();
        }
        long val = Long.valueOf(s.substring(0, pos));
        return val * 1000L;
    }

    private static void assertFieldByPosition(int index, String[] fields, String expected) {
        if (!expected.equals(fields[index])) {
            throw new RuntimeException("Expecting '" + expected + "', found: '" + fields[0] + "'");
        }
    }

    private void getIndexIfDefined(AtomicInteger indexOf, String ... name) {
        Integer index = null;
        for (String s : name) {
            index = this.keys.get(s);
            if (index == null) continue;
            indexOf.set(index);
            return;
        }
        throw new RuntimeException("Required performance counter not found: '" + Arrays.toString(name) + "'");
    }

    private class VMStatReader
    extends ProcessReaderHelper {
        private final AtomicInteger INDEX_FREE = new AtomicInteger();
        private AtomicInteger INDEX_ACTIVE = new AtomicInteger();
        private AtomicInteger INDEX_SPEC = new AtomicInteger();
        private AtomicInteger INDEX_WIRED = new AtomicInteger();
        private AtomicInteger INDEX_PAGEINS = new AtomicInteger();
        private AtomicInteger INDEX_PAGEOUT = new AtomicInteger();

        @Override
        protected ActiveProcess getActiveProcess() {
            if (VMStatCollector.this.activeProcess == null) {
                throw new IllegalStateException();
            }
            return VMStatCollector.this.activeProcess;
        }

        @Override
        protected void readProcess() throws Exception {
            if (log.isInfoEnabled()) {
                log.info((Object)"begin");
            }
            for (int i = 0; i < 10 && !this.getActiveProcess().isAlive(); ++i) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"waiting for the readerFuture to be set.");
                }
                Thread.sleep(100L);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"running");
            }
            String h0 = this.readLine();
            String[] fields = pattern.split(h0.trim(), 0);
            if (log.isInfoEnabled()) {
                log.info((Object)("header: " + h0));
            }
            VMStatCollector.assertFieldByPosition(0, fields, "Mach");
            int pageSize = Integer.valueOf(fields[7]);
            if (pageSize <= 0 || pageSize % 512 != 0) {
                throw new RuntimeException("pageSize=" + pageSize);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("pageSize: " + pageSize));
            }
            String h1 = this.readLine();
            if (log.isInfoEnabled()) {
                log.info((Object)("header: " + h1));
            }
            String[] fields2 = pattern.split(h1.trim(), 0);
            for (int i = 0; i < fields2.length; ++i) {
                VMStatCollector.this.keys.put(fields2[i], i);
            }
            VMStatCollector.this.getIndexIfDefined(this.INDEX_FREE, new String[]{"free"});
            VMStatCollector.this.getIndexIfDefined(this.INDEX_ACTIVE, new String[]{"active"});
            VMStatCollector.this.getIndexIfDefined(this.INDEX_SPEC, new String[]{"spec", "specul"});
            VMStatCollector.this.getIndexIfDefined(this.INDEX_WIRED, new String[]{"wire", "wired"});
            VMStatCollector.this.getIndexIfDefined(this.INDEX_PAGEINS, new String[]{"pageins"});
            VMStatCollector.this.getIndexIfDefined(this.INDEX_PAGEOUT, new String[]{"pageout"});
            long pageout_tm1 = 0L;
            boolean first = true;
            while (true) {
                String s;
                if ((s = this.readLine()).startsWith("Mach")) {
                    s = this.readLine();
                    s = this.readLine();
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Skipped headers.");
                    }
                }
                String data = s;
                try {
                    VMStatCollector.this.lastModified.set(System.currentTimeMillis());
                    String[] fields3 = pattern.split(data.trim(), 0);
                    String free = fields3[this.INDEX_FREE.get()];
                    String active = fields3[this.INDEX_ACTIVE.get()];
                    String spec = fields3[this.INDEX_SPEC.get()];
                    String wire = fields3[this.INDEX_WIRED.get()];
                    String pageins = fields3[this.INDEX_PAGEINS.get()];
                    String pageout = fields3[this.INDEX_PAGEOUT.get()];
                    if (log.isInfoEnabled()) {
                        log.info((Object)("\nfree=" + free + ", active=" + active + ", spec=" + spec + ", wire=" + wire + ", si=" + pageins + ", so=" + pageout + "\n" + h1 + "\n" + data));
                    }
                    double _free = VMStatCollector.parseDouble(free);
                    double _active = VMStatCollector.parseDouble(active);
                    double _spec = VMStatCollector.parseDouble(spec);
                    double _wire = VMStatCollector.parseDouble(wire);
                    double swapBytesUsed = _active + _spec + _wire;
                    VMStatCollector.this.vals.put("Memory/Bytes Free", _free * (double)pageSize);
                    VMStatCollector.this.vals.put("Memory/Swap Bytes Used", swapBytesUsed * (double)pageSize);
                    double _pageout = VMStatCollector.parseDouble(pageout);
                    if (!first) {
                        double delta = _pageout - (double)pageout_tm1;
                        double majorPageFaultsPerSec = delta / (double)VMStatCollector.this.getInterval();
                        VMStatCollector.this.vals.put("Memory/Major Page Faults Per Second", majorPageFaultsPerSec);
                    }
                    first = false;
                    continue;
                }
                catch (Exception ex) {
                    log.warn((Object)(ex.getMessage() + "\nheader: " + h1 + "\n  data: " + data), (Throwable)ex);
                    continue;
                }
                break;
            }
        }
    }

    class DI
    extends I<Double> {
        protected final double scale;

        DI(String path) {
            this(path, 1.0);
        }

        DI(String path, double scale) {
            super(path);
            this.scale = scale;
        }

        @Override
        public Double getValue() {
            Double value = (Double)VMStatCollector.this.vals.get(this.path);
            if (value == null) {
                return 0.0;
            }
            double d = value * this.scale;
            return d;
        }
    }

    abstract class I<T>
    implements IInstrument<T> {
        protected final String path;

        public String getPath() {
            return this.path;
        }

        public I(String path) {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            this.path = path;
        }

        @Override
        public long lastModified() {
            return VMStatCollector.this.lastModified.get();
        }

        @Override
        public void setValue(T value, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

