/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import com.bigdata.counters.query.ICounterSelector;
import com.bigdata.counters.query.URLQueryModel;
import com.bigdata.counters.render.IRenderer;
import com.bigdata.counters.render.TextRenderer;
import com.bigdata.counters.render.XHTMLRenderer;
import com.bigdata.counters.render.XMLRenderer;

public class RendererFactory {
    public static IRenderer get(URLQueryModel model, ICounterSelector counterSelector, String defaultMimeType) {
        String mimeType;
        if (model == null) {
            throw new IllegalArgumentException();
        }
        if (counterSelector == null) {
            throw new IllegalArgumentException();
        }
        if (defaultMimeType == null) {
            throw new IllegalArgumentException();
        }
        String string = mimeType = model.mimeType == null ? defaultMimeType : model.mimeType;
        if (mimeType.startsWith("text/plain")) {
            return new TextRenderer(model, counterSelector);
        }
        if (mimeType.startsWith("text/html")) {
            return new XHTMLRenderer(model, counterSelector);
        }
        if (mimeType.startsWith("application/xml")) {
            String charset = "UTF-8";
            return new XMLRenderer(model, counterSelector, "UTF-8");
        }
        throw new UnsupportedOperationException("mimeType=" + mimeType);
    }
}

