/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import com.bigdata.counters.ICounter;
import com.bigdata.counters.IHistoryEntry;
import com.bigdata.counters.query.HistoryTable;
import com.bigdata.counters.query.QueryUtil;
import com.bigdata.counters.render.HistoryTableRenderer;
import com.bigdata.counters.render.ValueFormatter;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;

public class TabDelimitedHistoryTableRenderer
extends HistoryTableRenderer {
    public TabDelimitedHistoryTableRenderer(HistoryTable tbl, Pattern pattern, ValueFormatter formatter) {
        super(tbl, pattern, formatter);
    }

    @Override
    public void render(Writer w) throws IOException {
        w.write("From: " + this.formatter.date(this.t.firstTimestamp));
        w.write("\tTo: " + this.formatter.date(this.t.lastTimestamp));
        w.write("\n");
        w.write("\t");
        for (ICounter counter : this.t.a) {
            this.formatter.writeFullPath(w, counter.getPath());
            w.write("\t");
        }
        w.write("\n");
        w.write(this.t.units + "\t");
        for (ICounter counter : this.t.a) {
            String label;
            String[] groups = QueryUtil.getCapturedGroups(this.pattern, counter);
            if (groups != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < groups.length; ++i) {
                    String s = groups[i];
                    if (i > 0) {
                        sb.append(":");
                    }
                    sb.append(s);
                }
                label = sb.toString();
            } else {
                label = counter.getName();
            }
            w.write(label);
            w.write("\t");
        }
        w.write("Timestamp\n");
        for (int row = 0; row < this.t.nrows; ++row) {
            String[] valStr = new String[this.t.a.length];
            for (int col = 0; col < this.t.ncols; ++col) {
                ICounter c = this.t.a[col];
                IHistoryEntry e = this.t.data[row][col];
                valStr[col] = this.formatter.value(c, e == null ? "" : e.getValue());
            }
            long timestamp = this.t.getTimestamp(row);
            String timeStr = this.formatter.unitsFormat.format(((double)timestamp - (double)this.t.getTimestamp(0)) / (double)this.t.period);
            w.write(timeStr + "\t");
            for (String s : valStr) {
                w.write(s + "\t");
            }
            w.write(this.formatter.date(timestamp) + "\n");
        }
    }
}

