/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import com.bigdata.counters.ICounter;
import com.bigdata.counters.query.URLQueryModel;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import java.util.regex.Pattern;

public abstract class ValueFormatter {
    protected final DecimalFormat decimalFormat;
    protected final NumberFormat percentFormat;
    protected final NumberFormat integerFormat;
    protected final DecimalFormat unitsFormat;
    protected final Format dateFormat;
    protected static final Pattern percent_pattern = Pattern.compile(".*percent.*", 2);

    public ValueFormatter(URLQueryModel model) {
        this.decimalFormat = model.decimalFormat;
        this.percentFormat = model.percentFormat;
        this.integerFormat = model.integerFormat;
        this.unitsFormat = model.unitsFormat;
        this.dateFormat = model.dateFormat;
    }

    public abstract String value(ICounter var1, Object var2);

    public abstract void writeFullPath(Writer var1, String var2) throws IOException;

    public abstract void writePath(Writer var1, String var2, int var3) throws IOException;

    public String date(long timestamp) {
        if (this.dateFormat != null) {
            return this.dateFormat.format(new Date(timestamp));
        }
        return Long.toString(timestamp);
    }
}

