/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.store;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.DefaultInstrumentFactory;
import com.bigdata.counters.History;
import com.bigdata.counters.HistoryInstrument;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.ICounterNode;
import com.bigdata.counters.ICounterSet;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.PeriodEnum;
import com.bigdata.io.SerializerUtil;
import com.bigdata.rawstore.IRawStore;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CounterSetBTree
extends BTree {
    protected static final transient Logger log = Logger.getLogger(CounterSetBTree.class);
    private static final transient int INITIAL_CAPACITY = 1024;

    public CounterSetBTree(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, checkpoint, metadata, readOnly);
    }

    public static CounterSetBTree create(IRawStore store) {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setBTreeClassName(CounterSetBTree.class.getName());
        metadata.setTupleSerializer(new CounterSetBTreeTupleSerializer(new ASCIIKeyBuilderFactory(1024)));
        return (CounterSetBTree)BTree.create(store, metadata);
    }

    public static CounterSetBTree createTransient() {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setBTreeClassName(CounterSetBTree.class.getName());
        metadata.setTupleSerializer(new CounterSetBTreeTupleSerializer(new ASCIIKeyBuilderFactory(1024)));
        return (CounterSetBTree)BTree.createTransient(metadata);
    }

    public void writeHistory(Iterator<ICounter> src) {
        long begin = System.currentTimeMillis();
        Vector<KVO<Entry>> v = new Vector<KVO<Entry>>();
        CounterSetBTreeTupleSerializer tupleSer = (CounterSetBTreeTupleSerializer)this.getIndexMetadata().getTupleSerializer();
        while (src.hasNext()) {
            ICounter c = src.next();
            String path = c.getPath();
            if (c.getInstrument() instanceof HistoryInstrument) {
                History h = ((HistoryInstrument)c.getInstrument()).getHistory();
                History.SampleIterator sitr = h.iterator();
                while (sitr.hasNext()) {
                    Object e = sitr.next();
                    Entry entry = new Entry(e.lastModified(), path, e.getValue());
                    byte[] key = tupleSer.serializeKey(entry);
                    byte[] val = tupleSer.serializeVal(entry);
                    v.add(new KVO<Entry>(key, val, entry));
                }
                continue;
            }
            Entry entry = new Entry(c.lastModified(), path, c.getValue());
            byte[] key = tupleSer.serializeKey(entry);
            byte[] val = tupleSer.serializeVal(entry);
            v.add(new KVO<Entry>(key, val, entry));
        }
        Object[] a = v.toArray(new KVO[v.size()]);
        Arrays.sort(a);
        long nwritten = 0L;
        for (Object t : a) {
            if (super.contains(((KVO)t).key)) continue;
            super.insert(((KVO)t).key, ((KVO)t).val);
            ++nwritten;
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled()) {
            log.info((Object)("Wrote " + nwritten + " of " + a.length + " tuples in " + elapsed + "ms"));
        }
    }

    public void writeCurrent(Iterator<ICounter> src) {
        while (src.hasNext()) {
            ICounter c = src.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)c);
            }
            this.insert(c, c.getValue());
        }
    }

    public CounterSet rangeIterator(long fromTime, long toTime, TimeUnit unit, Pattern filter, int depth) {
        long nslots;
        if (fromTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (toTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        if (fromTime == 0L) {
            fromTime = this.getFirstTimestamp();
        }
        if (toTime == 0L || toTime == Long.MAX_VALUE) {
            toTime = this.getLastTimestamp();
        }
        if ((nslots = unit.convert(toTime, TimeUnit.MILLISECONDS) - unit.convert(fromTime, TimeUnit.MILLISECONDS) + 1L) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("too many samples");
        }
        CounterSetBTreeTupleSerializer tupleSer = (CounterSetBTreeTupleSerializer)this.getIndexMetadata().getTupleSerializer();
        IKeyBuilder keyBuilder = this.getIndexMetadata().getTupleSerializer().getKeyBuilder();
        long fromMinutes = TimeUnit.MILLISECONDS.toMinutes(fromTime);
        byte[] fromKey = keyBuilder.reset().append(fromMinutes).getKey();
        long toMinutes = TimeUnit.MILLISECONDS.toMinutes(toTime + TimeUnit.MINUTES.toMillis(1L));
        byte[] toKey = keyBuilder.reset().append(toMinutes).getKey();
        if (log.isInfoEnabled()) {
            log.info((Object)("fromTime=" + fromTime + "ms (" + fromMinutes + "m), toTime=" + toTime + "ms (" + toMinutes + "m), units=" + (Object)((Object)unit) + ", nslots=" + nslots));
        }
        ITupleIterator itr = this.rangeIterator(fromKey, toKey);
        int nselected = 0;
        long nvalues = 0L;
        long nvisited = 0L;
        CounterSet counters = new CounterSet();
        DefaultInstrumentFactory instrumentFactory = new DefaultInstrumentFactory((int)nslots, PeriodEnum.getValue(unit), false);
        while (itr.hasNext()) {
            IInstrument inst;
            ITuple tuple = itr.next();
            ++nvisited;
            Entry entry = tupleSer.deserialize(tuple);
            if ((fromTime < entry.timestamp || toTime >= entry.timestamp) && log.isTraceEnabled()) {
                log.trace((Object)("Rejected: minutes=" + TimeUnit.MILLISECONDS.toMinutes(entry.timestamp) + " : " + entry.path));
            }
            if (depth != 0 && depth > entry.getDepth() && log.isTraceEnabled()) {
                log.trace((Object)("Rejected: minutes=" + TimeUnit.MILLISECONDS.toMinutes(entry.timestamp) + " : " + entry.path));
            }
            if (filter != null && !filter.matcher(entry.path).matches()) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Rejected: minutes=" + TimeUnit.MILLISECONDS.toMinutes(entry.timestamp) + " : " + entry.path));
                continue;
            }
            ICounterNode c = counters.getPath(entry.path);
            if (c == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Matched: ndistinct=" + nselected + ", " + entry.path));
                }
                ++nselected;
                inst = instrumentFactory.newInstance(entry.value.getClass());
                c = counters.addCounter(entry.path, inst);
            } else {
                if (c instanceof ICounterSet) {
                    log.error((Object)("CounterSet exists for counter path: " + entry.path));
                    continue;
                }
                inst = ((ICounter)c).getInstrument();
            }
            inst.setValue(entry.value, entry.timestamp);
            ++nvalues;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("nselected=" + nselected + ", nvalues=" + nvalues + ", nvisited=" + nvisited));
        }
        return counters;
    }

    public long getFirstTimestamp() {
        if (this.getEntryCount() == 0L) {
            return 0L;
        }
        return ((Entry)this.rangeIterator(null, null, (int)1, (int)3, null).next().getObject()).timestamp;
    }

    public long getLastTimestamp() {
        if (this.getEntryCount() == 0L) {
            return 0L;
        }
        return ((Entry)this.rangeIterator(null, null, (int)1, (int)67, null).next().getObject()).timestamp;
    }

    protected static class CounterSetBTreeTupleSerializer
    extends DefaultTupleSerializer<Object, Entry> {
        private static final long serialVersionUID = -887369151228567134L;

        public CounterSetBTreeTupleSerializer() {
        }

        public CounterSetBTreeTupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
            super(keyBuilderFactory);
        }

        @Override
        public byte[] serializeKey(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            if (obj instanceof ICounter) {
                return this.serializeKey((ICounter)obj);
            }
            if (obj instanceof Entry) {
                return this.serializeKey((Entry)obj);
            }
            throw new UnsupportedOperationException(obj.getClass().getName());
        }

        public byte[] serializeKey(ICounter c) {
            long timestamp = c.lastModified();
            return this.getKeyBuilder().reset().append(TimeUnit.MILLISECONDS.toMinutes(timestamp)).appendASCII(c.getPath()).append(timestamp).getKey();
        }

        public byte[] serializeKey(Entry e) {
            return this.getKeyBuilder().reset().append(TimeUnit.MILLISECONDS.toMinutes(e.timestamp)).appendASCII(e.path).append(e.timestamp).getKey();
        }

        @Override
        public byte[] serializeVal(Entry value) {
            return SerializerUtil.serialize(value.value);
        }

        @Override
        public Entry deserialize(ITuple tuple) {
            byte[] key = tuple.getKey();
            String path = KeyBuilder.decodeASCII(key, 8, key.length - 16);
            long timestamp = KeyBuilder.decodeLong(key, key.length - 8);
            Object value = SerializerUtil.deserialize(tuple.getValue());
            return new Entry(timestamp, path, value);
        }
    }

    public static class Entry {
        public final String path;
        public final long timestamp;
        public final Object value;

        public Entry(long timestamp, String path, Object value) {
            this.timestamp = timestamp;
            this.path = path;
            this.value = value;
        }

        public String toString() {
            return this.getClass().getName() + "{ path=" + this.path + ", value=" + this.value + ", timestamp=" + this.timestamp + "}";
        }

        public int getDepth() {
            int depth = 0;
            int len = this.path.length();
            for (int i = 0; i < len; ++i) {
                if (this.path.charAt(i) != '/') continue;
                ++depth;
            }
            return depth;
        }
    }
}

