/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia.xdr;

public class XDROutputBuffer {
    private final byte[] buffer;
    private int offset;

    public XDROutputBuffer(int BUFFER_SIZE) {
        if (BUFFER_SIZE <= 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new byte[BUFFER_SIZE];
    }

    public void reset() {
        this.offset = 0;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLength() {
        return this.offset;
    }

    public void writeString(String s) {
        byte[] bytes = s.getBytes();
        int len = bytes.length;
        this.writeInt(len);
        System.arraycopy(bytes, 0, this.buffer, this.offset, len);
        this.offset += len;
        this.pad();
    }

    private void pad() {
        int newOffset = (this.offset + 3) / 4 * 4;
        while (this.offset < newOffset) {
            this.buffer[this.offset++] = 0;
        }
    }

    public void writeShort(short i) {
        this.buffer[this.offset++] = 0;
        this.buffer[this.offset++] = 0;
        this.buffer[this.offset++] = (byte)(i >> 8 & 0xFF);
        this.buffer[this.offset++] = (byte)(i & 0xFF);
    }

    public void writeInt(int i) {
        this.buffer[this.offset++] = (byte)(i >> 24 & 0xFF);
        this.buffer[this.offset++] = (byte)(i >> 16 & 0xFF);
        this.buffer[this.offset++] = (byte)(i >> 8 & 0xFF);
        this.buffer[this.offset++] = (byte)(i & 0xFF);
    }

    public void writeLong(long i) {
        this.buffer[this.offset++] = (byte)(i >> 56 & 0xFFL);
        this.buffer[this.offset++] = (byte)(i >> 48 & 0xFFL);
        this.buffer[this.offset++] = (byte)(i >> 40 & 0xFFL);
        this.buffer[this.offset++] = (byte)(i >> 32 & 0xFFL);
        this.buffer[this.offset++] = (byte)(i >> 24 & 0xFFL);
        this.buffer[this.offset++] = (byte)(i >> 16 & 0xFFL);
        this.buffer[this.offset++] = (byte)(i >> 8 & 0xFFL);
        this.buffer[this.offset++] = (byte)(i & 0xFFL);
    }

    public void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }
}

