/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.gom.gpo;

import com.bigdata.gom.gpo.GPO;
import com.bigdata.gom.gpo.IGPO;
import com.bigdata.gom.gpo.ILinkSet;
import cutthecrap.utils.striterators.EmptyIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class LinkSet
implements ILinkSet {
    private final IGPO m_owner;
    private final URI m_linkProperty;
    private final boolean m_linksIn;

    public LinkSet(IGPO owner, URI linkProperty, boolean linksIn) {
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        if (linkProperty == null) {
            throw new IllegalArgumentException();
        }
        this.m_owner = owner;
        this.m_linkProperty = linkProperty;
        this.m_linksIn = linksIn;
    }

    @Override
    public URI getLinkProperty() {
        return this.m_linkProperty;
    }

    @Override
    public IGPO getOwner() {
        return this.m_owner;
    }

    @Override
    public boolean isLinkSetIn() {
        return this.m_linksIn;
    }

    @Override
    public <C> Iterator<C> iterator(Class<C> theClassOrInterface) {
        return null;
    }

    @Override
    public int size() {
        GPO.GPOEntry entry = this.m_linksIn ? ((GPO)this.m_owner).getLinkEntry(this.m_linkProperty) : ((GPO)this.m_owner).getEntry(this.m_linkProperty);
        return entry == null ? 0 : entry.size();
    }

    @Override
    public long sizeLong() {
        return this.size();
    }

    @Override
    public boolean add(IGPO arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        if (this.m_linksIn) {
            arg.addValue(this.m_linkProperty, this.m_owner.getId());
        } else {
            this.m_owner.addValue(this.m_linkProperty, arg.getId());
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends IGPO> arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        for (IGPO iGPO : arg) {
            this.add(iGPO);
        }
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object arg) {
        if (!(arg instanceof IGPO)) {
            throw new IllegalArgumentException("IGPO required");
        }
        IGPO gpo = (IGPO)arg;
        Iterator<IGPO> values = this.iterator();
        while (values.hasNext()) {
            if (values.next() != gpo) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String encode(Resource v) {
        return ((GPO)this.m_owner).encode(v);
    }

    @Override
    public Iterator<IGPO> iterator() {
        final GPO.GPOEntry entry = this.m_linksIn ? ((GPO)this.m_owner).getLinkEntry(this.m_linkProperty) : ((GPO)this.m_owner).getEntry(this.m_linkProperty);
        if (entry == null) {
            return new EmptyIterator<IGPO>();
        }
        return new Iterator<IGPO>(){
            final Iterator<Value> m_values;
            IGPO nextGPO;
            {
                this.m_values = entry.values();
                this.nextGPO = this.nextGPO();
            }

            private IGPO nextGPO() {
                while (this.m_values.hasNext()) {
                    Value val = this.m_values.next();
                    if (!(val instanceof Resource)) continue;
                    return LinkSet.this.m_owner.getObjectManager().getGPO((Resource)val);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.nextGPO != null;
            }

            @Override
            public IGPO next() {
                if (this.nextGPO == null) {
                    throw new NoSuchElementException();
                }
                IGPO ret = this.nextGPO;
                this.nextGPO = this.nextGPO();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean remove(Object obj) {
        if (!(obj instanceof IGPO)) {
            throw new IllegalArgumentException("Expected an instance of IGPO");
        }
        IGPO gpo = (IGPO)obj;
        if (this.m_linksIn) {
            gpo.removeValue(this.m_linkProperty, this.m_owner.getId());
        } else {
            this.m_owner.removeValue(this.m_linkProperty, gpo.getId());
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return false;
    }

    @Override
    public Object[] toArray() {
        ArrayList<IGPO> out = new ArrayList<IGPO>();
        Iterator<IGPO> gpos = this.iterator();
        while (gpos.hasNext()) {
            out.add(gpos.next());
        }
        return out.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return null;
    }

    @Override
    public <C> Iterator<C> statements() {
        return null;
    }
}

