/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.pipeline;

import com.bigdata.btree.BytesUtil;
import com.bigdata.ha.msg.HAMessageWrapper;
import com.bigdata.ha.msg.HASendState;
import com.bigdata.ha.msg.HAWriteMessageBase;
import com.bigdata.ha.msg.IHAWriteMessageBase;
import com.bigdata.ha.pipeline.HASendService;
import com.bigdata.ha.pipeline.ImmediateDownstreamReplicationException;
import com.bigdata.ha.pipeline.PipelineDownstreamChange;
import com.bigdata.ha.pipeline.PipelineUpstreamChange;
import com.bigdata.util.ChecksumError;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.Adler32;
import org.apache.log4j.Logger;

public class HAReceiveService<M extends HAMessageWrapper>
extends Thread {
    private static final Logger log = Logger.getLogger(HAReceiveService.class);
    private static final long selectorTimeout = 500L;
    private static final long logTimeout = 10000L;
    private final InetSocketAddress addrSelf;
    private final IHAReceiveCallback<M> callback;
    private final HASendService sendService;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Lock lock = new ReentrantLock();
    private final Condition futureReady = this.lock.newCondition();
    private final Condition messageReady = this.lock.newCondition();
    private RunState runState = RunState.Start;
    private M message;
    private ByteBuffer localBuffer;
    private FutureTask<Void> readFuture;
    private FutureTask<Void> waitFuture;
    private final AtomicReference<InetSocketAddress> addrNextRef;
    private final byte[] heapBuffer = new byte[512];
    private final AtomicReference<Client> clientRef = new AtomicReference<Object>(null);

    public HASendService getSendService() {
        return this.sendService;
    }

    @Override
    public String toString() {
        return super.toString() + "{addrSelf=" + this.addrSelf + ", addrNext=" + this.addrNextRef.get() + "}";
    }

    public InetSocketAddress getAddrSelf() {
        return this.addrSelf;
    }

    public InetSocketAddress getAddrNext() {
        return this.addrNextRef.get();
    }

    public HAReceiveService(InetSocketAddress addrSelf, InetSocketAddress addrNext) {
        this(addrSelf, addrNext, null);
    }

    public HAReceiveService(InetSocketAddress addrSelf, InetSocketAddress addrNext, IHAReceiveCallback<M> callback) {
        if (addrSelf == null) {
            throw new IllegalArgumentException();
        }
        this.addrSelf = addrSelf;
        this.addrNextRef = new AtomicReference<InetSocketAddress>(addrNext);
        this.callback = callback;
        this.sendService = new HASendService();
        this.setDaemon(true);
        this.setName(HAReceiveService.class.getName() + "@" + this.hashCode() + "{addrSelf=" + addrSelf + "}");
        if (log.isInfoEnabled()) {
            log.info((Object)("Created: " + this));
        }
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.lock.lock();
        try {
            switch (this.runState) {
                case ShuttingDown: 
                case Shutdown: {
                    return;
                }
            }
            this.runState = RunState.ShuttingDown;
            this.interrupt();
        }
        finally {
            this.lock.unlock();
        }
        if (this.sendService != null) {
            this.sendService.terminate();
        }
        this.executor.shutdownNow();
    }

    public void awaitShutdown() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            block8: while (true) {
                switch (this.runState) {
                    case ShuttingDown: 
                    case Start: 
                    case Running: {
                        this.futureReady.await();
                        continue block8;
                    }
                    case Shutdown: {
                        return;
                    }
                }
                break;
            }
            throw new AssertionError();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        super.start();
        this.lock.lock();
        try {
            while (this.runState == RunState.Start) {
                try {
                    this.futureReady.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lock.lock();
        try {
            this.runState = RunState.Running;
            this.futureReady.signalAll();
            this.messageReady.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        ServerSocketChannel server = null;
        try {
            server = ServerSocketChannel.open();
            boolean didBind = false;
            for (int i = 0; i < 3; ++i) {
                try {
                    server.socket().bind(this.addrSelf);
                    didBind = true;
                    break;
                }
                catch (BindException ex) {
                    log.warn((Object)("Sleeping to retry: " + ex));
                    Thread.sleep(100L);
                    continue;
                }
            }
            if (!didBind) {
                server.socket().bind(this.addrSelf);
            }
            server.configureBlocking(false);
            if (log.isInfoEnabled()) {
                log.info((Object)("Listening on: " + this.addrSelf));
            }
            this.runNoBlock(server);
        }
        catch (InterruptedException e) {
            log.info((Object)"Shutdown");
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            throw new RuntimeException(t);
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            this.lock.lock();
            try {
                this.runState = RunState.Shutdown;
                this.messageReady.signalAll();
                this.futureReady.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runNoBlock(ServerSocketChannel server) throws IOException, InterruptedException, ExecutionException {
        while (true) lbl-1000:
        // 3 sources

        {
            this.lock.lockInterruptibly();
            try {
                while (this.message == null) {
                    switch (1.$SwitchMap$com$bigdata$ha$pipeline$HAReceiveService$RunState[this.runState.ordinal()]) {
                        case 4: {
                            break;
                        }
                        case 1: {
                            return;
                        }
                        default: {
                            throw new AssertionError((Object)this.runState.toString());
                        }
                    }
                    this.messageReady.await();
                }
                msg = this.message;
                this.message = null;
                this.waitFuture = new FutureTask<Void>(new ReadTask<M>(server, this.clientRef, msg, this.localBuffer, this.heapBuffer, this.sendService, this.addrNextRef, this.callback));
                this.readFuture = this.waitFuture;
                this.futureReady.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            try {
                this.executor.execute(this.readFuture);
            }
            catch (RejectedExecutionException ex) {
                this.readFuture.cancel(true);
                HAReceiveService.log.error((Object)ex);
            }
            try {
                this.readFuture.get();
            }
            catch (Exception e) {
                HAReceiveService.log.error((Object)e, (Throwable)e);
            }
            this.lock.lockInterruptibly();
            try {
                this.readFuture = null;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            client = this.clientRef.get();
            if (client != null) {
                Client.access$000(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> receiveData(M msg, ByteBuffer buffer) throws InterruptedException {
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lockInterruptibly();
        try {
            assert (this.message == null);
            this.message = msg;
            this.localBuffer = buffer;
            this.localBuffer.limit(((HAWriteMessageBase)this.message).getSize());
            this.localBuffer.position(0);
            this.messageReady.signalAll();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Will accept data for message: msg=" + msg));
            }
            while (this.waitFuture == null) {
                switch (this.runState) {
                    case Start: 
                    case Running: {
                        break;
                    }
                    case ShuttingDown: 
                    case Shutdown: {
                        throw new RuntimeException("Service closed.");
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.futureReady.await();
            }
            assert (this.waitFuture != null);
            FutureTask<Void> futureTask = this.waitFuture;
            return futureTask;
        }
        finally {
            this.waitFuture = null;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeDownStream(InetSocketAddress addrNext) {
        this.lock.lock();
        try {
            Client c;
            if (log.isInfoEnabled()) {
                log.info((Object)("addrNext(old)=" + this.addrNextRef.get() + ", addrNext(new)=" + addrNext + ", readFuture=" + this.readFuture));
            }
            if ((c = this.clientRef.get()) != null && this.readFuture != null) {
                c.firstCause.set(new PipelineDownstreamChange());
            }
            HASendService hASendService = this.sendService;
            synchronized (hASendService) {
                if (this.sendService.isRunning()) {
                    this.sendService.terminate();
                }
                this.addrNextRef.set(addrNext);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeUpStream() {
        this.lock.lock();
        try {
            Client oldClient;
            if (log.isInfoEnabled()) {
                log.info((Object)"");
            }
            if ((oldClient = (Client)this.clientRef.getAndSet(null)) != null) {
                log.warn((Object)"Cleared Client reference.");
            }
            if (oldClient != null && this.readFuture != null) {
                oldClient.firstCause.set(new PipelineUpstreamChange());
            }
            if (oldClient != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Closing client connection");
                }
                try {
                    oldClient.client.close();
                }
                catch (IOException e) {
                    log.warn((Object)e, (Throwable)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface IHAReceiveCallback<M extends IHAWriteMessageBase> {
        public void incReceive(M var1, int var2, int var3, int var4) throws Exception;

        public void callback(M var1, ByteBuffer var2) throws Exception;
    }

    private static class DrainToMarkerUtil {
        private final byte[] marker;
        private final byte[] markerBuffer;
        private final ByteBuffer markerBB;
        private final Client client;
        private boolean foundMarkerInInitialPosition = true;
        private int markerIndex = 0;
        private int nreads = 0;
        private int nmarkerbytematches = 0;
        private long bytesRead = 0L;

        DrainToMarkerUtil(byte[] marker, Client client) {
            this.marker = marker;
            this.markerBuffer = marker == null ? null : new byte[marker.length];
            this.markerBB = marker == null ? null : ByteBuffer.wrap(this.markerBuffer);
            this.client = client;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Receive token: " + BytesUtil.toHexString(marker)));
            }
        }

        boolean findMarker() throws IOException {
            if (this.markerIndex == this.marker.length) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for token, " + BytesUtil.toHexString(this.marker) + ", reads: " + this.nreads));
            }
            while (this.markerIndex < this.marker.length) {
                int remtok = this.marker.length - this.markerIndex;
                this.markerBB.limit(remtok);
                this.markerBB.position(0);
                int rdLen = this.client.read(this.markerBB);
                if (rdLen == -1) {
                    throw new IOException("EOF: nreads=" + this.nreads + ", bytesRead=" + this.bytesRead);
                }
                ++this.nreads;
                this.bytesRead += (long)rdLen;
                for (int i = 0; i < rdLen; ++i) {
                    if (this.markerBuffer[i] != this.marker[this.markerIndex]) {
                        if (this.foundMarkerInInitialPosition) {
                            this.foundMarkerInInitialPosition = false;
                            log.error((Object)"Marker not found: skipping");
                        }
                        this.markerIndex = 0;
                        if (this.markerBuffer[i] != this.marker[this.markerIndex]) continue;
                        ++this.markerIndex;
                        continue;
                    }
                    ++this.markerIndex;
                    ++this.nmarkerbytematches;
                }
                if (this.nreads % 10000 != 0 || !log.isDebugEnabled()) continue;
                log.debug((Object)("...still looking: reads=" + this.nreads + ", bytesRead=" + this.bytesRead));
            }
            if (this.markerIndex != this.marker.length) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Not found token yet!");
                }
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found token after " + this.nreads + " token reads and " + this.nmarkerbytematches + " byte matches"));
            }
            return true;
        }
    }

    private static class ReadTask<M extends HAMessageWrapper>
    implements Callable<Void> {
        private final ServerSocketChannel server;
        private final AtomicReference<Client> clientRef;
        private final M message;
        private final ByteBuffer localBuffer;
        private final HASendService sendService;
        private final AtomicReference<InetSocketAddress> addrNextRef;
        private final IHAReceiveCallback<M> callback;
        private final Adler32 chk = new Adler32();
        private final byte[] heapBuffer;

        public ReadTask(ServerSocketChannel server, AtomicReference<Client> clientRef, M message, ByteBuffer localBuffer, byte[] heapBuffer, HASendService downstream, AtomicReference<InetSocketAddress> addrNextRef, IHAReceiveCallback<M> callback) {
            if (server == null) {
                throw new IllegalArgumentException();
            }
            if (clientRef == null) {
                throw new IllegalArgumentException();
            }
            if (message == null) {
                throw new IllegalArgumentException();
            }
            if (heapBuffer == null) {
                throw new IllegalArgumentException();
            }
            if (localBuffer == null) {
                throw new IllegalArgumentException();
            }
            if (downstream == null) {
                throw new IllegalArgumentException();
            }
            this.server = server;
            this.clientRef = clientRef;
            this.message = message;
            this.localBuffer = localBuffer;
            this.heapBuffer = heapBuffer;
            this.sendService = downstream;
            this.addrNextRef = addrNextRef;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void awaitAccept() throws IOException {
            try (Selector serverSelector = Selector.open();){
                SelectionKey serverKey = this.server.register(serverSelector, 16);
                try {
                    serverSelector.select();
                    Set<SelectionKey> keys = serverSelector.selectedKeys();
                    Iterator<SelectionKey> iter = keys.iterator();
                    if (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        if (key != serverKey) {
                            throw new AssertionError();
                        }
                    }
                }
                finally {
                    serverKey.cancel();
                }
            }
        }

        private void updateChk(int rdlen) {
            ByteBuffer b = this.localBuffer.asReadOnlyBuffer();
            int mark = b.position();
            b.position(mark - rdlen);
            for (int pos = mark - rdlen; pos < mark; pos += this.heapBuffer.length) {
                int len = Math.min(mark - pos, this.heapBuffer.length);
                b.get(this.heapBuffer, 0, len);
                this.chk.update(this.heapBuffer, 0, len);
            }
        }

        @Override
        public Void call() throws Exception {
            try {
                return this.doInnerCall();
            }
            catch (Throwable t) {
                log.error((Object)("client=" + this.clientRef.get() + ", msg=" + this.message + ", marker=" + HASendState.decode(((HAMessageWrapper)this.message).getHASendState().getMarker()) + ", cause=" + t), t);
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }

        private Void doInnerCall() throws Exception {
            Client client = this.clientRef.get();
            if (client == null || !client.client.isOpen() || !client.clientSelector.isOpen()) {
                log.warn((Object)"Re-opening upstream client connection");
                Client tmp = this.clientRef.getAndSet(null);
                if (tmp != null) {
                    tmp.close();
                }
                this.awaitAccept();
                client = new Client(this.server);
                this.clientRef.set(client);
            }
            this.doReceiveAndReplicate(client);
            return null;
        }

        private void doReceiveAndReplicate(Client client) throws Exception {
            DrainToMarkerUtil drainUtil;
            long begin;
            long mark = begin = System.currentTimeMillis();
            int rem = ((HAWriteMessageBase)this.message).getSize();
            boolean EOS = false;
            int reads = 0;
            DrainToMarkerUtil drainToMarkerUtil = drainUtil = ((HAMessageWrapper)this.message).getHASendState() != null ? new DrainToMarkerUtil(((HAMessageWrapper)this.message).getHASendState().getMarker(), client) : null;
            block0: while (rem > 0 && !EOS) {
                int nkeys = client.clientSelector.select(500L);
                client.checkFirstCause();
                if (nkeys == 0) {
                    long now = System.currentTimeMillis();
                    long elapsed = now - mark;
                    if (elapsed > 10000L) {
                        log.warn((Object)("Blocked: awaiting " + rem + " out of " + ((HAWriteMessageBase)this.message).getSize() + " bytes."));
                        mark = now;
                    }
                    if (client.client.isOpen() && client.clientSelector.isOpen()) continue;
                    throw new AsynchronousCloseException();
                }
                Set<SelectionKey> keys = client.clientSelector.selectedKeys();
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    client.checkFirstCause();
                    iter.next();
                    iter.remove();
                    if (!drainUtil.findMarker()) continue;
                    int rdlen = client.read(this.localBuffer);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Read " + rdlen + " bytes with " + (rdlen > 0 ? rem - rdlen : rem) + " bytes remaining."));
                    }
                    if (rdlen > 0) {
                        ++reads;
                        this.updateChk(rdlen);
                    }
                    if (rdlen == -1) {
                        EOS = true;
                        continue block0;
                    }
                    rem -= rdlen;
                    if (this.callback != null) {
                        this.callback.incReceive(this.message, reads, rdlen, rem);
                    }
                    this.forwardReceivedBytes(client, rdlen);
                }
            }
            if (this.localBuffer.position() != ((HAWriteMessageBase)this.message).getSize()) {
                throw new IOException("Receive length error: rem=" + rem + ", EOS=" + EOS + ", localBuffer.pos=" + this.localBuffer.position() + ", message.size=" + ((HAWriteMessageBase)this.message).getSize());
            }
            this.localBuffer.flip();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Prior check checksum: " + this.chk.getValue() + " for position: " + this.localBuffer.position() + ", limit: " + this.localBuffer.limit() + ", number of reads: " + reads + ", buffer: " + this.localBuffer));
            }
            if (((HAWriteMessageBase)this.message).getChk() != (int)this.chk.getValue()) {
                throw new ChecksumError("msg=" + ((HAWriteMessageBase)this.message).toString() + ", actual=" + (int)this.chk.getValue());
            }
            client.checkFirstCause();
            if (this.callback != null) {
                this.callback.callback(this.message, this.localBuffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forwardReceivedBytes(Client client, int rdlen) throws InterruptedException, ExecutionException, ImmediateDownstreamReplicationException {
            while (rdlen != 0 && this.addrNextRef.get() != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Incremental send of " + rdlen + " bytes"));
                }
                ByteBuffer out = this.localBuffer.asReadOnlyBuffer();
                out.position(this.localBuffer.position() - rdlen);
                out.limit(this.localBuffer.position());
                HASendService hASendService = this.sendService;
                synchronized (hASendService) {
                    if (!this.sendService.isRunning()) {
                        client.checkFirstCause();
                        this.sendService.start(this.addrNextRef.get());
                        continue;
                    }
                }
                client.checkFirstCause();
                this.sendService.send(out, out.position() == 0 && ((HAMessageWrapper)this.message).getHASendState() != null ? ((HAMessageWrapper)this.message).getHASendState().getMarker() : null).get();
                break;
            }
        }
    }

    private static class Client {
        private final SocketChannel client;
        private final Selector clientSelector;
        private final SelectionKey clientKey;
        private final AtomicReference<Throwable> firstCause = new AtomicReference();

        public Client(ServerSocketChannel server) throws IOException {
            try {
                this.client = server.accept();
                this.client.configureBlocking(false);
                if (!this.client.finishConnect()) {
                    throw new IOException("Upstream client not connected");
                }
                this.clientSelector = Selector.open();
                this.clientKey = this.client.register(this.clientSelector, 1);
                if (log.isInfoEnabled()) {
                    log.info((Object)"Accepted new connection");
                }
            }
            catch (IOException ex) {
                this.close();
                throw ex;
            }
        }

        public String toString() {
            Socket s = this.client.socket();
            return super.toString() + "{client.isOpen()=" + this.client.isOpen() + ",client.isConnected()=" + this.client.isConnected() + ",socket.isInputShutdown()=" + (s == null ? "N/A" : Boolean.valueOf(s.isInputShutdown())) + ",clientSelector.isOpen=" + this.clientSelector.isOpen() + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() throws IOException {
            if (log.isInfoEnabled()) {
                log.info((Object)("Closing client connection: " + this));
            }
            this.clientKey.cancel();
            try {
                this.client.close();
            }
            finally {
                this.clientSelector.close();
            }
        }

        private int read(ByteBuffer dst) throws IOException {
            int rdlen = this.client.read(dst);
            if (rdlen == -1) {
                this.close();
            }
            return rdlen;
        }

        private void checkFirstCause() throws RuntimeException {
            Throwable t = this.firstCause.getAndSet(null);
            if (t != null) {
                try {
                    this.close();
                }
                catch (IOException ex) {
                    log.warn((Object)ex, (Throwable)ex);
                }
                throw new RuntimeException(t);
            }
        }
    }

    private static enum RunState {
        Start(0),
        Running(1),
        ShuttingDown(2),
        Shutdown(3);

        private final int level;

        private RunState(int level) {
            this.level = level;
        }
    }
}

