/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.btree.BytesUtil;
import it.unimi.dsi.bits.Fast;

public class HTreeUtil {
    static int getMapSize(int nentries) {
        if (nentries <= 0) {
            throw new IllegalArgumentException();
        }
        int i = 1;
        while (1 << i < nentries) {
            ++i;
        }
        return i;
    }

    static int pow2(int n) {
        return 1 << n;
    }

    public static boolean isPowerOf2(int v) {
        return (v & -v) == v;
    }

    public static int getSlotsOnPage(int globalDepth, int localDepth) {
        if (localDepth < 0) {
            throw new IllegalArgumentException();
        }
        if (globalDepth < 0) {
            throw new IllegalArgumentException();
        }
        if (localDepth > globalDepth) {
            throw new IllegalArgumentException();
        }
        int numSlotsForPage = 1 << globalDepth - localDepth;
        return numSlotsForPage;
    }

    public static int getLocalDepth(int addressBits, int globalDepth, int npointers) {
        if (addressBits < 1) {
            throw new IllegalArgumentException();
        }
        if (globalDepth < 0) {
            throw new IllegalArgumentException();
        }
        if (globalDepth > 1 << addressBits) {
            throw new IllegalArgumentException();
        }
        if (npointers < 1) {
            throw new IllegalArgumentException();
        }
        if (npointers > 1 << globalDepth) {
            throw new IllegalArgumentException();
        }
        if ((npointers & -npointers) != npointers) {
            throw new IllegalArgumentException();
        }
        int x = (1 << globalDepth) / npointers;
        int i = Fast.mostSignificantBit((int)x);
        assert (1 << globalDepth - i == npointers);
        return i;
    }

    public static int getBuddyOffset(int hashBits, int globalDepth, int localDepth) {
        if (globalDepth < 0) {
            throw new IllegalArgumentException();
        }
        if (localDepth > globalDepth) {
            throw new IllegalArgumentException();
        }
        int nbits = globalDepth - localDepth;
        int slotsPerBuddy = 1 << localDepth;
        int tmp = BytesUtil.maskOffLSB(hashBits, nbits);
        int childBuddyOffset = tmp * slotsPerBuddy;
        return childBuddyOffset;
    }
}

