/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree.raba;

import com.bigdata.btree.raba.AbstractRaba;
import com.bigdata.btree.raba.IRaba;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class MutableValueBuffer
implements IRaba {
    public int nvalues;
    public final byte[][] values;

    private static void checkCapacity(int capacity) {
        if (capacity <= 1 || (capacity & -capacity) != capacity) {
            throw new IllegalArgumentException();
        }
    }

    public MutableValueBuffer(int capacity) {
        MutableValueBuffer.checkCapacity(capacity);
        this.nvalues = 0;
        this.values = new byte[capacity][];
    }

    public MutableValueBuffer(int nvalues, byte[][] values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if (nvalues < 0 || nvalues > values.length) {
            throw new IllegalArgumentException();
        }
        MutableValueBuffer.checkCapacity(values.length);
        this.nvalues = nvalues;
        this.values = values;
    }

    public MutableValueBuffer(MutableValueBuffer src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        MutableValueBuffer.checkCapacity(src.capacity());
        this.nvalues = src.nvalues;
        this.values = new byte[src.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = src.values[i];
        }
    }

    public MutableValueBuffer(int capacity, IRaba src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        MutableValueBuffer.checkCapacity(capacity);
        if (capacity < src.capacity()) {
            throw new IllegalArgumentException();
        }
        this.nvalues = src.size();
        this.values = new byte[capacity][];
        int i = 0;
        for (byte[] a : src) {
            this.values[i++] = a;
        }
    }

    public String toString() {
        return AbstractRaba.toString(this);
    }

    @Override
    public final byte[] get(int index) {
        return this.values[index];
    }

    @Override
    public final int length(int index) {
        byte[] tmp = this.values[index];
        if (tmp == null) {
            throw new NullPointerException();
        }
        return tmp.length;
    }

    @Override
    public final int copy(int index, OutputStream out) {
        byte[] tmp = this.values[index];
        try {
            out.write(tmp, 0, tmp.length);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return tmp.length;
    }

    @Override
    public final boolean isNull(int index) {
        return this.values[index] == null;
    }

    @Override
    public final boolean isEmpty() {
        return this.nvalues == 0;
    }

    @Override
    public final int size() {
        return this.nvalues;
    }

    @Override
    public final int capacity() {
        return this.values.length;
    }

    @Override
    public final boolean isFull() {
        return this.nvalues == this.values.length;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isKeys() {
        return false;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < MutableValueBuffer.this.size();
            }

            @Override
            public byte[] next() {
                return MutableValueBuffer.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final void set(int index, byte[] value) {
        assert (value != null);
        assert (this.values[index] == null);
        assert (this.nvalues < this.values.length);
        this.values[index] = value;
        ++this.nvalues;
    }

    public final void insert(int index, byte[] value) {
        if (index < this.nvalues) {
            assert (this.values[this.nvalues] == null);
            System.arraycopy(this.values, index, this.values, index + 1, this.nvalues - index);
        }
        this.values[index] = value;
        ++this.nvalues;
    }

    public final int remove(int index) {
        assert (this.values[index] != null);
        assert (this.nvalues > 0);
        System.arraycopy(this.values, index + 1, this.values, index, this.nvalues - index - 1);
        this.values[this.nvalues - 1] = null;
        return --this.nvalues;
    }

    @Override
    public final int add(byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int add(byte[] value, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int add(DataInput in, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int search(byte[] searchKey) {
        throw new UnsupportedOperationException();
    }
}

