/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.io.ByteArrayBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;

public class DataOutputBuffer
extends ByteArrayBuffer
implements DataOutput {
    public DataOutputBuffer() {
    }

    public DataOutputBuffer(int initialCapacity) {
        super(initialCapacity);
    }

    public DataOutputBuffer(int len, byte[] buf) {
        super(len, buf.length, buf);
    }

    public DataOutputBuffer(InputStream in) throws IOException {
        int nread;
        byte[] b = new byte[this.remaining()];
        while ((nread = in.read(b)) != -1) {
            this.write(b, 0, nread);
        }
    }

    public DataOutputBuffer(ObjectInput in) throws IOException {
        int nread;
        byte[] b = new byte[this.remaining()];
        while ((nread = in.read(b)) != -1) {
            this.write(b, 0, nread);
        }
    }

    @Override
    public DataOutputBuffer reset() {
        return (DataOutputBuffer)super.reset();
    }

    public final void write(DataInput in, int len) throws IOException {
        this.ensureCapacity(len);
        for (int c = 0; c < len; ++c) {
            byte b = in.readByte();
            this.buf[this.pos++] = (byte)(b & 0xFF);
        }
        this.limit = this.pos;
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        if (this.pos + 1 > this.buf.length) {
            this.ensureCapacity(this.pos + 1);
        }
        this.buf[this.pos++] = v ? (byte)1 : 0;
        this.limit = this.pos;
    }

    @Override
    public final void writeByte(int v) throws IOException {
        if (this.pos + 1 > this.buf.length) {
            this.ensureCapacity(this.pos + 1);
        }
        this.buf[this.pos++] = (byte)(v & 0xFF);
        this.limit = this.pos;
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.putDouble(v);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.putFloat(v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.putInt(v);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.putLong(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.putShort((short)v);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        if (this.pos + 2 > this.buf.length) {
            this.ensureCapacity(this.pos + 2);
        }
        this.buf[this.pos++] = (byte)(v >>> 8);
        this.buf[this.pos++] = (byte)(v >>> 0);
        this.limit = this.pos;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        if (this.pos + len > this.buf.length) {
            this.ensureCapacity(this.pos + len);
        }
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
        this.limit = this.pos;
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        if (this.pos + len * 2 > this.buf.length) {
            this.ensureCapacity(this.pos + len * 2);
        }
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.buf[this.pos++] = (byte)(v >>> 8);
            this.buf[this.pos++] = (byte)(v >>> 0);
        }
        this.limit = this.pos;
    }

    @Override
    public void writeUTF(String str) throws IOException {
        DataOutputStream dos = new DataOutputStream(this);
        dos.writeUTF(str);
        dos.flush();
    }

    public void writeUTF2(String str) {
        try {
            this.writeUTF(str);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

