/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.IBufferAccess;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class DirectBufferPoolAllocator {
    private final DirectBufferPool directBufferPool;
    private final ConcurrentHashMap<Object, AllocationContext> allocationContexts = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Allocation> allocations = new ConcurrentHashMap();
    private final AtomicBoolean open = new AtomicBoolean(true);

    public DirectBufferPoolAllocator(DirectBufferPool pool) {
        this.directBufferPool = pool;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this.open.compareAndSet(true, false)) {
            for (AllocationContext c : this.allocationContexts.values()) {
                c.release();
            }
        }
    }

    public int getMaxSlotSize() {
        return this.directBufferPool.getBufferCapacity();
    }

    public IAllocationContext getAllocationContext(Object key) {
        AllocationContext t;
        AllocationContext c = this.allocationContexts.get(key);
        if (c == null && (t = this.allocationContexts.putIfAbsent(key, c = new AllocationContext(key))) != null) {
            c = t;
        }
        return c;
    }

    public IAllocation getAllocation(UUID id) {
        return this.allocations.get(id);
    }

    public static void put(byte[] src, IAllocation[] a) {
        int length;
        int offset = 0;
        int remaining = src.length;
        for (int i = 0; i < a.length && remaining > 0; remaining -= length, ++i) {
            ByteBuffer slice = a[i].getSlice();
            length = Math.min(remaining, slice.remaining());
            slice.put(src, offset, length);
            offset += length;
        }
        if (remaining > 0) {
            throw new BufferOverflowException();
        }
    }

    public static void put(ByteBuffer src, IAllocation[] a) {
        int length;
        int remaining = src.remaining();
        for (int i = 0; i < a.length && remaining > 0; remaining -= length, ++i) {
            ByteBuffer slice = a[i].getSlice();
            length = Math.min(remaining, slice.remaining());
            slice.put(src);
        }
        if (remaining > 0) {
            throw new BufferOverflowException();
        }
    }

    class AllocationContext
    implements IAllocationContext {
        private final Object key;
        private final ReentrantLock lock = new ReentrantLock();
        private final LinkedList<IBufferAccess> directBuffers = new LinkedList();
        private final ConcurrentHashMap<UUID, Allocation> allocations = new ConcurrentHashMap();

        public String toString() {
            return this.getClass().getName() + "{key=" + this.key + ",#allocations=" + this.allocations.size() + ",#nativeBuffers=" + this.directBuffers.size() + "}";
        }

        public AllocationContext(Object key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IAllocation[] alloc(int nbytes) throws InterruptedException {
            if (nbytes <= 0) {
                throw new IllegalArgumentException();
            }
            this.lock.lock();
            try {
                LinkedList<Allocation> allocations = new LinkedList<Allocation>();
                while (nbytes > 0) {
                    IBufferAccess directBuffer = this.directBuffers.peekLast();
                    if (directBuffer == null) {
                        if (!DirectBufferPoolAllocator.this.open.get()) {
                            throw new IllegalStateException();
                        }
                        directBuffer = DirectBufferPoolAllocator.this.directBufferPool.acquire();
                        this.directBuffers.add(directBuffer);
                    }
                    ByteBuffer nativeBuffer = directBuffer.buffer();
                    int remaining = nativeBuffer.remaining();
                    int allocSize = Math.min(remaining, nbytes);
                    int start = nativeBuffer.position();
                    int limit = start + allocSize;
                    nativeBuffer.limit(limit);
                    Allocation a = new Allocation(this, directBuffer, nativeBuffer.slice());
                    nativeBuffer.limit(nativeBuffer.capacity());
                    nativeBuffer.position(limit);
                    DirectBufferPoolAllocator.this.allocations.put(a.id, a);
                    this.allocations.put(a.id, a);
                    allocations.add(a);
                    nbytes -= allocSize;
                }
                IAllocation[] iAllocationArray = allocations.toArray(new IAllocation[allocations.size()]);
                return iAllocationArray;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            boolean interrupted = false;
            this.lock.lock();
            try {
                for (Allocation a : this.allocations.values()) {
                    a.allocatedSlice = null;
                }
                this.allocations.clear();
                Iterator bitr = this.directBuffers.iterator();
                block9: while (bitr.hasNext()) {
                    IBufferAccess b = (IBufferAccess)bitr.next();
                    while (true) {
                        try {
                            b.release();
                            continue block9;
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            continue;
                        }
                        finally {
                            bitr.remove();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release(Allocation a) throws InterruptedException {
            if (a == null) {
                throw new IllegalArgumentException();
            }
            this.lock.lockInterruptibly();
            try {
                if (!this.allocations.remove(a.id, a)) {
                    throw new RuntimeException();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    class Allocation
    implements IAllocation {
        private final AllocationContext allocationContext;
        private final UUID id;
        final IBufferAccess nativeBuffer;
        private volatile ByteBuffer allocatedSlice;

        @Override
        public UUID getId() {
            return this.id;
        }

        @Override
        public ByteBuffer getSlice() {
            if (!DirectBufferPoolAllocator.this.open.get()) {
                throw new IllegalStateException();
            }
            ByteBuffer t = this.allocatedSlice;
            if (t == null) {
                throw new IllegalStateException();
            }
            return t;
        }

        private Allocation(AllocationContext allocationContext, IBufferAccess nativeBuffer, ByteBuffer allocatedSlice) {
            if (allocationContext == null) {
                throw new IllegalArgumentException();
            }
            if (nativeBuffer == null) {
                throw new IllegalArgumentException();
            }
            if (allocatedSlice == null) {
                throw new IllegalArgumentException();
            }
            this.allocationContext = allocationContext;
            this.id = UUID.randomUUID();
            this.nativeBuffer = nativeBuffer;
            this.allocatedSlice = allocatedSlice;
        }

        @Override
        public void release() throws InterruptedException {
            this.allocationContext.release(this);
            this.allocatedSlice = null;
        }

        public String toString() {
            return this.getClass().getName() + "{id=" + this.id + ",slice=" + this.allocatedSlice + ",context=" + this.allocationContext + "}";
        }
    }

    public static interface IAllocation {
        public UUID getId();

        public ByteBuffer getSlice();

        public void release() throws InterruptedException;
    }

    public static interface IAllocationContext {
        public IAllocation[] alloc(int var1) throws InterruptedException;

        public void release();
    }
}

