/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LongPacker {
    public static int packLong(DataOutput os, long v) throws IOException {
        if (v < 0L) {
            throw new IllegalArgumentException("negative value: v=" + v);
        }
        if (v >> 56 != 0L) {
            os.write((byte)(0xFFL & v >> 56 | 0x80L));
            os.write((byte)(0xFFL & v >> 48));
            os.write((byte)(0xFFL & v >> 40));
            os.write((byte)(0xFFL & v >> 32));
            os.write((byte)(0xFFL & v >> 24));
            os.write((byte)(0xFFL & v >> 16));
            os.write((byte)(0xFFL & v >> 8));
            os.write((byte)(0xFFL & v));
            return 8;
        }
        int nnibbles = LongPacker.getNibbleLength(v);
        boolean evenNibbleCount = nnibbles == nnibbles >> 1 << 1;
        int nbytes = (nnibbles + 1 >> 1) + (evenNibbleCount ? 1 : 0);
        int nwritten = 0;
        if (evenNibbleCount) {
            byte b = (byte)(nbytes << 4);
            os.write(b);
            ++nwritten;
            for (int i = nnibbles - 2 << 2; i >= 0; i -= 8) {
                b = (byte)(0xFFL & v >> i);
                os.write(b);
                ++nwritten;
            }
        } else {
            byte highByte = (byte)(0xFFL & v >> (nbytes - 1) * 8);
            byte b = (byte)(nbytes << 4 | highByte);
            os.write(b);
            ++nwritten;
            for (int i = nnibbles - 3 << 2; i >= 0; i -= 8) {
                b = (byte)(0xFFL & v >> i);
                os.write(b);
                ++nwritten;
            }
        }
        return nwritten;
    }

    public static int packLong(OutputStream os, long v) throws IOException {
        if (v < 0L) {
            throw new IllegalArgumentException("negative value: v=" + v);
        }
        if (v >> 56 != 0L) {
            os.write((byte)(0xFFL & v >> 56 | 0x80L));
            os.write((byte)(0xFFL & v >> 48));
            os.write((byte)(0xFFL & v >> 40));
            os.write((byte)(0xFFL & v >> 32));
            os.write((byte)(0xFFL & v >> 24));
            os.write((byte)(0xFFL & v >> 16));
            os.write((byte)(0xFFL & v >> 8));
            os.write((byte)(0xFFL & v));
            return 8;
        }
        int nnibbles = LongPacker.getNibbleLength(v);
        boolean evenNibbleCount = nnibbles == nnibbles >> 1 << 1;
        int nbytes = (nnibbles + 1 >> 1) + (evenNibbleCount ? 1 : 0);
        int nwritten = 0;
        if (evenNibbleCount) {
            byte b = (byte)(nbytes << 4);
            os.write(b);
            ++nwritten;
            for (int i = nnibbles - 2 << 2; i >= 0; i -= 8) {
                b = (byte)(0xFFL & v >> i);
                os.write(b);
                ++nwritten;
            }
        } else {
            byte highByte = (byte)(0xFFL & v >> (nbytes - 1) * 8);
            byte b = (byte)(nbytes << 4 | highByte);
            os.write(b);
            ++nwritten;
            for (int i = nnibbles - 3 << 2; i >= 0; i -= 8) {
                b = (byte)(0xFFL & v >> i);
                os.write(b);
                ++nwritten;
            }
        }
        return nwritten;
    }

    public static final int packLong(long v, byte[] pbuf, IByteBuffer buf) {
        if (v < 0L) {
            throw new IllegalArgumentException("negative value: v=" + v);
        }
        if (v >> 56 != 0L) {
            pbuf[0] = (byte)(0xFFL & v >> 56 | 0x80L);
            pbuf[1] = (byte)(0xFFL & v >> 48);
            pbuf[2] = (byte)(0xFFL & v >> 40);
            pbuf[3] = (byte)(0xFFL & v >> 32);
            pbuf[4] = (byte)(0xFFL & v >> 24);
            pbuf[5] = (byte)(0xFFL & v >> 16);
            pbuf[6] = (byte)(0xFFL & v >> 8);
            pbuf[7] = (byte)(0xFFL & v);
            buf.put(pbuf, 0, 8);
            return 8;
        }
        int nnibbles = LongPacker.getNibbleLength(v);
        boolean evenNibbleCount = nnibbles == nnibbles >> 1 << 1;
        int nbytes = (nnibbles + 1 >> 1) + (evenNibbleCount ? 1 : 0);
        int nwritten = 0;
        if (evenNibbleCount) {
            byte b = (byte)(nbytes << 4);
            pbuf[nwritten++] = b;
            for (int i = nnibbles - 2 << 2; i >= 0; i -= 8) {
                b = (byte)(0xFFL & v >> i);
                pbuf[nwritten++] = b;
            }
        } else {
            byte highByte = (byte)(0xFFL & v >> (nbytes - 1) * 8);
            byte b = (byte)(nbytes << 4 | highByte);
            pbuf[nwritten++] = b;
            for (int i = nnibbles - 3 << 2; i >= 0; i -= 8) {
                b = (byte)(0xFFL & v >> i);
                pbuf[nwritten++] = b;
            }
        }
        buf.put(pbuf, 0, nwritten);
        return nwritten;
    }

    private static byte readByte(InputStream is) throws IOException {
        int v = is.read();
        if (v == -1) {
            throw new EOFException();
        }
        return (byte)(v & 0xFF);
    }

    public static int getNibbleLength(long v) {
        int i = 56;
        int j = 16;
        while (i >= 0) {
            if ((0xF0L & v >> i) != 0L) {
                return j;
            }
            if ((0xFL & v >> i) != 0L) {
                return j - 1;
            }
            i -= 8;
            j -= 2;
        }
        if (v != 0L) {
            throw new AssertionError((Object)("v=" + v));
        }
        return 1;
    }

    public static int getByteLength(long v) {
        int nnibbles = LongPacker.getNibbleLength(v);
        boolean evenNibbleCount = nnibbles == nnibbles >> 1 << 1;
        int nbytes = (nnibbles + 1 >> 1) + (evenNibbleCount ? 1 : 0);
        return nbytes;
    }

    public static long unpackLong(DataInput is) throws IOException {
        long l;
        int nbytes;
        byte b = is.readByte();
        if ((b & 0x80) != 0) {
            nbytes = 8;
            l = b & 0x7F;
        } else {
            nbytes = b >> 4;
            l = b & 0xF;
        }
        for (int i = 1; i < nbytes; ++i) {
            b = is.readByte();
            l = (l << 8) + (long)(0xFF & b);
        }
        return l;
    }

    public static long unpackLong(InputStream is) throws IOException {
        long l;
        int nbytes;
        byte b = LongPacker.readByte(is);
        if ((b & 0x80) != 0) {
            nbytes = 8;
            l = b & 0x7F;
        } else {
            nbytes = b >> 4;
            l = b & 0xF;
        }
        for (int i = 1; i < nbytes; ++i) {
            b = LongPacker.readByte(is);
            l = (l << 8) + (long)(0xFF & b);
        }
        return l;
    }

    public static final long unpackLong(byte[] buf, int off) {
        long l;
        int nbytes;
        byte b;
        if (((b = buf[off++]) & 0x80) != 0) {
            nbytes = 8;
            l = b & 0x7F;
        } else {
            nbytes = b >> 4;
            l = b & 0xF;
        }
        for (int i = 1; i < nbytes; ++i) {
            b = buf[off++];
            l = (l << 8) + (long)(0xFF & b);
        }
        return l;
    }

    public static int unpackInt(DataInput is) throws IOException {
        long v = LongPacker.unpackLong(is);
        if (v > Integer.MAX_VALUE) {
            throw new IOException();
        }
        return (int)v;
    }

    public static int unpackInt(InputStream is) throws IOException {
        long v = LongPacker.unpackLong(is);
        if (v > Integer.MAX_VALUE) {
            throw new IOException();
        }
        return (int)v;
    }

    public static interface IByteBuffer {
        public void put(byte[] var1, int var2, int var3);
    }
}

