/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.compression;

import com.bigdata.io.ByteCountInputStream;
import com.bigdata.io.ByteCountOutputStream;
import com.bigdata.io.compression.IUnicodeCompressor;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;

public class NoCompressor
implements IUnicodeCompressor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(NoCompressor.class);
    private final transient Charset cs = Charset.forName("UTF-8");

    @Override
    public int encode(CharSequence s, OutputStream os) {
        ByteCountOutputStream bcos = new ByteCountOutputStream(os);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)bcos, this.cs);
        try {
            if (s instanceof MutableString) {
                MutableString t = (MutableString)s;
                w.write(t.array(), 0, t.length());
            } else if (s instanceof String) {
                w.write((String)s);
            } else {
                w.write(s.toString());
            }
            w.flush();
            w.close();
            return bcos.getNWritten();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int decode(InputStream in, Appendable sb) {
        ByteCountInputStream bcis = new ByteCountInputStream(in);
        InputStreamReader r = new InputStreamReader((InputStream)bcis, this.cs);
        try {
            int ch;
            while ((ch = r.read()) != -1) {
                sb.append((char)ch);
            }
            int n = bcis.getNRead();
            return n;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

