/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.compression;

import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.io.compression.IRecordCompressorFactory;
import com.bigdata.io.compression.RecordCompressor;
import java.util.concurrent.TimeUnit;

public class ThreadLocalRecordCompressorFactory<A extends RecordCompressor>
implements IRecordCompressorFactory<A> {
    private final ConcurrentWeakValueCacheWithTimeout<Thread, A> cache = new ConcurrentWeakValueCacheWithTimeout(10, TimeUnit.SECONDS.toNanos(5L));
    private final IRecordCompressorFactory<A> delegate;

    public ThreadLocalRecordCompressorFactory(IRecordCompressorFactory<A> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    @Override
    public A getInstance() {
        Thread t = Thread.currentThread();
        RecordCompressor a = (RecordCompressor)this.cache.get(t);
        if (a == null && this.cache.put(t, a = this.newInstance()) != null) {
            throw new AssertionError();
        }
        return (A)a;
    }

    protected A newInstance() {
        return (A)((RecordCompressor)this.delegate.getInstance());
    }
}

