/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start;

import com.bigdata.io.SerializerUtil;
import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.ServiceConfiguration;
import com.bigdata.quorum.zk.ZKQuorumImpl;
import com.bigdata.service.jini.JiniFederation;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

public class ManageLogicalServiceTask<V extends ServiceConfiguration>
implements Callable {
    protected static final Logger log = Logger.getLogger(ManageLogicalServiceTask.class);
    protected final JiniFederation fed;
    protected final IServiceListener listener;
    protected final String configZPath;
    protected final List<String> children;
    protected final V config;

    public ManageLogicalServiceTask(JiniFederation fed, IServiceListener listener, String configZPath, List<String> children, V config) {
        this.fed = fed;
        this.listener = listener;
        this.configZPath = configZPath;
        this.children = children;
        this.config = config;
    }

    public Object call() throws Exception {
        int n = this.children.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceCount=" + ((ServiceConfiguration)this.config).serviceCount + ", actual=" + this.children.size() + ", configZPath=" + this.configZPath));
        }
        if (((ServiceConfiguration)this.config).serviceCount > n) {
            this.newLogicalService();
        } else if (((ServiceConfiguration)this.config).serviceCount < n) {
            this.destroyLogicalService();
        } else if (log.isInfoEnabled()) {
            log.info((Object)("No action required: zpath=" + this.configZPath));
        }
        return null;
    }

    protected void newLogicalService() throws KeeperException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("className=" + ((ServiceConfiguration)this.config).className));
        }
        ZooKeeper zookeeper = this.fed.getZookeeperAccessor().getZookeeper();
        List<ACL> acl = this.fed.getZooConfig().acl;
        String logicalServiceZPath = zookeeper.create(this.configZPath + "/" + "logicalService", new byte[0], acl, CreateMode.PERSISTENT_SEQUENTIAL);
        String logicalServiceZNode = logicalServiceZPath.substring(logicalServiceZPath.lastIndexOf(47) + 1);
        zookeeper.create(logicalServiceZPath + "/" + "physicalServices", new byte[0], acl, CreateMode.PERSISTENT);
        zookeeper.create(logicalServiceZPath + "/" + "masterElection", new byte[0], acl, CreateMode.PERSISTENT);
        ZKQuorumImpl.setupQuorum(logicalServiceZPath, 1, this.fed.getZookeeperAccessor().getZookeeper(), acl);
        try {
            String lockNodeZPath = this.fed.getZooConfig().zroot + "/" + "locks/createPhysicalService" + "/" + ((ServiceConfiguration)this.config).className + "_" + logicalServiceZNode;
            zookeeper.create(lockNodeZPath, SerializerUtil.serialize(logicalServiceZPath), acl, CreateMode.PERSISTENT);
            if (log.isInfoEnabled()) {
                log.info((Object)("Created lock node: " + lockNodeZPath));
            }
        }
        catch (KeeperException.NodeExistsException ex) {
            // empty catch block
        }
    }

    protected void destroyLogicalService() {
        log.warn((Object)("className=" + ((ServiceConfiguration)this.config).className));
    }
}

