/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start;

import com.bigdata.io.SerializerUtil;
import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.ServiceConfigurationZNodeMonitorTask;
import com.bigdata.jini.start.config.ManagedServiceConfiguration;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.InnerCause;
import com.bigdata.zookeeper.UnknownChildrenWatcher;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class MonitorConfigZNodeTask
implements Callable<Void> {
    protected static final Logger log = Logger.getLogger(MonitorConfigZNodeTask.class);
    private final JiniFederation fed;
    private final IServiceListener listener;

    public MonitorConfigZNodeTask(JiniFederation fed, IServiceListener listener) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
        this.listener = listener;
    }

    @Override
    public Void call() throws Exception {
        String configZPath = this.fed.getZooConfig().zroot + "/" + "config";
        while (true) {
            try {
                while (true) {
                    this.acquireWatcherAndRun(configZPath);
                }
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Interrupted");
                    }
                    throw new RuntimeException(t);
                }
                log.error((Object)this, t);
                Thread.sleep(2000L);
                continue;
            }
            break;
        }
    }

    protected void acquireWatcherAndRun(String configZPath) throws KeeperException, InterruptedException {
        ZooKeeper zookeeper = this.fed.getZookeeper();
        UnknownChildrenWatcher watcher = new UnknownChildrenWatcher(zookeeper, configZPath);
        try {
            while (true) {
                String znode = watcher.queue.take();
                String serviceConfigZPath = configZPath + "/" + znode;
                this.handleNewConfigZNode(zookeeper, serviceConfigZPath);
            }
        }
        catch (Throwable throwable) {
            watcher.cancel();
            throw throwable;
        }
    }

    protected void handleNewConfigZNode(ZooKeeper zookeeper, String serviceConfigZPath) throws KeeperException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("new config: zpath=" + serviceConfigZPath));
        }
        ManagedServiceConfiguration config = (ManagedServiceConfiguration)SerializerUtil.deserialize(zookeeper.getData(serviceConfigZPath, false, new Stat()));
        if (log.isInfoEnabled()) {
            log.info((Object)("config state: " + config));
        }
        ServiceConfigurationZNodeMonitorTask task = new ServiceConfigurationZNodeMonitorTask(this.fed, this.listener, config.className);
        this.fed.submitMonitoredTask(task);
    }
}

