/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start;

import com.bigdata.jini.start.AbstractServicesManagerService;
import com.bigdata.jini.start.ServicesManagerStartupTask;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.DefaultServiceFederationDelegate;
import com.bigdata.service.jini.AbstractServer;
import com.bigdata.service.jini.FakeLifeCycle;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.RemoteAdministrable;
import com.bigdata.service.jini.RemoteDestroyAdmin;
import com.sun.jini.start.LifeCycle;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.util.Properties;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationFile;
import net.jini.config.ConfigurationProvider;
import net.jini.export.ServerContext;
import net.jini.io.context.ClientHost;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class ServicesManagerServer
extends AbstractServer {
    protected static final Logger log = Logger.getLogger(ServicesManagerServer.class);
    private final String[] args;

    public ServicesManagerServer(String[] args, LifeCycle lifeCycle) {
        super(args, lifeCycle);
        this.args = args;
    }

    public static void main(String[] args) {
        new ServicesManagerServer(args, new FakeLifeCycle()).run();
        System.exit(0);
    }

    @Override
    protected AdministrableServicesManagerService newService(Properties properties) {
        AdministrableServicesManagerService service = new AdministrableServicesManagerService(this, properties);
        this.getClient().setDelegate(new DefaultServiceFederationDelegate<AdministrableServicesManagerService>(service));
        return service;
    }

    public static class AdministrableServicesManagerService
    extends AbstractServicesManagerService
    implements RemoteAdministrable,
    RemoteDestroyAdmin {
        protected final ServicesManagerServer server;

        public AdministrableServicesManagerService(ServicesManagerServer server, Properties properties) {
            super(properties);
            this.server = server;
        }

        public Object getAdmin() throws RemoteException {
            if (log.isInfoEnabled()) {
                log.info((Object)("" + this.getServiceUUID()));
            }
            return this.server.proxy;
        }

        @Override
        protected void setupLoggingContext() {
            try {
                InetAddress clientAddr = ((ClientHost)ServerContext.getServerContextElement(ClientHost.class)).getClientHost();
                MDC.put((String)"clientname", (Object)clientAddr.getHostName());
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
        }

        @Override
        protected void clearLoggingContext() {
            MDC.remove((String)"clientname");
        }

        @Override
        public synchronized void destroy() {
            if (!this.server.isShuttingDown()) {
                this.server.runDestroy();
            } else if (this.isOpen()) {
                super.destroy();
            }
        }

        @Override
        public synchronized void shutdown() {
            super.shutdown();
            this.server.shutdownNow(false);
        }

        @Override
        public synchronized void shutdownNow() {
            super.shutdownNow();
            this.server.shutdownNow(false);
        }

        @Override
        public JiniFederation<?> getFederation() {
            return this.server.getClient().getFederation();
        }

        @Override
        public String getServiceName() {
            String s = this.server.getServiceName();
            if (s == null) {
                s = super.getServiceName();
            }
            return s;
        }

        @Override
        public AdministrableServicesManagerService start() {
            super.start();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sighup(boolean pushConfig, boolean restartServices) throws ConfigurationException {
            this.setupLoggingContext();
            try {
                log.warn((Object)("pushConfig=" + pushConfig + ", restartServices=" + restartServices));
                AbstractFederation fed = this.getFederation();
                ConfigurationFile config = (ConfigurationFile)ConfigurationProvider.getInstance((String[])this.server.args);
                ((JiniFederation)fed).submitMonitoredTask(new ServicesManagerStartupTask((JiniFederation)fed, (Configuration)config, pushConfig, restartServices, this));
            }
            finally {
                this.clearLoggingContext();
            }
        }
    }

    public static interface Options {
        public static final String NAMESPACE = ServicesManagerServer.class.getName();
    }
}

