/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.jini.lookup.entry.Hostname;
import com.bigdata.jini.lookup.entry.ServiceDir;
import com.bigdata.jini.lookup.entry.ServiceUUID;
import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.JavaServiceConfiguration;
import com.bigdata.jini.start.config.ManagedServiceConfiguration;
import com.bigdata.jini.start.config.ServiceConfiguration;
import com.bigdata.jini.start.process.JiniServiceProcessHelper;
import com.bigdata.jini.start.process.ProcessHelper;
import com.bigdata.jini.util.ConfigMath;
import com.bigdata.jini.util.JiniUtil;
import com.bigdata.service.jini.JiniClient;
import com.bigdata.service.jini.JiniClientConfig;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.util.config.NicUtil;
import com.bigdata.zookeeper.ZNodeCreatedWatcher;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.entry.Comment;
import net.jini.lookup.entry.Name;
import org.apache.zookeeper.KeeperException;

public abstract class JiniServiceConfiguration
extends ManagedServiceConfiguration {
    public final Entry[] entries;
    public final String[] groups;
    public final LookupLocator[] locators;
    public final Properties properties;
    public final String[] jiniOptions;

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", entries=" + Arrays.toString(this.entries));
        sb.append(", groups=" + Arrays.toString(this.groups));
        sb.append(", locators=" + Arrays.toString(this.locators));
        sb.append(", properties=" + this.properties);
        sb.append(", jiniOptions=" + Arrays.toString(this.jiniOptions));
    }

    public JiniServiceConfiguration(String className, Configuration config) throws ConfigurationException {
        super(className, config);
        JiniClientConfig tmp = new JiniClientConfig(className, config);
        this.entries = tmp.entries;
        this.groups = tmp.groups;
        this.locators = tmp.locators;
        this.properties = JiniClient.getProperties(className, config);
        this.jiniOptions = JiniServiceConfiguration.getJiniOptions(className, config);
        if (this.groups == null) {
            log.warn((Object)"groups = ALL_GROUPS");
        } else if ("".equals(this.groups)) {
            log.warn((Object)"groups = NO_GROUPS");
        } else {
            log.warn((Object)("groups = " + Arrays.toString(this.groups)));
        }
    }

    @Override
    public JiniServiceStarter newServiceStarter(JiniFederation fed, IServiceListener listener, String zpath, Entry[] attributes) throws Exception {
        return new JiniServiceStarter(fed, listener, zpath, attributes);
    }

    public static String[] getJiniOptions(String className, Configuration config) throws ConfigurationException {
        return ConfigMath.concat(JiniServiceConfiguration.getStringArray("jiniOptions", JiniClient.class.getName(), config, new String[0]), JiniServiceConfiguration.getStringArray("jiniOptions", className, config, new String[0]));
    }

    public class JiniServiceStarter<V extends JiniServiceProcessHelper>
    extends ManagedServiceConfiguration.ManagedServiceStarter<V> {
        private final String CONFIG_FILE = "service.config";
        final File configFile;

        protected JiniServiceStarter(JiniFederation fed, IServiceListener listener, String logicalServiceZPath, Entry[] attributes) {
            super(JiniServiceConfiguration.this, fed, listener, logicalServiceZPath, attributes);
            this.CONFIG_FILE = "service.config";
            this.configFile = new File(this.serviceDir, "service.config");
        }

        public String[] getImports() {
            return new String[]{"net.jini.jeri.BasicILFactory", "net.jini.jeri.BasicJeriExporter", "net.jini.jeri.tcp.TcpServerEndpoint", "net.jini.discovery.LookupDiscovery", "net.jini.core.discovery.LookupLocator", "net.jini.core.entry.Entry", "net.jini.lookup.entry.Name", "net.jini.lookup.entry.Comment", "net.jini.lookup.entry.Address", "net.jini.lookup.entry.Location", "net.jini.lookup.entry.ServiceInfo", "java.io.File", "com.bigdata.util.NV", "com.bigdata.service.IBigdataClient", "com.bigdata.service.jini.*", "org.apache.zookeeper.ZooDefs", "org.apache.zookeeper.data.ACL", "org.apache.zookeeper.data.Id"};
        }

        @Override
        protected void addServiceOptions(List<String> cmds) {
            cmds.add(this.configFile.toString());
            super.addServiceOptions(cmds);
            for (String arg : JiniServiceConfiguration.this.jiniOptions) {
                cmds.add(arg);
            }
        }

        @Override
        protected void setUp() throws Exception {
            super.setUp();
            if (!this.restart) {
                this.writeConfigFile();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeConfigFile() throws IOException {
            StringWriter out = new StringWriter();
            this.writeConfigFile(out);
            out.flush();
            String contents = out.toString();
            if (ServiceConfiguration.log.isInfoEnabled()) {
                ServiceConfiguration.log.info((Object)("configFile=" + this.configFile + "\n" + contents));
            }
            try (OutputStreamWriter out2 = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(this.configFile)));){
                out2.write(contents);
                ((Writer)out2).flush();
            }
        }

        protected void writeConfigFile(Writer out) throws IOException {
            this.writeComments(out);
            out.write("\n");
            for (String i : this.getImports()) {
                out.write("import " + i + ";\n");
            }
            out.write("\n");
            out.write("\n\n" + JiniClient.class.getName() + " {\n");
            this.writeEntries(out);
            this.writeGroups(out);
            this.writeLocators(out);
            out.write("}\n");
            out.write("\n\n" + JiniServiceConfiguration.this.className + " {\n");
            this.writeServiceDescription(out);
            out.write("}\n");
            this.writeZookeeperClientConfigEntries(out);
        }

        protected void writeComments(Writer out) throws IOException {
            out.write("// className=" + JiniServiceConfiguration.this.className + "\n");
            out.write("// date=" + new Date() + "\n");
        }

        protected Entry[] getEntries(Entry[] entries) throws IOException {
            Name serviceName = new Name(this.serviceName);
            ServiceDir serviceDir = new ServiceDir(this.serviceDir);
            String serviceIpAddr = NicUtil.getIpAddress("default.nic", "default", false);
            if (null == serviceIpAddr) {
                throw new IOException("Can't get a host ip address");
            }
            Hostname hostName = new Hostname(serviceIpAddr);
            ServiceUUID serviceUUID = new ServiceUUID(this.serviceUUID);
            return ConfigMath.concat(new Entry[]{serviceName, hostName, serviceDir, serviceUUID}, entries);
        }

        protected void writeEntries(Writer out) throws IOException {
            Entry[] entries = this.getEntries(JiniServiceConfiguration.this.entries);
            out.write("\nentries = new Entry[]{\n");
            for (Entry e : entries) {
                this.writeEntry(out, e);
                out.write(",\n");
            }
            out.write("};\n");
        }

        protected void writeEntry(Writer out, Entry e) throws IOException {
            Class<?> cls = e.getClass();
            out.write("new " + e.getClass().getName() + "(");
            if (Name.class.equals(cls)) {
                out.write(ConfigMath.q(((Name)e).name));
            } else if (Comment.class.equals(cls)) {
                out.write(ConfigMath.q(((Comment)e).comment));
            } else if (Hostname.class.equals(cls)) {
                out.write(ConfigMath.q(((Hostname)e).hostname));
            } else if (ServiceDir.class.equals(cls)) {
                out.write("new java.io.File(" + ConfigMath.q(((ServiceDir)e).serviceDir.toString()) + ")");
            } else if (ServiceUUID.class.equals(cls)) {
                out.write("java.util.UUID.fromString(" + ConfigMath.q(((ServiceUUID)e).serviceUUID.toString()) + ")");
            } else {
                throw new UnsupportedOperationException("Can not emit entry: cls=" + cls.getName());
            }
            out.write(")");
        }

        protected void writeGroups(Writer out) throws IOException {
            if (JiniServiceConfiguration.this.groups == null) {
                out.write("\ngroups=null;\n");
            } else {
                out.write("\ngroups=new String[]{\n");
                for (int i = 0; i < JiniServiceConfiguration.this.groups.length - 1; ++i) {
                    out.write(ConfigMath.q(JiniServiceConfiguration.this.groups[i]) + ",");
                }
                out.write(ConfigMath.q(JiniServiceConfiguration.this.groups[JiniServiceConfiguration.this.groups.length - 1]) + "\n");
                out.write("};\n");
            }
        }

        protected void writeLocators(Writer out) throws IOException {
            out.write("\nlocators=new " + LookupLocator.class.getName() + "[]{\n");
            if (JiniServiceConfiguration.this.locators != null) {
                for (int i = 0; i < JiniServiceConfiguration.this.locators.length - 1; ++i) {
                    out.write("new " + LookupLocator.class.getName() + "(\"" + JiniServiceConfiguration.this.locators[i].getHost() + "\"," + JiniServiceConfiguration.this.locators[i].getPort() + "),\n");
                }
                if (JiniServiceConfiguration.this.locators.length > 0) {
                    out.write("new " + LookupLocator.class.getName() + "(\"" + JiniServiceConfiguration.this.locators[JiniServiceConfiguration.this.locators.length - 1].getHost() + "\"," + JiniServiceConfiguration.this.locators[JiniServiceConfiguration.this.locators.length - 1].getPort() + ")\n");
                }
            }
            out.write("};\n");
        }

        protected void writeServiceDescription(Writer out) throws IOException {
            this.writeExporterEntry(out);
            this.writeServiceDirEntry(out);
            this.writeLogicalServiceZPathEntry(out);
            this.writeProperties(out);
        }

        protected void writeProperties(Writer out) throws IOException {
            Properties properties = this.getProperties(JiniServiceConfiguration.this.properties);
            out.write("\nproperties = new NV[]{\n");
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String k = e.nextElement().toString();
                String v = properties.getProperty(k);
                out.write("new NV( " + ConfigMath.q(k) + ", " + ConfigMath.q(v) + "),\n");
            }
            out.write("};\n");
        }

        protected Properties getProperties(Properties properties) {
            return properties;
        }

        protected void writeExporterEntry(Writer out) throws IOException {
            out.write("\nexporter = new " + BasicJeriExporter.class.getName() + "(" + TcpServerEndpoint.class.getName() + ".getInstance(0)," + "new " + BasicILFactory.class.getName() + "());\n");
        }

        protected void writeServiceDirEntry(Writer out) throws IOException {
            out.write("\nserviceDir= new File(" + ConfigMath.q(this.serviceDir.toString()) + ");\n");
        }

        protected void writeLogicalServiceZPathEntry(Writer out) throws IOException {
            out.write("\nlogicalServiceZPath=" + ConfigMath.q(this.logicalServiceZPath) + ";\n");
        }

        protected void writeZookeeperClientConfigEntries(Writer out) throws IOException {
            out.write("\n");
            this.fed.getZooConfig().writeConfiguration(out);
        }

        @Override
        protected V newProcessHelper(String className, ProcessBuilder processBuilder, IServiceListener listener) throws IOException {
            return (V)new JiniServiceProcessHelper(className, processBuilder, listener);
        }

        @Override
        protected void awaitServiceStart(V processHelper, long timeout, TimeUnit unit) throws Exception, TimeoutException, InterruptedException {
            long nanos;
            long begin = System.nanoTime();
            long remaining = nanos = unit.toNanos(timeout);
            ServiceItem serviceItem = this.awaitServiceDiscoveryOrDeath((ProcessHelper)processHelper, remaining, TimeUnit.NANOSECONDS);
            ((JiniServiceProcessHelper)processHelper).setServiceItem(serviceItem);
            remaining = nanos - (System.nanoTime() - begin);
            this.awaitZNodeCreatedOrDeath(serviceItem, (ProcessHelper)processHelper, remaining, TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ServiceItem awaitServiceDiscoveryOrDeath(ProcessHelper processHelper, long timeout, TimeUnit unit) throws Exception, TimeoutException, InterruptedException {
            timeout = unit.toMillis(timeout);
            long begin = System.currentTimeMillis();
            ServiceDiscoveryManager serviceDiscoveryManager = null;
            try {
                serviceDiscoveryManager = new ServiceDiscoveryManager((DiscoveryManagement)this.fed.getDiscoveryManagement(), new LeaseRenewalManager());
                if (ServiceConfiguration.log.isInfoEnabled()) {
                    ServiceConfiguration.log.info((Object)("Awaiting service discovery: " + processHelper.name));
                }
                ServiceID serviceID = JiniUtil.uuid2ServiceID(this.serviceUUID);
                Object[] items = serviceDiscoveryManager.lookup(new ServiceTemplate(serviceID, null, null), 1, 1, null, timeout);
                long elapsed = System.currentTimeMillis() - begin;
                if (items.length == 0) {
                    throw new Exception("Service did not start: elapsed=" + elapsed + ", name=" + this.serviceName);
                }
                if (items.length != 1) {
                    throw new Exception("Duplicate ServiceTokens? name=" + this.serviceName + ", found=" + Arrays.toString(items));
                }
                if (ServiceConfiguration.log.isInfoEnabled()) {
                    ServiceConfiguration.log.info((Object)("Discovered service: elapsed=" + elapsed + ", name=" + processHelper.name + ", item=" + items[0]));
                }
                ServiceItem serviceItem = items[0];
                return serviceItem;
            }
            finally {
                if (serviceDiscoveryManager != null) {
                    serviceDiscoveryManager.terminate();
                }
            }
        }

        public void awaitZNodeCreatedOrDeath(ServiceItem serviceItem, ProcessHelper processHelper, long timeout, TimeUnit unit) throws KeeperException, InterruptedException, TimeoutException {
            String physicalServiceZPath = this.logicalServiceZPath + "/" + "physicalServices" + "/" + this.serviceUUID;
            if (!ZNodeCreatedWatcher.awaitCreate(this.fed.getZookeeper(), physicalServiceZPath, timeout, unit)) {
                throw new TimeoutException("zpath does not exist: " + physicalServiceZPath);
            }
            if (ServiceConfiguration.log.isInfoEnabled()) {
                ServiceConfiguration.log.info((Object)("znode exists: zpath=" + physicalServiceZPath));
            }
        }
    }

    public static interface Options
    extends JavaServiceConfiguration.Options,
    JiniClientConfig.Options {
        public static final String JINI_OPTIONS = "jiniOptions";
    }
}

