/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.jini.lookup.entry.ServiceUUID;
import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.ManageLogicalServiceTask;
import com.bigdata.jini.start.config.JavaServiceConfiguration;
import com.bigdata.jini.start.process.ProcessHelper;
import com.bigdata.service.jini.JiniFederation;
import java.io.File;
import java.util.List;
import java.util.UUID;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.Name;
import org.apache.zookeeper.ZooKeeper;

public abstract class ManagedServiceConfiguration
extends JavaServiceConfiguration {
    public ManagedServiceConfiguration(String className, Configuration config) throws ConfigurationException {
        super(className, config);
    }

    @Override
    public ManagedServiceStarter newServiceStarter(IServiceListener listener) throws Exception {
        throw new UnsupportedOperationException();
    }

    public ManagedServiceStarter newServiceStarter(JiniFederation fed, IServiceListener listener, String logicalServiceZPath, Entry[] attributes) throws Exception {
        return new ManagedServiceStarter(fed, listener, logicalServiceZPath, attributes);
    }

    public ManageLogicalServiceTask<ManagedServiceConfiguration> newLogicalServiceTask(JiniFederation fed, IServiceListener listener, String configZPath, List<String> children) {
        return new ManageLogicalServiceTask<ManagedServiceConfiguration>(fed, listener, configZPath, children, this);
    }

    public class ManagedServiceStarter<V extends ProcessHelper>
    extends JavaServiceConfiguration.JavaServiceStarter<V> {
        protected final JiniFederation fed;
        protected final String logicalServiceZPath;
        public final String logicalServiceZNode;
        public final boolean restart;
        public final UUID serviceUUID;
        public final String serviceName;
        public final File serviceDir;

        protected ManagedServiceStarter(JiniFederation fed, IServiceListener listener, String logicalServiceZPath, Entry[] attributes) {
            super(listener);
            if (fed == null) {
                throw new IllegalArgumentException();
            }
            if (listener == null) {
                throw new IllegalArgumentException();
            }
            if (logicalServiceZPath == null) {
                throw new IllegalArgumentException();
            }
            this.fed = fed;
            this.logicalServiceZPath = logicalServiceZPath;
            this.logicalServiceZNode = logicalServiceZPath.substring(logicalServiceZPath.lastIndexOf(47) + 1);
            boolean bl = this.restart = attributes != null;
            if (this.restart) {
                String serviceName = null;
                UUID serviceUUID = null;
                for (Entry e : attributes) {
                    if (serviceName == null && e instanceof Name) {
                        serviceName = ((Name)e).name;
                        continue;
                    }
                    if (serviceUUID != null || !(e instanceof ServiceUUID)) continue;
                    serviceUUID = ((ServiceUUID)e).serviceUUID;
                }
                if (serviceName == null) {
                    throw new RuntimeException("Attribute not found: " + Name.class.getName());
                }
                if (serviceUUID == null) {
                    throw new RuntimeException("Attribute not found: " + ServiceUUID.class.getName());
                }
                this.serviceName = serviceName;
                this.serviceUUID = serviceUUID;
            } else {
                this.serviceUUID = UUID.randomUUID();
                this.serviceName = this.cls.getSimpleName() + "/" + this.logicalServiceZNode + "/" + this.serviceUUID;
            }
            this.serviceDir = new File(new File(new File(ManagedServiceConfiguration.this.serviceDir, this.cls.getSimpleName()), this.logicalServiceZNode), this.serviceUUID.toString());
        }

        @Override
        protected File getServiceDir() {
            return this.serviceDir;
        }

        @Override
        protected void setUp() throws Exception {
            String zpath;
            ZooKeeper zookeeper = this.fed.getZookeeper();
            if (zookeeper.exists(zpath = this.logicalServiceZPath, false) == null) {
                throw new IllegalStateException("Not found: " + zpath);
            }
            zpath = this.logicalServiceZPath + "/" + "physicalServices";
            if (zookeeper.exists(zpath, false) == null) {
                throw new IllegalStateException("Not found: " + zpath);
            }
            zpath = this.logicalServiceZPath + "/" + "masterElection";
            if (zookeeper.exists(zpath, false) == null) {
                throw new IllegalStateException("Not found: " + zpath);
            }
            super.setUp();
        }
    }

    public static interface Options
    extends JavaServiceConfiguration.Options {
    }
}

