/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.IServiceConstraint;
import com.bigdata.jini.start.process.ProcessHelper;
import com.bigdata.jini.util.ConfigMath;
import com.bigdata.service.jini.IReplicatableService;
import com.bigdata.service.jini.JiniFederation;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.system.SystemUtil;

public abstract class ServiceConfiguration
implements Serializable {
    protected static final Logger log = Logger.getLogger(ServiceConfiguration.class);
    private static final long serialVersionUID = 648244470740671354L;
    public final String className;
    public final String[] args;
    public String[] options;
    public final File serviceDir;
    public final int serviceCount;
    public final int replicationCount;
    public final IServiceConstraint[] constraints;
    public final long timeout;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{ className=" + this.className);
        sb.append(", args=" + Arrays.toString(this.args));
        sb.append(", options=" + Arrays.toString(this.options));
        sb.append(", serviceDir=" + this.serviceDir);
        sb.append(", timeout=" + this.timeout);
        sb.append(", serviceCount=" + this.serviceCount);
        sb.append(", replicationCount=" + this.replicationCount);
        sb.append(", constraints=" + Arrays.toString(this.constraints));
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
    }

    public ServiceConfiguration(String className, Configuration config) throws ConfigurationException {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        this.className = className;
        if (log.isInfoEnabled()) {
            log.info((Object)("className=" + className));
        }
        this.args = ServiceConfiguration.getArgs(className, config);
        if (this.args == null) {
            throw new IllegalArgumentException();
        }
        for (String s : this.args) {
            if (s != null) continue;
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("args=" + Arrays.toString(this.args)));
        }
        this.options = ServiceConfiguration.getOptions(className, config);
        if (this.options == null) {
            throw new IllegalArgumentException();
        }
        for (String s : this.options) {
            if (s != null) continue;
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("options=" + Arrays.toString(this.options)));
        }
        this.serviceDir = ServiceConfiguration.getServiceDir(className, config);
        if (this.serviceDir == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceDir=" + this.serviceDir));
        }
        this.timeout = ServiceConfiguration.getTimeout(className, config, this.getDefaultTimeout());
        if (log.isInfoEnabled()) {
            log.info((Object)("timeout=" + this.timeout));
        }
        this.serviceCount = ServiceConfiguration.getServiceCount(className, config);
        if (this.serviceCount < 0) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceCount=" + this.serviceCount));
        }
        this.replicationCount = ServiceConfiguration.getReplicationCount(className, config);
        if (this.replicationCount < 1) {
            throw new IllegalArgumentException();
        }
        if (this.replicationCount != 1) {
            try {
                Class<IReplicatableService> cls = Class.forName(className);
                if (!cls.isAssignableFrom(IReplicatableService.class)) {
                    throw new IllegalArgumentException();
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException();
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("replicationCount=" + this.replicationCount));
        }
        this.constraints = ServiceConfiguration.getConstraints(className, config);
        if (log.isInfoEnabled()) {
            log.info((Object)("constraints=" + Arrays.toString(this.constraints)));
        }
    }

    protected long getDefaultTimeout() {
        return 20000L;
    }

    protected static long getTimeout(String className, Configuration config, long defaultValue) throws ConfigurationException {
        return (Long)config.getEntry(className, "timeout", Long.TYPE, config.getEntry(Options.NAMESPACE, "timeout", Long.TYPE, (Object)defaultValue));
    }

    public boolean canStartService(JiniFederation fed) {
        return this.canStartService(fed, null);
    }

    public boolean canStartService(JiniFederation fed, List<IServiceConstraint> violatedConstraints) {
        boolean canStart = true;
        for (IServiceConstraint constraint : this.constraints) {
            try {
                if (constraint.allow(fed)) continue;
                if (violatedConstraints != null) {
                    violatedConstraints.add(constraint);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Violates constraint: class=" + this.className + ", constraint=" + constraint));
                }
                canStart = false;
            }
            catch (Exception ex) {
                log.error((Object)this, (Throwable)ex);
                return false;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("canStart=" + canStart + " : " + this));
        }
        return canStart;
    }

    public abstract AbstractServiceStarter newServiceStarter(IServiceListener var1) throws Exception;

    public static File getServiceDir(String className, Configuration config) throws ConfigurationException {
        File val = (File)config.getEntry(className, "serviceDir", File.class, null);
        if (val == null) {
            val = (File)config.getEntry(Options.NAMESPACE, "serviceDir", File.class, null);
        }
        return val;
    }

    public static int getServiceCount(String className, Configuration config) throws ConfigurationException {
        return (Integer)config.getEntry(className, "serviceCount", Integer.TYPE, (Object)1);
    }

    public static int getReplicationCount(String className, Configuration config) throws ConfigurationException {
        return (Integer)config.getEntry(className, "replicationCount", Integer.TYPE, (Object)1);
    }

    public static String[] getArgs(String className, Configuration config) throws ConfigurationException {
        if (config.getEntry(Options.NAMESPACE, "args", String[].class, null) != null) {
            throw new ConfigurationException("Not permitted in global scope: args");
        }
        return (String[])config.getEntry(className, "args", String[].class, (Object)new String[0]);
    }

    public static String[] getOptions(String className, Configuration config) throws ConfigurationException {
        if (config.getEntry(Options.NAMESPACE, "options", String[].class, null) != null) {
            throw new ConfigurationException("Not permitted in global scope: options");
        }
        return (String[])config.getEntry(className, "options", String[].class, (Object)new String[0]);
    }

    protected static IServiceConstraint[] getConstraints(String className, Configuration config) throws ConfigurationException {
        IServiceConstraint[] a = (IServiceConstraint[])config.getEntry(className, "constraints", IServiceConstraint[].class, null);
        IServiceConstraint[] b = (IServiceConstraint[])config.getEntry(Options.NAMESPACE, "constraints", IServiceConstraint[].class, (Object)new IServiceConstraint[0]);
        if (a != null && b != null) {
            return ConfigMath.concat(a, b);
        }
        if (a != null) {
            return a;
        }
        return b;
    }

    protected static String[] getStringArray(String name, String className, Configuration config, String[] defaultValue) throws ConfigurationException {
        String[] a = (String[])config.getEntry(className, name, String[].class, null);
        String[] b = (String[])config.getEntry(Options.NAMESPACE, name, String[].class, (Object)defaultValue);
        if (a != null && b != null) {
            return ConfigMath.concat(a, b);
        }
        if (a != null) {
            return a;
        }
        return b;
    }

    public static <T> T[] concat(T[] a, T[] b) {
        return ConfigMath.concat(a, b);
    }

    public static String[] getClassPath() {
        return System.getProperty("java.class.path").split(File.pathSeparator);
    }

    public abstract class AbstractServiceStarter<V extends ProcessHelper>
    implements Callable<V> {
        protected final IServiceListener listener;

        protected AbstractServiceStarter(IServiceListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException();
            }
            this.listener = listener;
        }

        @Override
        public V call() throws Exception {
            if (log.isInfoEnabled()) {
                log.info((Object)("config: " + this));
            }
            this.setUp();
            ProcessBuilder processBuilder = this.newProcessBuilder();
            this.writeStartFile(processBuilder);
            V processHelper = this.newProcessHelper(ServiceConfiguration.this.className, processBuilder, this.listener);
            Future future = null;
            try {
                future = ((ProcessHelper)processHelper).interruptWhenProcessDies(ServiceConfiguration.this.timeout, TimeUnit.MILLISECONDS);
                this.awaitServiceStart(processHelper, ServiceConfiguration.this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                try {
                    int exitValue = ((ProcessHelper)processHelper).exitValue(10L, TimeUnit.MILLISECONDS);
                    throw new IOException("Process is dead: exitValue=" + exitValue);
                }
                catch (TimeoutException ex2) {
                    throw ex;
                }
            }
            catch (Throwable t) {
                try {
                    log.error((Object)("Startup problem: " + ServiceConfiguration.this.className), t);
                    throw new RuntimeException(t);
                }
                catch (Throwable throwable) {
                    ((ProcessHelper)processHelper).kill(true);
                    throw throwable;
                }
            }
            finally {
                if (future != null) {
                    future.cancel(true);
                }
            }
            return processHelper;
        }

        protected void setUp() throws Exception {
            File serviceDir = this.getServiceDir();
            if (!serviceDir.exists()) {
                serviceDir.mkdirs();
            }
        }

        protected File getServiceDir() {
            return ServiceConfiguration.this.serviceDir;
        }

        protected V newProcessHelper(String className, ProcessBuilder processBuilder, IServiceListener listener) throws IOException {
            return (V)new ProcessHelper(className, processBuilder, listener);
        }

        public ProcessBuilder newProcessBuilder() {
            List<String> cmds = this.getCommandLine();
            ProcessBuilder processBuilder = this.newProcessBuilder(cmds);
            this.setUpEnvironment(processBuilder.environment());
            processBuilder.directory(this.getServiceDir());
            return processBuilder;
        }

        protected void setUpEnvironment(Map<String, String> env) {
        }

        protected List<String> getCommandLine() {
            LinkedList<String> cmds = new LinkedList<String>();
            this.addCommand(cmds);
            this.addCommandArgs(cmds);
            this.addServiceOptions(cmds);
            return cmds;
        }

        protected ProcessBuilder newProcessBuilder(List<String> cmds) {
            return new ProcessBuilder(cmds);
        }

        protected abstract void addCommand(List<String> var1);

        protected void addCommandArgs(List<String> cmds) {
            for (String arg : ServiceConfiguration.this.args) {
                cmds.add(arg);
            }
        }

        protected void addServiceOptions(List<String> cmds) {
            for (String arg : ServiceConfiguration.this.options) {
                cmds.add(arg);
            }
        }

        protected void awaitServiceStart(V processHelper, long timeout, TimeUnit unit) throws Exception {
            try {
                int exitValue = ((ProcessHelper)processHelper).exitValue(timeout, unit);
                throw new IOException("exitValue=" + exitValue);
            }
            catch (TimeoutException ex) {
                log.warn((Object)("Started service: " + ServiceConfiguration.this.className));
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeStartFile(ProcessBuilder processBuilder) throws IOException {
            File file = new File(this.getServiceDir(), "startService" + (SystemUtil.isWindows() ? ".bat" : ""));
            try (FileWriter os = new FileWriter(file);){
                os.write(ProcessHelper.getEnvironment(processBuilder) + "\n" + ProcessHelper.getCommandString(processBuilder) + "\n");
            }
        }
    }

    public static interface Options {
        public static final String NAMESPACE = ServiceConfiguration.class.getName();
        public static final String ARGS = "args";
        public static final String OPTIONS = "options";
        public static final String SERVICE_DIR = "serviceDir";
        public static final String SERVICE_COUNT = "serviceCount";
        public static final String REPLICATION_COUNT = "replicationCount";
        public static final String CONSTRAINTS = "constraints";
        public static final String TIMEOUT = "timeout";
    }
}

