/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.jini.util.ConfigMath;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class ZookeeperClientConfig {
    private static final Logger log = Logger.getLogger(ZookeeperClientConfig.class);
    public final String zroot;
    public final int sessionTimeout;
    public final String servers;
    public final List<ACL> acl;

    public ZookeeperClientConfig() throws ConfigurationException {
        this.zroot = System.getProperty(Options.NAMESPACE + "." + "zroot");
        this.sessionTimeout = Integer.parseInt(System.getProperty(Options.NAMESPACE + "." + "sessionTimeout", "5000"));
        this.servers = System.getProperty(Options.NAMESPACE + "." + "servers");
        if (this.servers == null) {
            throw new ConfigurationException("Must specify: " + Options.NAMESPACE + "." + "servers");
        }
        if (this.servers.matches("\\s")) {
            throw new ConfigurationException("Whitespace not allowed in servers : " + this.servers);
        }
        this.acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        if (log.isInfoEnabled()) {
            log.info((Object)this.toString());
        }
    }

    public ZookeeperClientConfig(Configuration config) throws ConfigurationException {
        this.zroot = (String)config.getEntry(Options.NAMESPACE, "zroot", String.class);
        this.sessionTimeout = (Integer)config.getEntry(Options.NAMESPACE, "sessionTimeout", Integer.TYPE, (Object)5000);
        this.servers = (String)config.getEntry(Options.NAMESPACE, "servers", String.class);
        if (this.servers.matches("\\s")) {
            throw new ConfigurationException("Whitespace not allowed in servers : " + this.servers);
        }
        this.acl = Arrays.asList((ACL[])config.getEntry(Options.NAMESPACE, "acl", ACL[].class, (Object)ZooDefs.Ids.OPEN_ACL_UNSAFE.toArray(new ACL[0])));
        if (log.isInfoEnabled()) {
            log.info((Object)this.toString());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ zroot=" + this.zroot + ", sessionTimeout=" + this.sessionTimeout + ", servers=" + this.servers + ", acl=" + this.acl + "}";
    }

    public void writeConfiguration(Writer w) throws IOException {
        w.write(Options.NAMESPACE + " {\n");
        w.write("zroot=" + ConfigMath.q(this.zroot) + ";\n");
        w.write("servers=" + ConfigMath.q(this.servers) + ";\n");
        w.write("sessionTimeout=" + this.sessionTimeout + ";\n");
        w.write("acl= new " + ACL.class.getName() + "[] {\n");
        for (ACL x : this.acl) {
            w.write("new " + ACL.class.getName() + "(");
            w.write(Integer.toString(x.getPerms()));
            w.write(",");
            w.write("new " + Id.class.getName() + "(");
            w.write(ConfigMath.q(x.getId().getScheme()));
            w.write(",");
            w.write(ConfigMath.q(x.getId().getId()));
            w.write(")),\n");
        }
        w.write("};\n");
        w.write("}\n");
    }

    public static interface Options {
        public static final String NAMESPACE = ZooKeeper.class.getName();
        public static final String ZROOT = "zroot";
        public static final String SESSION_TIMEOUT = "sessionTimeout";
        public static final int DEFAULT_SESSION_TIMEOUT = 5000;
        public static final String SERVERS = "servers";
        public static final String ACL = "acl";
    }
}

