/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.io.FileLockUtility;
import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.config.JavaServiceConfiguration;
import com.bigdata.jini.start.config.ServiceConfiguration;
import com.bigdata.jini.start.config.ZookeeperServerEntry;
import com.bigdata.jini.start.process.ProcessHelper;
import com.bigdata.jini.start.process.ZookeeperProcessHelper;
import com.bigdata.util.config.NicUtil;
import com.bigdata.zookeeper.ZooHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.NoSuchEntryException;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

public class ZookeeperServerConfiguration
extends JavaServiceConfiguration {
    private static final long serialVersionUID = 7786331380952066582L;
    public final String servers;
    public final int clientPort;
    public final File dataDir;
    public final File dataLogDir;
    public final String configFile;
    public final Map<String, String> other;
    private final InetAddress thisInetAddr;

    private void putIfDefined(Configuration config, String k, Class cls) throws ConfigurationException {
        try {
            Object v = config.getEntry(Options.NAMESPACE, k, cls);
            this.other.put(k, v.toString());
        }
        catch (NoSuchEntryException ex) {
            // empty catch block
        }
    }

    @Override
    protected long getDefaultTimeout() {
        return 4000L;
    }

    public ZookeeperServerConfiguration(Configuration config) throws ConfigurationException {
        super(QuorumPeerMain.class.getName(), config);
        this.servers = (String)config.getEntry(Options.NAMESPACE, "servers", String.class);
        this.getZookeeperServerEntries();
        if (log.isInfoEnabled()) {
            log.info((Object)("servers=" + this.servers));
        }
        this.clientPort = (Integer)config.getEntry(Options.NAMESPACE, "clientPort", Integer.TYPE);
        if (log.isInfoEnabled()) {
            log.info((Object)("clientPort=" + this.clientPort));
        }
        this.dataDir = (File)config.getEntry(Options.NAMESPACE, "dataDir", File.class, (Object)new File(this.serviceDir, "zookeeper"));
        if (log.isInfoEnabled()) {
            log.info((Object)("dataDir=" + this.dataDir));
        }
        this.dataLogDir = (File)config.getEntry(Options.NAMESPACE, "dataLogDir", File.class, (Object)this.dataDir);
        if (log.isInfoEnabled()) {
            log.info((Object)("dataLogDir=" + this.dataLogDir));
        }
        this.configFile = (String)config.getEntry(Options.NAMESPACE, "configFile", String.class, (Object)"zoo.config");
        if (log.isInfoEnabled()) {
            log.info((Object)("configFile=" + this.configFile));
        }
        this.other = new LinkedHashMap<String, String>();
        this.putIfDefined(config, "tickTime", Integer.TYPE);
        this.putIfDefined(config, "globalOutstandingLimit", Integer.TYPE);
        this.putIfDefined(config, "preAllocSize", Long.TYPE);
        this.putIfDefined(config, "snapCount", Integer.TYPE);
        this.putIfDefined(config, "traceFile", String.class);
        this.putIfDefined(config, "electionAlg", Integer.TYPE);
        this.putIfDefined(config, "leaderServes", Boolean.TYPE);
        this.putIfDefined(config, "syncLimit", Integer.TYPE);
        this.putIfDefined(config, "forceSync", Boolean.TYPE);
        this.putIfDefined(config, "skipACL", Boolean.TYPE);
        try {
            this.thisInetAddr = InetAddress.getByName(NicUtil.getIpAddress("default.nic", "default", false));
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("zookeeper host=" + this.thisInetAddr.getCanonicalHostName()));
        }
    }

    public ZookeeperServerEntry[] getZookeeperServerEntries() throws ConfigurationException {
        return ZookeeperServerConfiguration.getZookeeperServerEntries(this.servers);
    }

    public static ZookeeperServerEntry[] getZookeeperServerEntries(String servers) throws ConfigurationException {
        String[] fields;
        LinkedList<ZookeeperServerEntry> serverEntries = new LinkedList<ZookeeperServerEntry>();
        for (String field : fields = servers.split("\\s*,\\s*")) {
            if (field.length() == 0) continue;
            int pos = field.indexOf(61);
            if (pos == -1) {
                throw new ConfigurationException("Expecting '=' : " + servers);
            }
            String idField = field.substring(0, pos);
            String entryFields = field.substring(pos + 1);
            int id = Integer.parseInt(idField);
            ZookeeperServerEntry entry = new ZookeeperServerEntry(id, entryFields);
            serverEntries.add(entry);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)entry.toString());
        }
        return serverEntries.toArray(new ZookeeperServerEntry[0]);
    }

    public ZookeeperServiceStarter newServiceStarter(IServiceListener listener, ZookeeperServerEntry entry) {
        return new ZookeeperServiceStarter(listener, entry);
    }

    @Override
    public JavaServiceConfiguration.JavaServiceStarter newServiceStarter(IServiceListener listener) {
        throw new UnsupportedOperationException();
    }

    public static class ZookeeperRunningException
    extends IOException {
        private static final long serialVersionUID = -3789944484005426184L;

        public ZookeeperRunningException(String msg) {
            super(msg);
        }
    }

    public class ZookeeperServiceStarter<V extends ZookeeperProcessHelper>
    extends JavaServiceConfiguration.JavaServiceStarter<V> {
        protected final ZookeeperServerEntry entry;
        final File dataDir;
        final File dataLogDir;
        final File configFile;
        final File myidFile;

        @Override
        protected File getServiceDir() {
            return this.dataDir;
        }

        protected ZookeeperServiceStarter(IServiceListener listener, ZookeeperServerEntry entry) {
            super(listener);
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            this.entry = entry;
            this.dataDir = new File(ZookeeperServerConfiguration.this.dataDir, Integer.toString(entry.id)).getAbsoluteFile();
            if (ServiceConfiguration.log.isInfoEnabled()) {
                ServiceConfiguration.log.info((Object)("dataDir=" + this.dataDir));
            }
            this.dataLogDir = new File(ZookeeperServerConfiguration.this.dataLogDir, Integer.toString(entry.id)).getAbsoluteFile();
            if (ServiceConfiguration.log.isInfoEnabled()) {
                ServiceConfiguration.log.info((Object)("dataLogDir=" + this.dataLogDir));
            }
            this.configFile = new File(this.dataDir, ZookeeperServerConfiguration.this.configFile).getAbsoluteFile();
            this.myidFile = new File(this.dataDir, "myid");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() throws Exception {
            if (ZooHelper.isRunning(ZookeeperServerConfiguration.this.thisInetAddr, ZookeeperServerConfiguration.this.clientPort)) {
                ZooHelper.ruok(ZookeeperServerConfiguration.this.thisInetAddr, ZookeeperServerConfiguration.this.clientPort);
                throw new ZookeeperRunningException("Zookeeper already running on localhost: clientport=" + ZookeeperServerConfiguration.this.clientPort);
            }
            if (!this.dataDir.exists()) {
                this.dataDir.mkdirs();
            }
            if (!this.dataLogDir.exists()) {
                this.dataLogDir.mkdirs();
            }
            RandomAccessFile raf = FileLockUtility.openFile(this.myidFile, "rw", true);
            try {
                if (raf.length() == 0L) {
                    raf.writeBytes(Integer.toString(this.entry.id));
                    this.writeZookeeperConfigFile();
                    ZookeeperProcessHelper zookeeperProcessHelper = (ZookeeperProcessHelper)super.call();
                    return (V)zookeeperProcessHelper;
                }
                try {
                    ZooHelper.ruok(ZookeeperServerConfiguration.this.thisInetAddr, ZookeeperServerConfiguration.this.clientPort);
                    throw new ZookeeperRunningException("Zookeeper already running on localhost: clientport=" + ZookeeperServerConfiguration.this.clientPort);
                }
                catch (IOException ex) {
                    ZookeeperProcessHelper zookeeperProcessHelper = (ZookeeperProcessHelper)super.call();
                    return (V)zookeeperProcessHelper;
                }
            }
            finally {
                FileLockUtility.closeFile(this.myidFile, raf);
            }
        }

        @Override
        protected void addCommandArgs(List<String> cmds) {
            super.addCommandArgs(cmds);
            cmds.add(this.configFile.toString());
        }

        @Override
        protected V newProcessHelper(String className, ProcessBuilder processBuilder, IServiceListener listener) throws IOException {
            return (V)new ZookeeperProcessHelper(className, processBuilder, listener, ZookeeperServerConfiguration.this.clientPort);
        }

        @Override
        protected void awaitServiceStart(V processHelper, long timeout, TimeUnit unit) throws Exception {
            long begin = System.nanoTime();
            long nanos = unit.toNanos(timeout);
            try {
                int exitValue = ((ProcessHelper)processHelper).exitValue(nanos, TimeUnit.NANOSECONDS);
                throw new IOException("exitValue=" + exitValue);
            }
            catch (TimeoutException ex) {
                ZooHelper.ruok(ZookeeperServerConfiguration.this.thisInetAddr, ZookeeperServerConfiguration.this.clientPort);
                long elapsed = System.nanoTime() - begin;
                ServiceConfiguration.log.warn((Object)("Started zookeeper: elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsed)));
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void writeZookeeperConfigFile() throws ConfigurationException, IOException {
            Properties properties = new Properties();
            for (Map.Entry<String, String> entry : ZookeeperServerConfiguration.this.other.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
            properties.setProperty("dataDir", this.dataDir.toString());
            properties.setProperty("dataLogDir", this.dataLogDir.toString());
            properties.setProperty("clientPort", Integer.toString(ZookeeperServerConfiguration.this.clientPort));
            StringWriter out = new StringWriter();
            properties.store(out, "Zookeeper Configuration");
            String contents = out.toString();
            if (ServiceConfiguration.log.isInfoEnabled()) {
                ServiceConfiguration.log.info((Object)("configFile=" + this.configFile + "\n" + contents));
            }
            try (OutputStreamWriter out2 = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(this.configFile)));){
                out2.write(contents);
                ((Writer)out2).flush();
            }
        }
    }

    public static interface Options
    extends ServiceConfiguration.Options {
        public static final String NAMESPACE = QuorumPeerMain.class.getName();
        public static final String CONFIG_FILE = "configFile";
        public static final String DEFAULT_CONFIG_FILE = "zoo.config";
        public static final String SERVERS = "servers";
        public static final String CLIENT_PORT = "clientPort";
        public static final String TICK_TIME = "tickTime";
        public static final String DATA_DIR = "dataDir";
        public static final String DATA_LOG_DIR = "dataLogDir";
        public static final String GLOBAL_OUTSTANDING_LIMIT = "globalOutstandingLimit";
        public static final String PRE_ALLOC_SIZE = "preAllocSize";
        public static final String SNAP_COUNT = "snapCount";
        public static final String TRACE_FILE = "traceFile";
        public static final String ELECTION_ALG = "electionAlg";
        public static final String INIT_LIMIT = "initLimit";
        public static final String LEADER_SERVES = "leaderServes";
        public static final String SYNC_LIMIT = "syncLimit";
        public static final String FORCE_SYNC = "forceSync";
        public static final String SKIP_ACL = "skipACL";
    }
}

