/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.config;

import com.bigdata.util.config.NicUtil;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ZookeeperServerEntry {
    protected static final Logger log = Logger.getLogger(ZookeeperServerEntry.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    public final int id;
    public final String hostname;
    public final int peerPort;
    public final int leaderPort;

    public ZookeeperServerEntry(int id, String val) {
        if (id < 0) {
            throw new IllegalArgumentException();
        }
        if (val == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        int c1 = val.indexOf(":");
        int c2 = val.lastIndexOf(":");
        if (c1 == -1 || c2 == -1) {
            throw new IllegalArgumentException();
        }
        this.hostname = val.substring(0, c1);
        String peerPort = val.substring(c1 + 1, c2);
        this.peerPort = Integer.parseInt(peerPort);
        String leaderPort = val.substring(c2 + 1);
        this.leaderPort = Integer.parseInt(leaderPort);
    }

    public String getValue() {
        return this.hostname + ":" + this.peerPort + ":" + this.leaderPort;
    }

    public String toString() {
        return this.id + "=" + this.getValue();
    }

    public boolean isLocalHost() throws SocketException, UnknownHostException {
        Object[] localAddrs = NicUtil.getInetAddressMap().keySet().toArray(new InetAddress[1]);
        Object[] hostAddrs = InetAddress.getAllByName(this.hostname);
        if (INFO) {
            log.info((Object)("Considering: " + this.hostname + " : localAddrs=" + Arrays.toString(localAddrs) + ", hostAddrs=" + Arrays.toString(hostAddrs)));
        }
        for (InetAddress inetAddress : hostAddrs) {
            if (inetAddress.isLoopbackAddress()) {
                return true;
            }
            for (Object localAddr : localAddrs) {
                if (!inetAddress.equals(localAddr)) continue;
                return true;
            }
        }
        return false;
    }
}

