/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.process;

import com.bigdata.jini.start.IServiceListener;
import com.bigdata.jini.start.process.ProcessHelper;
import com.bigdata.service.jini.RemoteDestroyAdmin;
import com.sun.jini.admin.DestroyAdmin;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import net.jini.core.lookup.ServiceItem;

public class JiniServiceProcessHelper
extends ProcessHelper {
    private ServiceItem serviceItem = null;

    public JiniServiceProcessHelper(String name, ProcessBuilder builder, IServiceListener listener) throws IOException {
        super(name, builder, listener);
    }

    public synchronized void setServiceItem(ServiceItem serviceItem) {
        if (serviceItem == null) {
            throw new IllegalArgumentException();
        }
        if (this.serviceItem != null) {
            throw new IllegalStateException();
        }
        this.serviceItem = serviceItem;
    }

    @Override
    public int kill(boolean immediateShutdown) throws InterruptedException {
        Object admin;
        Method getAdmin;
        if (this.serviceItem == null) {
            return super.kill(immediateShutdown);
        }
        Remote proxy = (Remote)this.serviceItem.service;
        try {
            getAdmin = proxy.getClass().getMethod("getAdmin", new Class[0]);
        }
        catch (Throwable t) {
            log.warn((Object)this, t);
            return super.kill(immediateShutdown);
        }
        try {
            admin = getAdmin.invoke((Object)proxy, new Object[0]);
        }
        catch (Throwable t) {
            log.warn((Object)this, t);
            return super.kill(immediateShutdown);
        }
        if (admin instanceof RemoteDestroyAdmin) {
            try {
                if (immediateShutdown) {
                    log.warn((Object)("will shutdownNow() service: " + this));
                    ((RemoteDestroyAdmin)admin).shutdownNow();
                }
                log.warn((Object)("will shutdown() service: " + this));
                ((RemoteDestroyAdmin)admin).shutdown();
            }
            catch (NoSuchObjectException ex) {
                log.warn((Object)("Process already gone? name=" + this.name + " : " + ex));
                return super.kill(immediateShutdown);
            }
            catch (Throwable t) {
                log.warn((Object)this, t);
                return super.kill(immediateShutdown);
            }
        } else if (admin instanceof DestroyAdmin) {
            try {
                log.warn((Object)("will destroy() service: " + this));
                ((DestroyAdmin)admin).destroy();
            }
            catch (NoSuchObjectException ex) {
                log.warn((Object)("Process already gone? name=" + this.name + " : " + ex));
                return super.kill(immediateShutdown);
            }
            catch (Throwable t) {
                log.error((Object)this, t);
                return super.kill(immediateShutdown);
            }
        }
        int exitValue = this.exitValue();
        this.listener.remove(this);
        return exitValue;
    }
}

