/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.jini.start.process;

import com.bigdata.BigdataStatics;
import com.bigdata.jini.start.IServiceListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.system.SystemUtil;

public class ProcessHelper {
    protected static final Logger log = Logger.getLogger(ProcessHelper.class);
    public final String name;
    final IServiceListener listener;
    private final Process process;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition dead = this.lock.newCondition();
    private final AtomicInteger exitValue = new AtomicInteger(-1);

    public String toString() {
        int exitValue = this.exitValue.get();
        return this.getClass().getSimpleName() + "{name=" + this.name + (exitValue != -1 ? ", exitValue=" + exitValue : "") + "}";
    }

    public int exitValue() throws InterruptedException {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Waiting on exitValue: " + this));
            }
            int exitValue = this.exitValue(Long.MAX_VALUE, TimeUnit.SECONDS);
            String msg = "Process is dead: " + this + ", exitValue=" + exitValue;
            if (exitValue != 0) {
                log.error((Object)msg, (Throwable)new RuntimeException(msg));
            } else {
                log.warn((Object)msg);
            }
            return exitValue;
        }
        catch (TimeoutException ex) {
            throw new AssertionError();
        }
    }

    public int exitValue(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        long begin = System.nanoTime();
        long nanos = unit.toNanos(timeout);
        this.lock.lock();
        try {
            while (true) {
                int exitValue;
                if ((exitValue = this.exitValue.get()) != -1) {
                    int n = exitValue;
                    return n;
                }
                long remaining = nanos - (System.nanoTime() - begin);
                if (remaining <= 0L) {
                    throw new TimeoutException();
                }
                this.dead.await(remaining, TimeUnit.NANOSECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int kill(boolean immediateShutdown) throws InterruptedException {
        log.warn((Object)this);
        try {
            this.process.destroy();
        }
        catch (Throwable t) {
            log.warn((Object)this, t);
        }
        int exitValue = this.exitValue();
        this.listener.remove(this);
        return exitValue;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public ProcessHelper(final String name, ProcessBuilder processBuilder, final IServiceListener listener) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (processBuilder == null) {
            throw new IllegalArgumentException();
        }
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.listener = listener;
        log.warn((Object)("command: " + processBuilder.command()));
        processBuilder.redirectErrorStream(true);
        this.process = processBuilder.start();
        listener.add(this);
        Thread thread = new Thread("consumeOutput: " + name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ProcessHelper.this.consumeOutput();
                }
                finally {
                    ProcessHelper.this.lock.lock();
                    try {
                        ProcessHelper.this.process.destroy();
                        ProcessHelper.this.exitValue.set(ProcessHelper.this.process.waitFor());
                        ProcessHelper.this.dead.signalAll();
                        listener.remove(ProcessHelper.this);
                        log.warn((Object)("Process destroyed: " + name));
                    }
                    catch (InterruptedException ex) {
                        log.warn((Object)("Interrupted awaiting process death: " + this));
                    }
                    finally {
                        ProcessHelper.this.lock.unlock();
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        log.warn((Object)("Process starting: name=" + name));
        if (log.isInfoEnabled()) {
            log.info((Object)("cmd=" + ProcessHelper.getCommandString(processBuilder)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("env=" + processBuilder.environment()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeOutput() {
        long nlines = 0L;
        BufferedReader is = null;
        try {
            String s;
            is = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            boolean truncated = false;
            while ((s = is.readLine()) != null) {
                if (nlines++ < (long)BigdataStatics.echoProcessStartupLineCount) {
                    System.out.println(this.name + " : " + s);
                } else if (!truncated) {
                    System.out.println(this.name + " : output truncated after " + BigdataStatics.echoProcessStartupLineCount + " lines");
                    truncated = true;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)s);
            }
        }
        catch (IOException ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex2) {
                    log.error((Object)ex2, (Throwable)ex2);
                }
            }
        }
    }

    public Future interruptWhenProcessDies(long timeout, TimeUnit unit) {
        final long nanos = unit.toNanos(timeout);
        final Thread callersThread = Thread.currentThread();
        final Condition done = this.lock.newCondition();
        final Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProcessHelper.this.lock.lock();
                try {
                    if (ProcessHelper.this.dead.await(nanos, TimeUnit.NANOSECONDS)) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Process is dead: name=" + ProcessHelper.this.name + ", exitValue=" + ProcessHelper.this.exitValue));
                        }
                        callersThread.interrupt();
                        return;
                    }
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
                finally {
                    done.signalAll();
                    ProcessHelper.this.lock.unlock();
                }
            }
        };
        t.setDaemon(true);
        t.start();
        return new Future(){
            private volatile boolean cancelled = false;

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (t.isAlive() && mayInterruptIfRunning) {
                    t.interrupt();
                    return true;
                }
                this.cancelled = true;
                return false;
            }

            public Object get() throws InterruptedException, ExecutionException {
                try {
                    return this.get(Long.MAX_VALUE, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    throw new AssertionError();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                ProcessHelper.this.lock.lock();
                try {
                    if (t.isAlive()) {
                        done.await(timeout, unit);
                    }
                }
                finally {
                    ProcessHelper.this.lock.unlock();
                }
                return null;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled;
            }

            @Override
            public boolean isDone() {
                return !t.isAlive();
            }
        };
    }

    public static String getEnvironment(ProcessBuilder processBuilder) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : processBuilder.environment().entrySet()) {
            if (!SystemUtil.isWindows()) {
                sb.append("export ");
            } else {
                sb.append("set ");
            }
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String getCommandString(ProcessBuilder processBuilder) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : processBuilder.command()) {
            if (!first) {
                sb.append(' ');
            }
            sb.append("\"");
            sb.append(ProcessHelper.escape(s));
            sb.append("\"");
            first = false;
        }
        return sb.toString();
    }

    private static String escape(String s) {
        if (SystemUtil.isWindows()) {
            s = s.replaceAll("%", "%%");
        }
        return s;
    }
}

