/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.bfs.GlobalFileSystemHelper;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IDirtyListener;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.view.FusedView;
import com.bigdata.counters.CounterSet;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.htree.AbstractHTree;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.AbstractLocalTransactionManager;
import com.bigdata.journal.ConcurrencyManager;
import com.bigdata.journal.IBufferStrategy;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.ICommitter;
import com.bigdata.journal.IConcurrencyManager;
import com.bigdata.journal.IDistributedTransactionService;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.ILocalTransactionManager;
import com.bigdata.journal.IResourceLockService;
import com.bigdata.journal.IResourceManager;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.ITask;
import com.bigdata.journal.IndexExistsException;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Name2Addr;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.journal.TemporaryStoreFactory;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.journal.Tx;
import com.bigdata.journal.WriteExecutorService;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.quorum.AsynchronousQuorumCloseException;
import com.bigdata.quorum.Quorum;
import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.relation.locator.IResourceLocator;
import com.bigdata.resources.NoSuchStoreException;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.StaleLocatorException;
import com.bigdata.resources.StaleLocatorReason;
import com.bigdata.resources.StoreManager;
import com.bigdata.rwstore.IRWStrategy;
import com.bigdata.rwstore.IRawTx;
import com.bigdata.sparse.GlobalRowStoreHelper;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.util.concurrent.TaskCounters;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public abstract class AbstractTask<T>
implements Callable<T>,
ITask<T> {
    protected static final Logger log = Logger.getLogger(AbstractTask.class);
    private final AtomicBoolean submitted = new AtomicBoolean(false);
    protected final ConcurrencyManager concurrencyManager;
    protected final AbstractLocalTransactionManager transactionManager;
    protected final IResourceManager resourceManager;
    private static final boolean verifyLocks = false;
    private IJournal journal;
    protected final long timestamp;
    long commitTime = 0L;
    protected final boolean isReadWriteTx;
    protected final boolean readOnly;
    private final String[] resource;
    protected final Tx tx;
    private final Map<String, ILocalBTreeView> indexCache;
    private Map<String, Entry> n2a;
    private ConcurrentHashMap<String, DirtyListener> commitList;
    volatile boolean aborted = false;
    protected TaskCounters taskCounters;
    public long nanoTime_submitTask;
    public long nanoTime_assignedWorker;
    public long nanoTime_beginWork;
    public long nanoTime_finishedWork;
    public long checkpointNanoTime;

    @Override
    public final IResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public final synchronized IJournal getJournal() {
        if (this.journal == null) {
            this.journal = this.resourceManager.getJournal(this.timestamp);
            if (this.journal == null) {
                log.warn((Object)("No such journal: timestamp=" + this.timestamp));
                return null;
            }
            if (this.timestamp == 0L) {
                this.journal = new IsolatedActionJournal((AbstractJournal)this.journal);
            } else if (this.readOnly) {
                this.journal = new ReadOnlyJournal((AbstractJournal)this.journal);
            }
        }
        return this.journal;
    }

    public long getCommitTime() {
        return this.commitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupIndices() {
        if (this.n2a != null) {
            throw new IllegalStateException();
        }
        this.n2a = new HashMap<String, Entry>(this.resource.length);
        this.commitList = new ConcurrentHashMap(this.resource.length);
        Name2Addr name2Addr = this.resourceManager.getLiveJournal()._getName2Addr();
        if (name2Addr == null) {
            throw new AssertionError((Object)("Name2Addr not loaded? : " + this.resourceManager.getLiveJournal()));
        }
        Name2Addr name2Addr2 = name2Addr;
        synchronized (name2Addr2) {
            for (String s : this.resource) {
                Name2Addr.Entry tmp = name2Addr.getEntry(s);
                if (tmp != null) {
                    this.n2a.put(s, new Entry(tmp));
                    continue;
                }
                Iterator<String> itr = Name2Addr.indexNameScan(s, name2Addr);
                while (itr.hasNext()) {
                    String t = itr.next();
                    Name2Addr.Entry tmp2 = name2Addr.getEntry(t);
                    this.n2a.put(t, new Entry(tmp2));
                }
            }
        }
    }

    private void clearIndexCache() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Clearing hard reference cache: " + this.indexCache.size() + " indices accessed"));
        }
        this.indexCache.clear();
        if (this.commitList != null) {
            this.commitList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized ILocalBTreeView getIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.assertResource(name);
        this.assertRunning();
        ILocalBTreeView index = this.indexCache.get(name);
        if (index != null) {
            return index;
        }
        if (this.timestamp == 0L) {
            ICheckpointProtocol ndx;
            Name2Addr name2Addr;
            StaleLocatorReason reason = this.resourceManager.getIndexPartitionGone(name);
            if (reason != null) {
                throw new StaleLocatorException(name, reason);
            }
            Entry entry = this.n2a.get(name);
            if (entry == null) {
                throw new NoSuchIndexException(name);
            }
            long checkpointAddr = entry.checkpointAddr;
            Name2Addr name2Addr2 = name2Addr = this.resourceManager.getLiveJournal()._getName2Addr();
            synchronized (name2Addr2) {
                if (this.resourceManager.getLiveJournal().getBufferStrategy() instanceof IRWStrategy) {
                    ndx = null;
                    ICheckpointProtocol tmp_ndx = name2Addr.getIndexCache(name);
                    if (tmp_ndx != null) {
                        checkpointAddr = tmp_ndx.getCheckpoint().getCheckpointAddr();
                    }
                } else {
                    ndx = name2Addr.getIndexCache(name);
                }
                if (ndx == null) {
                    IJournal tmp = this.getJournal();
                    ndx = Checkpoint.loadFromCheckpoint(tmp, checkpointAddr, false);
                    ndx.setLastCommitTime(entry.commitTime);
                    name2Addr.putIndexCache(name, ndx, false);
                    if (ndx instanceof AbstractBTree) {
                        ((AbstractBTree)ndx).setBTreeCounters(this.resourceManager.getIndexCounters(name));
                    } else if (ndx instanceof AbstractHTree) {
                        ((AbstractHTree)ndx).setBTreeCounters(this.resourceManager.getIndexCounters(name));
                    }
                }
            }
            try {
                return this.getUnisolatedIndexView(name, (BTree)ndx);
            }
            catch (NoSuchStoreException ex) {
                throw new NoSuchStoreException(entry.toString() + ":" + ex.getMessage(), ex);
            }
        }
        ILocalBTreeView tmp = this.resourceManager.getIndex(name, this.timestamp);
        if (tmp == null) {
            throw new NoSuchIndexException(name + ", timestamp=" + this.timestamp);
        }
        this.indexCache.put(name, tmp);
        return tmp;
    }

    private ILocalBTreeView getUnisolatedIndexView(String name, BTree btree) {
        btree.setDirtyListener(new DirtyListener(name, btree));
        AbstractBTree[] sources = this.resourceManager.getIndexSources(name, 0L, btree);
        assert (!sources[0].isReadOnly());
        ILocalBTreeView view = sources.length == 1 ? (BTree)sources[0] : new FusedView(sources);
        this.indexCache.put(name, view);
        return view;
    }

    public synchronized IIndex registerIndex(String name, BTree btree) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (btree == null) {
            throw new IllegalArgumentException();
        }
        this.assertUnisolated();
        this.assertResource(name);
        this.assertRunning();
        if (this.n2a.containsKey(name)) {
            Entry entry = this.n2a.get(name);
            if (!entry.droppedIndex) {
                throw new IndexExistsException(name);
            }
        }
        long checkpointAddr = btree.writeCheckpoint();
        Entry entry = new Entry(name, checkpointAddr, 0L);
        this.n2a.put(name, entry);
        btree.setBTreeCounters(this.resourceManager.getIndexCounters(name));
        ILocalBTreeView view = this.getUnisolatedIndexView(name, btree);
        if (view instanceof AbstractBTree ? !$assertionsDisabled && btree != view : !$assertionsDisabled && btree != ((FusedView)view).getSources()[0]) {
            throw new AssertionError();
        }
        ((DirtyListener)btree.getDirtyListener()).dirtyEvent(btree);
        return view;
    }

    public synchronized void dropIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.assertUnisolated();
        this.assertResource(name);
        this.assertRunning();
        if (!this.n2a.containsKey(name)) {
            throw new NoSuchIndexException(name);
        }
        Entry entry = this.n2a.get(name);
        if (entry.droppedIndex) {
            throw new NoSuchIndexException(name);
        }
        entry.droppedIndex = true;
        this.indexCache.remove(name);
        this.commitList.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkpointTask() {
        Name2Addr name2Addr;
        List futures;
        this.assertUnisolated();
        this.assertRunning();
        int ndirty = this.commitList.size();
        long begin = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info((Object)("There are " + ndirty + " dirty indices " + this.commitList.keySet() + " : " + this));
        }
        LinkedList<CheckpointIndexTask> tasks = new LinkedList<CheckpointIndexTask>();
        for (DirtyListener l : this.commitList.values()) {
            assert (this.indexCache.containsKey(l.name)) : "Index not in cache? name=" + DirtyListener.access$100(l);
            tasks.add(new CheckpointIndexTask(l));
        }
        try {
            ExecutorService executorService = this.resourceManager.getLiveJournal().getExecutorService();
            futures = executorService.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        if (log.isInfoEnabled()) {
            long elapsed = System.nanoTime() - begin;
            log.info((Object)("Flushed " + ndirty + " indices in " + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms"));
        }
        Name2Addr name2Addr2 = name2Addr = this.resourceManager.getLiveJournal()._getName2Addr();
        synchronized (name2Addr2) {
            for (Entry entry : this.n2a.values()) {
                if (entry.droppedIndex) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Dropping index on Name2Addr: " + entry.name));
                    }
                    name2Addr.dropIndex(entry.name);
                    continue;
                }
                if (entry.registeredIndex) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Registering index on Name2Addr: " + entry.name));
                    }
                    name2Addr.registerIndex(entry.name, (BTree)this.commitList.get(entry.name).ndx);
                    continue;
                }
                DirtyListener l = this.commitList.get(entry.name);
                if (l == null) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Transferring to Name2Addr commitList: " + entry.name));
                }
                name2Addr.putOnCommitList(l.name, l.ndx, false);
            }
        }
        this.n2a.clear();
        this.commitList.clear();
        ((IsolatedActionJournal)this.getJournal()).prepareCommit();
        long l = System.nanoTime() - begin;
        if (log.isInfoEnabled()) {
            log.info((Object)("End task checkpoint after " + TimeUnit.NANOSECONDS.toMillis(l) + "ms"));
        }
        return l;
    }

    private void abortTask() {
        ((IsolatedActionJournal)this.getJournal()).abortContext();
    }

    void afterTaskHook(boolean abort) {
        ((IsolatedActionJournal)this.getJournal()).completeTask();
    }

    @Override
    public TaskCounters getTaskCounters() {
        return this.taskCounters;
    }

    protected AbstractTask(IConcurrencyManager concurrencyManager, long timestamp, String resource) {
        this(concurrencyManager, timestamp, new String[]{resource});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractTask(IConcurrencyManager concurrencyManager, long timestamp, String[] resource) {
        if (concurrencyManager == null) {
            throw new NullPointerException();
        }
        if (resource == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < resource.length; ++i) {
            if (resource[i] != null) continue;
            throw new NullPointerException();
        }
        this.concurrencyManager = (ConcurrencyManager)(concurrencyManager instanceof Journal ? ((Journal)concurrencyManager).getConcurrencyManager() : concurrencyManager);
        this.transactionManager = (AbstractLocalTransactionManager)concurrencyManager.getTransactionManager();
        this.resourceManager = concurrencyManager.getResourceManager();
        this.timestamp = timestamp;
        this.resource = resource;
        this.indexCache = new HashMap<String, ILocalBTreeView>(resource.length);
        this.isReadWriteTx = TimestampUtility.isReadWriteTx(timestamp);
        this.readOnly = TimestampUtility.isReadOnly(timestamp);
        if (this.isReadWriteTx) {
            if (this.resourceManager instanceof ResourceManager) {
                UUID dataServiceUUID = ((ResourceManager)this.resourceManager).getDataServiceUUID();
                try {
                    IDistributedTransactionService txs = (IDistributedTransactionService)this.transactionManager.getTransactionService();
                    txs.declareResources(timestamp, dataServiceUUID, resource);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (this.transactionManager.getTx(timestamp) == null) {
                    new Tx(this.transactionManager, this.resourceManager, timestamp, timestamp);
                }
            }
            this.tx = this.transactionManager.getTx(timestamp);
            if (this.tx == null) {
                throw new IllegalStateException("Unknown tx: " + timestamp);
            }
            this.tx.lock.lock();
            try {
                if (!this.tx.isActive()) {
                    throw new IllegalStateException("Not active: " + this.tx);
                }
            }
            finally {
                this.tx.lock.unlock();
            }
            this.taskCounters = this.concurrencyManager.countersTX;
        } else if (TimestampUtility.isReadOnly(timestamp)) {
            this.tx = null;
            this.taskCounters = this.concurrencyManager.countersHR;
        } else {
            this.tx = null;
            this.taskCounters = this.concurrencyManager.countersUN;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String[] getResource() {
        return (String[])this.resource.clone();
    }

    @Override
    public String getOnlyResource() {
        if (this.resource.length > 1) {
            throw new IllegalStateException("More than one resource was declared");
        }
        return this.resource[0];
    }

    public boolean isResource(String theRequestedResource) {
        if (theRequestedResource == null) {
            throw new IllegalArgumentException();
        }
        for (String theDeclaredResource : this.resource) {
            if (theDeclaredResource.equals(theRequestedResource)) {
                return true;
            }
            if (!theRequestedResource.startsWith(theDeclaredResource) || theRequestedResource.charAt(theDeclaredResource.length()) != '.') continue;
            return true;
        }
        return false;
    }

    protected String assertResource(String resource) {
        if (this.isResource(resource)) {
            return resource;
        }
        throw new IllegalStateException("Not declared: task=" + this.getTaskName() + ", resource=" + resource + " is not in " + Arrays.toString(this.resource));
    }

    protected void assertUnisolated() {
        if (this.timestamp == 0L) {
            return;
        }
        throw new UnsupportedOperationException("Task is not unisolated");
    }

    protected void assertRunning() {
        if (this.aborted) {
            throw new RuntimeException(new InterruptedException());
        }
    }

    @Override
    public String toString() {
        return "Task{" + this.getTaskName() + ",timestamp=" + TimestampUtility.toString(this.timestamp) + ",resource=" + Arrays.toString(this.resource) + "}";
    }

    protected String getTaskName() {
        return this.getClass().getName();
    }

    protected abstract T doTask() throws Exception;

    protected void setupLoggingContext() {
        MDC.put((String)"taskname", (Object)this.getTaskName());
        MDC.put((String)"timestamp", (Object)this.timestamp);
        if (log.isInfoEnabled()) {
            MDC.put((String)"resources", (Object)Arrays.toString(this.resource));
        }
    }

    protected void clearLoggingContext() {
        MDC.remove((String)"taskname");
        MDC.remove((String)"timestamp");
        if (log.isInfoEnabled()) {
            MDC.remove((String)"resources");
        }
    }

    @Override
    public final T call() throws Exception {
        try {
            long waitingTime = System.nanoTime() - this.nanoTime_submitTask;
            this.taskCounters.queueWaitingNanoTime.addAndGet(waitingTime);
            this.setupLoggingContext();
            T ret = this.call2();
            this.clearLoggingContext();
            this.taskCounters.taskSuccessCount.incrementAndGet();
            T t = ret;
            return t;
        }
        catch (Exception e) {
            this.taskCounters.taskFailCount.incrementAndGet();
            throw e;
        }
        finally {
            this.taskCounters.taskCompleteCount.incrementAndGet();
            this.taskCounters.serviceNanoTime.addAndGet(this.nanoTime_finishedWork - this.nanoTime_beginWork);
            if (this.checkpointNanoTime != 0L) {
                this.taskCounters.checkpointNanoTime.addAndGet(this.checkpointNanoTime);
            }
            if (this.timestamp != 0L) {
                this.taskCounters.queuingNanoTime.addAndGet(this.nanoTime_finishedWork - this.nanoTime_submitTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final T call2() throws Exception {
        this.nanoTime_assignedWorker = System.nanoTime();
        if (!this.submitted.compareAndSet(false, true)) {
            throw new ResubmitException(this.toString());
        }
        if (this.isReadWriteTx) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Running read-write tx: timestamp=" + this.timestamp));
            }
            InnerReadWriteTxServiceCallable delegate = new InnerReadWriteTxServiceCallable(this, this.tx);
            Object v = delegate.call();
            return (T)v;
        }
        if (this.readOnly) {
            this.nanoTime_beginWork = System.nanoTime();
            T t = this.doTask();
            return t;
        }
        assert (this.timestamp == 0L) : "timestamp=" + this.timestamp;
        T t = this.doUnisolatedReadWriteTask();
        return t;
        {
            finally {
                this.nanoTime_finishedWork = System.nanoTime();
                this.clearIndexCache();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Reader is done: " + this));
                }
            }
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info((Object)("done: " + this));
            }
        }
    }

    private T doUnisolatedReadWriteTask() throws Exception {
        Thread t = Thread.currentThread();
        if (log.isInfoEnabled()) {
            log.info((Object)("Unisolated write task: " + this + ", thread=" + t));
        }
        InnerWriteServiceCallable delegate = new InnerWriteServiceCallable(this);
        WriteExecutorService writeService = this.concurrencyManager.getWriteService();
        writeService.beforeTask(t, this);
        boolean ran = false;
        try {
            Object ret = delegate.call();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ran = true;
            if (log.isInfoEnabled()) {
                log.info((Object)("Task Ok: class=" + this));
            }
            writeService.afterTask(this, null);
            Object v = ret;
            return (T)v;
        }
        catch (Throwable t2) {
            if (!ran) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Task failed: class=" + this + " : " + t2));
                }
                writeService.afterTask(this, t2);
            }
            if (t2 instanceof Exception) {
                throw (Exception)t2;
            }
            throw new RuntimeException(t2);
        }
        finally {
            this.clearIndexCache();
        }
    }

    private static class DelegateIndexManager
    implements IIndexManager {
        private final IIndexManager delegate;

        public DelegateIndexManager(IIndexManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void dropIndex(String name) {
            this.delegate.dropIndex(name);
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.delegate.getExecutorService();
        }

        @Override
        public BigdataFileSystem getGlobalFileSystem() {
            return this.delegate.getGlobalFileSystem();
        }

        @Override
        public SparseRowStore getGlobalRowStore() {
            return this.delegate.getGlobalRowStore();
        }

        @Override
        public SparseRowStore getGlobalRowStore(long timestamp) {
            return this.delegate.getGlobalRowStore(timestamp);
        }

        @Override
        public IIndex getIndex(String name, long timestamp) {
            return this.delegate.getIndex(name, timestamp);
        }

        @Override
        public long getLastCommitTime() {
            return this.delegate.getLastCommitTime();
        }

        @Override
        public IResourceLocator<?> getResourceLocator() {
            return this.delegate.getResourceLocator();
        }

        @Override
        public IResourceLockService getResourceLockService() {
            return this.delegate.getResourceLockService();
        }

        @Override
        public void registerIndex(IndexMetadata indexMetadata) {
            this.delegate.registerIndex(indexMetadata);
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        @Override
        public TemporaryStore getTempStore() {
            return this.delegate.getTempStore();
        }

        @Override
        public ScheduledFuture<?> addScheduledTask(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate.addScheduledTask(task, initialDelay, delay, unit);
        }

        @Override
        public boolean getCollectPlatformStatistics() {
            return this.delegate.getCollectPlatformStatistics();
        }

        @Override
        public boolean getCollectQueueStatistics() {
            return this.delegate.getCollectQueueStatistics();
        }

        @Override
        public int getHttpdPort() {
            return this.delegate.getHttpdPort();
        }

        @Override
        public Iterator<String> indexNameScan(String prefix, long timestamp) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CounterSet getCounters() {
            return this.delegate.getCounters();
        }

        @Override
        public boolean isGroupCommit() {
            return this.delegate.isGroupCommit();
        }
    }

    private class ReadOnlyJournal
    implements IJournal {
        private final IJournal delegate;
        private final DefaultResourceLocator resourceLocator;
        private TemporaryStoreFactory tempStoreFactory = new TemporaryStoreFactory();

        public String toString() {
            return this.getClass().getName() + "{task=" + AbstractTask.this + "}";
        }

        public ReadOnlyJournal(AbstractJournal source) {
            if (source == null) {
                throw new IllegalArgumentException();
            }
            this.delegate = source;
            this.resourceLocator = new DefaultResourceLocator(this, source.getResourceLocator());
        }

        @Override
        public IIndex getIndex(String name, long timestamp) {
            if (timestamp == 0L) {
                throw new UnsupportedOperationException();
            }
            if (timestamp == AbstractTask.this.timestamp) {
                try {
                    return AbstractTask.this.getIndex(name);
                }
                catch (NoSuchIndexException ex) {
                    return null;
                }
            }
            return (IIndex)((Object)this.delegate.getIndexLocal(name, timestamp));
        }

        @Override
        public ICheckpointProtocol getIndexLocal(String name, long commitTime) {
            if (AbstractTask.this.timestamp == 0L) {
                throw new UnsupportedOperationException();
            }
            if (AbstractTask.this.timestamp == AbstractTask.this.timestamp) {
                try {
                    return (ICheckpointProtocol)((Object)AbstractTask.this.getIndex(name));
                }
                catch (NoSuchIndexException ex) {
                    return null;
                }
            }
            return this.delegate.getIndexLocal(name, AbstractTask.this.timestamp);
        }

        @Override
        public Iterator<String> indexNameScan(String prefix, long timestamp) {
            if (timestamp == 0L) {
                throw new UnsupportedOperationException();
            }
            return this.delegate.indexNameScan(prefix, timestamp);
        }

        @Override
        public ICheckpointProtocol getUnisolatedIndex(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IIndex getIndex(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void dropIndex(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICheckpointProtocol register(String name, IndexMetadata metadata) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void registerIndex(IndexMetadata indexMetadata) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IIndex registerIndex(String name, BTree btree) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IIndex registerIndex(String name, IndexMetadata indexMetadata) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SparseRowStore getGlobalRowStore() {
            long lastCommitTime = this.delegate.getRootBlockView().getLastCommitTime();
            IIndex ndx = this.delegate.getIndex("__globalRowStore", TimestampUtility.asHistoricalRead(lastCommitTime));
            if (ndx != null) {
                return new SparseRowStore(ndx);
            }
            return null;
        }

        @Override
        public SparseRowStore getGlobalRowStore(long timestamp) {
            if (!TimestampUtility.isReadOnly(timestamp)) {
                throw new IllegalArgumentException("Only read-only views are supported: timestamp=" + TimestampUtility.toString(timestamp));
            }
            IIndex ndx = this.delegate.getIndex("__globalRowStore", timestamp);
            if (ndx != null) {
                return new SparseRowStore(ndx);
            }
            return null;
        }

        @Override
        public BigdataFileSystem getGlobalFileSystem() {
            DelegateIndexManager tmp = new DelegateIndexManager(this){

                @Override
                public IIndex getIndex(String name, long timestampIsIgnored) {
                    long commitTime = ReadOnlyJournal.this.delegate.getRootBlockView().getLastCommitTime();
                    return ReadOnlyJournal.this.delegate.getIndex(name, TimestampUtility.asHistoricalRead(commitTime));
                }
            };
            return new GlobalFileSystemHelper(tmp).getReadCommitted();
        }

        @Override
        public TemporaryStore getTempStore() {
            return this.tempStoreFactory.getTempStore();
        }

        @Override
        public DefaultResourceLocator<?> getResourceLocator() {
            return this.resourceLocator;
        }

        @Override
        public ILocalTransactionManager getLocalTransactionManager() {
            return this.delegate.getLocalTransactionManager();
        }

        @Override
        public IResourceLockService getResourceLockService() {
            return this.delegate.getResourceLockService();
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.delegate.getExecutorService();
        }

        @Override
        public void abort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Quorum<HAGlue, QuorumService<HAGlue>> getQuorum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final long awaitHAReady(long timeout, TimeUnit units) throws InterruptedException, TimeoutException, AsynchronousQuorumCloseException {
            return this.delegate.awaitHAReady(timeout, units);
        }

        @Override
        public long commit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteResources() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCommitter(int index, ICommitter committer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void force(boolean metadata) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long write(ByteBuffer data) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete(long addr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getByteCount(long addr) {
            return this.delegate.getByteCount(addr);
        }

        @Override
        public ICommitRecord getCommitRecord(long timestamp) {
            return this.delegate.getCommitRecord(timestamp);
        }

        @Override
        public CounterSet getCounters() {
            return this.delegate.getCounters();
        }

        @Override
        public File getFile() {
            return this.delegate.getFile();
        }

        @Override
        public long getOffset(long addr) {
            return this.delegate.getOffset(addr);
        }

        @Override
        public long getPhysicalAddress(long addr) {
            return this.delegate.getPhysicalAddress(addr);
        }

        @Override
        public Properties getProperties() {
            return this.delegate.getProperties();
        }

        @Override
        public UUID getUUID() {
            return this.delegate.getUUID();
        }

        @Override
        public IResourceMetadata getResourceMetadata() {
            return this.delegate.getResourceMetadata();
        }

        @Override
        public long getRootAddr(int index) {
            return this.delegate.getRootAddr(index);
        }

        @Override
        public long getLastCommitTime() {
            return this.delegate.getLastCommitTime();
        }

        @Override
        public IRootBlockView getRootBlockView() {
            return this.delegate.getRootBlockView();
        }

        @Override
        public boolean isFullyBuffered() {
            return this.delegate.isFullyBuffered();
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        @Override
        public boolean isStable() {
            return this.delegate.isStable();
        }

        @Override
        public ByteBuffer read(long addr) {
            return this.delegate.read(addr);
        }

        @Override
        public long size() {
            return this.delegate.size();
        }

        @Override
        public long toAddr(int nbytes, long offset) {
            return this.delegate.toAddr(nbytes, offset);
        }

        @Override
        public String toString(long addr) {
            return this.delegate.toString(addr);
        }

        @Override
        public ScheduledFuture<?> addScheduledTask(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate.addScheduledTask(task, initialDelay, delay, unit);
        }

        @Override
        public boolean getCollectPlatformStatistics() {
            return this.delegate.getCollectPlatformStatistics();
        }

        @Override
        public boolean getCollectQueueStatistics() {
            return this.delegate.getCollectQueueStatistics();
        }

        @Override
        public int getHttpdPort() {
            return this.delegate.getHttpdPort();
        }

        @Override
        public IPSOutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream getInputStream(long addr) {
            return this.delegate.getInputStream(addr);
        }

        @Override
        public boolean isDirty() {
            return false;
        }

        @Override
        public boolean isGroupCommit() {
            return this.delegate.isGroupCommit();
        }
    }

    class IsolatedActionJournal
    implements IJournal,
    IAllocationContext {
        private final AbstractJournal delegate;
        private final IResourceLocator resourceLocator;
        private final GlobalRowStoreHelper globalRowStoreHelper;
        private final IRawTx m_rawTx;
        private final TemporaryStoreFactory tempStoreFactory = new TemporaryStoreFactory();

        public String toString() {
            return this.getClass().getName() + "{task=" + AbstractTask.this + "}";
        }

        public void prepareCommit() {
            this.detachContext();
        }

        public void completeTask() {
            if (this.m_rawTx != null) {
                this.m_rawTx.close();
            }
        }

        public IsolatedActionJournal(AbstractJournal source) {
            if (source == null) {
                throw new IllegalArgumentException();
            }
            this.delegate = source;
            this.globalRowStoreHelper = new GlobalRowStoreHelper(this);
            this.resourceLocator = new DefaultResourceLocator(this, source instanceof StoreManager.ManagedJournal ? source.getResourceLocator() : null);
            IBufferStrategy bufferStrategy = source.getBufferStrategy();
            if (bufferStrategy instanceof IRWStrategy) {
                this.m_rawTx = ((IRWStrategy)bufferStrategy).newTx();
                ((IRWStrategy)bufferStrategy).registerContext(this);
            } else {
                this.m_rawTx = null;
            }
        }

        @Override
        public void dropIndex(String name) {
            AbstractTask.this.dropIndex(name);
        }

        @Override
        public IIndex registerIndex(String name, BTree btree) {
            return AbstractTask.this.registerIndex(name, btree);
        }

        @Override
        public ICheckpointProtocol register(String name, IndexMetadata metadata) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void registerIndex(IndexMetadata indexMetadata) {
            this.registerIndex(indexMetadata.getName(), indexMetadata);
        }

        @Override
        public IIndex registerIndex(String name, IndexMetadata indexMetadata) {
            this.delegate.validateIndexMetadata(name, indexMetadata);
            BTree btree = BTree.create(this.delegate, indexMetadata);
            return this.registerIndex(name, btree);
        }

        @Override
        public ICheckpointProtocol getUnisolatedIndex(String name) {
            try {
                return (ICheckpointProtocol)((Object)AbstractTask.this.getIndex(name));
            }
            catch (NoSuchIndexException ex) {
                return null;
            }
        }

        @Override
        public IIndex getIndex(String name) {
            try {
                return AbstractTask.this.getIndex(name);
            }
            catch (NoSuchIndexException ex) {
                return null;
            }
        }

        @Override
        public ICheckpointProtocol getIndexLocal(String name, long commitTime) {
            if (commitTime == 0L) {
                return this.getUnisolatedIndex(name);
            }
            if (AbstractTask.this.resourceManager instanceof IJournal) {
                return ((IJournal)((Object)AbstractTask.this.resourceManager)).getIndexLocal(name, commitTime);
            }
            return (ICheckpointProtocol)((Object)AbstractTask.this.resourceManager.getIndex(name, commitTime));
        }

        @Override
        public IIndex getIndex(String name, long timestamp) {
            return (IIndex)((Object)this.getIndexLocal(name, timestamp));
        }

        @Override
        public SparseRowStore getGlobalRowStore() {
            if (AbstractTask.this.isResource("__globalRowStore")) {
                return this.globalRowStoreHelper.getGlobalRowStore();
            }
            long lastCommitTime = this.getLastCommitTime();
            return this.globalRowStoreHelper.get(lastCommitTime);
        }

        @Override
        public SparseRowStore getGlobalRowStore(long timestamp) {
            if (!TimestampUtility.isReadOnly(timestamp)) {
                return this.getGlobalRowStore();
            }
            IIndex ndx = this.delegate.getIndex("__globalRowStore", timestamp);
            if (ndx != null) {
                return new SparseRowStore(ndx);
            }
            return null;
        }

        @Override
        public BigdataFileSystem getGlobalFileSystem() {
            String namespace = "__globalFileSystem";
            if (AbstractTask.this.isResource("__globalFileSystem.fileMetadata") && AbstractTask.this.isResource("__globalFileSystem.fileData")) {
                return new GlobalFileSystemHelper(this).getGlobalFileSystem();
            }
            return new GlobalFileSystemHelper(this).getReadCommitted();
        }

        @Override
        public TemporaryStore getTempStore() {
            return this.tempStoreFactory.getTempStore();
        }

        @Override
        public IResourceLocator<?> getResourceLocator() {
            return this.resourceLocator;
        }

        @Override
        public ILocalTransactionManager getLocalTransactionManager() {
            return this.delegate.getLocalTransactionManager();
        }

        @Override
        public IResourceLockService getResourceLockService() {
            return this.delegate.getResourceLockService();
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.delegate.getExecutorService();
        }

        @Override
        public Quorum<HAGlue, QuorumService<HAGlue>> getQuorum() {
            return this.delegate.getQuorum();
        }

        @Override
        public final long awaitHAReady(long timeout, TimeUnit units) throws InterruptedException, TimeoutException, AsynchronousQuorumCloseException {
            return this.delegate.awaitHAReady(timeout, units);
        }

        @Override
        public void abort() {
            AbstractTask.this.aborted = true;
        }

        @Override
        public long commit() {
            if (AbstractTask.this.aborted) {
                throw new IllegalStateException("aborted");
            }
            return 0L;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteResources() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCommitter(int index, ICommitter committer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void force(boolean metadata) {
            this.delegate.force(metadata);
        }

        @Override
        public int getByteCount(long addr) {
            return this.delegate.getByteCount(addr);
        }

        @Override
        public ICommitRecord getCommitRecord(long timestamp) {
            return this.delegate.getCommitRecord(timestamp);
        }

        @Override
        public CounterSet getCounters() {
            return this.delegate.getCounters();
        }

        @Override
        public File getFile() {
            return this.delegate.getFile();
        }

        @Override
        public long getOffset(long addr) {
            return this.delegate.getOffset(addr);
        }

        @Override
        public long getPhysicalAddress(long addr) {
            return this.delegate.getPhysicalAddress(addr);
        }

        @Override
        public Properties getProperties() {
            return this.delegate.getProperties();
        }

        @Override
        public UUID getUUID() {
            return this.delegate.getUUID();
        }

        @Override
        public IResourceMetadata getResourceMetadata() {
            return this.delegate.getResourceMetadata();
        }

        @Override
        public long getRootAddr(int index) {
            return this.delegate.getRootAddr(index);
        }

        @Override
        public long getLastCommitTime() {
            return this.delegate.getLastCommitTime();
        }

        @Override
        public IRootBlockView getRootBlockView() {
            return this.delegate.getRootBlockView();
        }

        @Override
        public boolean isFullyBuffered() {
            return this.delegate.isFullyBuffered();
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        @Override
        public boolean isStable() {
            return this.delegate.isStable();
        }

        @Override
        public ByteBuffer read(long addr) {
            return this.delegate.read(addr);
        }

        @Override
        public long size() {
            return this.delegate.size();
        }

        @Override
        public long toAddr(int nbytes, long offset) {
            return this.delegate.toAddr(nbytes, offset);
        }

        @Override
        public String toString(long addr) {
            return this.delegate.toString(addr);
        }

        @Override
        public long write(ByteBuffer data) {
            return this.delegate.write(data, this);
        }

        @Override
        public IPSOutputStream getOutputStream() {
            return this.delegate.getOutputStream(this);
        }

        @Override
        public InputStream getInputStream(long addr) {
            return this.delegate.getInputStream(addr);
        }

        @Override
        public void delete(long addr) {
            this.delegate.delete(addr, this);
        }

        public void detachContext() {
            this.delegate.detachContext(this);
        }

        public void abortContext() {
            this.delegate.abortContext(this);
            this.completeTask();
        }

        @Override
        public ScheduledFuture<?> addScheduledTask(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate.addScheduledTask(task, initialDelay, delay, unit);
        }

        @Override
        public boolean getCollectPlatformStatistics() {
            return this.delegate.getCollectPlatformStatistics();
        }

        @Override
        public boolean getCollectQueueStatistics() {
            return this.delegate.getCollectQueueStatistics();
        }

        @Override
        public int getHttpdPort() {
            return this.delegate.getHttpdPort();
        }

        @Override
        public Iterator<String> indexNameScan(final String prefix, long timestampIsIgnored) {
            return new Striterator(AbstractTask.this.n2a.values().iterator()).addFilter(new Filter(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isValid(Object obj) {
                    return ((Entry)obj).name.startsWith(prefix);
                }
            }).addFilter(new Resolver(){
                private static final long serialVersionUID = 1L;

                @Override
                protected Object resolve(Object obj) {
                    return ((Entry)obj).name;
                }
            });
        }

        @Override
        public boolean isDirty() {
            return this.delegate.isDirty();
        }

        @Override
        public boolean isGroupCommit() {
            return this.delegate.isGroupCommit();
        }
    }

    public static class ResubmitException
    extends RejectedExecutionException {
        private static final long serialVersionUID = -8661545948587322943L;

        public ResubmitException() {
        }

        public ResubmitException(String msg) {
            super(msg);
        }
    }

    protected static class InnerWriteServiceCallable<T>
    extends DelegateTask<T> {
        InnerWriteServiceCallable(AbstractTask<T> delegate) {
            super(delegate);
        }

        @Override
        public T call() throws Exception {
            Object t;
            WriteExecutorService writeService = this.delegate.concurrencyManager.getWriteService();
            this.delegate.setupIndices();
            this.delegate.nanoTime_beginWork = System.nanoTime();
            writeService.activeTaskCountWithLocksHeld.incrementAndGet();
            try {
                Object ret = this.delegate.doTask();
                this.delegate.checkpointNanoTime = this.delegate.checkpointTask();
                t = ret;
            }
            catch (Throwable t2) {
                this.delegate.abortTask();
                throw new RuntimeException(t2);
            }
            finally {
                this.delegate.nanoTime_finishedWork = System.nanoTime();
                writeService.activeTaskCountWithLocksHeld.decrementAndGet();
                try {
                    writeService.getLockManager().releaseLocksForTask((Comparable[])this.delegate.resource);
                }
                catch (Throwable t3) {}
            }
            return t;
        }
    }

    protected static class InnerReadWriteTxServiceCallable<T>
    extends DelegateTask<T> {
        private final Tx tx;

        InnerReadWriteTxServiceCallable(AbstractTask<T> delegate, Tx tx) {
            super(delegate);
            if (tx == null) {
                throw new IllegalArgumentException();
            }
            this.tx = tx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            try {
                Object t;
                this.delegate.nanoTime_beginWork = System.nanoTime();
                this.tx.lock.lock();
                try {
                    t = this.delegate.doTask();
                    this.tx.lock.unlock();
                }
                catch (Throwable throwable) {
                    this.tx.lock.unlock();
                    throw throwable;
                }
                return t;
            }
            finally {
                this.delegate.nanoTime_finishedWork = System.nanoTime();
                this.delegate.clearIndexCache();
            }
        }
    }

    protected static abstract class DelegateTask<T>
    implements ITask<T> {
        protected final AbstractTask<T> delegate;

        protected DelegateTask(AbstractTask<T> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException();
            }
            this.delegate = delegate;
        }

        @Override
        public IResourceManager getResourceManager() {
            return this.delegate.getResourceManager();
        }

        @Override
        public IJournal getJournal() {
            return this.delegate.getJournal();
        }

        @Override
        public String[] getResource() {
            return this.delegate.getResource();
        }

        @Override
        public String getOnlyResource() {
            return this.delegate.getOnlyResource();
        }

        @Override
        public IIndex getIndex(String name) {
            return this.delegate.getIndex(name);
        }

        @Override
        public TaskCounters getTaskCounters() {
            return this.delegate.getTaskCounters();
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "(" + this.delegate.toString() + ")";
        }
    }

    private class CheckpointIndexTask
    implements Callable<Void> {
        private final DirtyListener l;

        public CheckpointIndexTask(DirtyListener l) {
            this.l = l;
        }

        @Override
        public Void call() throws Exception {
            if (log.isInfoEnabled()) {
                log.info((Object)("Writing checkpoint: " + this.l.name));
            }
            try {
                this.l.ndx.writeCheckpoint();
            }
            catch (Throwable t) {
                throw new RuntimeException("Could not commit index: name=" + this.l.name, t);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "{name=" + this.l.name + "}";
        }
    }

    private class DirtyListener
    implements IDirtyListener {
        private final String name;
        private final ICheckpointProtocol ndx;

        public String toString() {
            return "DirtyListener{name=" + this.name + "}";
        }

        DirtyListener(String name, ICheckpointProtocol ndx) {
            assert (name != null);
            assert (ndx != null);
            this.name = name;
            this.ndx = ndx;
        }

        @Override
        public void dirtyEvent(ICheckpointProtocol btree) {
            assert (btree == this.ndx);
            if (AbstractTask.this.commitList.put(this.name, this) != null && log.isInfoEnabled()) {
                log.info((Object)("Added index to commit list: name=" + this.name));
            }
        }
    }

    private static class Entry
    extends Name2Addr.Entry {
        boolean registeredIndex = false;
        boolean droppedIndex = false;

        Entry(Name2Addr.Entry entry) {
            super(entry.name, entry.checkpointAddr, entry.commitTime);
        }

        Entry(String name, long checkpointAddr, long commitTime) {
            super(name, checkpointAddr, commitTime);
            this.registeredIndex = true;
        }
    }
}

