/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.cache.LRUCache;
import com.bigdata.cache.WeakValueCache;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.journal.CommitRecordSerializer;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.rawstore.IRawStore;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class CommitRecordIndex
extends BTree {
    private final IKeyBuilder keyBuilder = new KeyBuilder(8);
    private final WeakValueCache<Long, ICommitRecord> cache = new WeakValueCache(new LRUCache(10));
    private final Entry.EntrySerializer ser = new Entry.EntrySerializer();

    public static CommitRecordIndex create(IRawStore store) {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setBTreeClassName(CommitRecordIndex.class.getName());
        metadata.setTupleSerializer(new CommitRecordIndexTupleSerializer(new ASCIIKeyBuilderFactory(8)));
        return (CommitRecordIndex)BTree.create(store, metadata);
    }

    public static CommitRecordIndex createTransient() {
        IndexMetadata metadata = new IndexMetadata(UUID.randomUUID());
        metadata.setBTreeClassName(CommitRecordIndex.class.getName());
        metadata.setTupleSerializer(new CommitRecordIndexTupleSerializer(new ASCIIKeyBuilderFactory(8)));
        return (CommitRecordIndex)BTree.createTransient(metadata);
    }

    public CommitRecordIndex(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, checkpoint, metadata, readOnly);
    }

    private byte[] getKey(long commitTime) {
        return this.keyBuilder.reset().append(commitTime).getKey();
    }

    public synchronized boolean hasTimestamp(long commitTime) {
        return super.contains(this.getKey(commitTime));
    }

    public synchronized ICommitRecord get(long commitTime) {
        ICommitRecord commitRecord = this.cache.get(commitTime);
        if (commitRecord != null) {
            return commitRecord;
        }
        byte[] val = super.lookup(this.getKey(commitTime));
        if (val == null) {
            return null;
        }
        Entry entry = this.ser.deserializeEntry(new DataInputBuffer(val));
        commitRecord = this.loadCommitRecord(this.store, entry.addr);
        this.cache.put(commitRecord.getTimestamp(), commitRecord, false);
        return commitRecord;
    }

    public synchronized ICommitRecord find(long timestamp) {
        if (timestamp == 0L) {
            throw new IllegalArgumentException("Can not specify 'UNISOLATED' as timestamp");
        }
        if (timestamp == -1L) {
            throw new IllegalArgumentException("Can not specify 'READ_COMMITTED' as timestamp");
        }
        long index = this.findIndexOf(Math.abs(timestamp));
        if (index == -1L) {
            return null;
        }
        return this.valueAtIndex(index);
    }

    public synchronized ICommitRecord findNext(long timestamp) {
        if (timestamp == 0L) {
            throw new IllegalArgumentException("Can not specify 'UNISOLATED' as timestamp");
        }
        if (timestamp == -1L) {
            throw new IllegalArgumentException("Can not specify 'READ_COMMITTED' as timestamp");
        }
        long index = this.findIndexOf(Math.abs(timestamp)) + 1L;
        if (index == this.nentries) {
            return null;
        }
        return this.valueAtIndex(index);
    }

    private ICommitRecord valueAtIndex(long index) {
        Entry entry = this.ser.deserializeEntry(new DataInputBuffer(super.valueAt(index)));
        return this.fetchCommitRecord(entry);
    }

    public ICommitRecord fetchCommitRecord(Entry entry) {
        ICommitRecord commitRecord = this.cache.get(entry.commitTime);
        if (commitRecord == null) {
            commitRecord = this.loadCommitRecord(this.store, entry.addr);
            assert (entry.commitTime == commitRecord.getTimestamp());
            this.cache.put(entry.commitTime, commitRecord, false);
        }
        return commitRecord;
    }

    public synchronized long findIndexOf(long timestamp) {
        long pos = super.indexOf(this.getKey(timestamp));
        if (pos < 0L) {
            if ((pos = -(pos + 1L)) == 0L) {
                return -1L;
            }
            return --pos;
        }
        return pos;
    }

    protected ICommitRecord loadCommitRecord(IRawStore store, long addr) {
        return CommitRecordSerializer.INSTANCE.deserialize(store.read(addr));
    }

    public synchronized void add(long commitRecordAddr, ICommitRecord commitRecord) {
        if (commitRecord == null) {
            throw new IllegalArgumentException();
        }
        if (commitRecordAddr == 0L) {
            throw new IllegalArgumentException();
        }
        long commitTime = commitRecord.getTimestamp();
        byte[] key = this.getKey(commitTime);
        if (!super.contains(key)) {
            super.insert(key, this.ser.serializeEntry(new Entry(commitTime, commitRecordAddr)));
            assert (this.cache.get(commitTime) == null);
            this.cache.put(commitTime, commitRecord, false);
        } else {
            log.warn((Object)("Historical commit record exists: timestamp=" + commitTime));
        }
    }

    public static class CommitRecordIndexTupleSerializer
    extends DefaultTupleSerializer<Long, Entry> {
        private static final long serialVersionUID = 1L;
        private final transient Entry.EntrySerializer ser = new Entry.EntrySerializer();
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public CommitRecordIndexTupleSerializer() {
        }

        public CommitRecordIndexTupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
            super(keyBuilderFactory);
        }

        @Override
        public Long deserializeKey(ITuple tuple) {
            byte[] key = tuple.getKeyBuffer().array();
            long id = KeyBuilder.decodeLong(key, 0);
            return id;
        }

        @Override
        public byte[] serializeKey(Object obj) {
            return this.getKeyBuilder().reset().append((Long)obj).getKey();
        }

        @Override
        public byte[] serializeVal(Entry entry) {
            return this.ser.serializeEntry(entry);
        }

        @Override
        public Entry deserialize(ITuple tuple) {
            return this.ser.deserializeEntry(tuple.getValueStream());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeByte(0);
        }
    }

    public static class Entry {
        public final long commitTime;
        public final long addr;

        public Entry(long commitTime, long addr) {
            this.commitTime = commitTime;
            this.addr = addr;
        }

        public String toString() {
            return super.toString() + "{commitTime=" + this.commitTime + ",addr=" + this.addr + "}";
        }

        public static class EntrySerializer {
            private final DataOutputBuffer out = new DataOutputBuffer(16);

            public byte[] serializeEntry(Entry entry) {
                this.out.reset();
                this.out.putLong(entry.commitTime);
                this.out.putLong(entry.addr);
                return this.out.toByteArray();
            }

            public Entry deserializeEntry(DataInputBuffer is) {
                try {
                    long commitTime = is.readLong();
                    long addr = is.readLong();
                    return new Entry(commitTime, addr);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

