/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.Journal;
import com.bigdata.util.concurrent.DaemonThreadFactory;
import com.bigdata.util.concurrent.ShutdownHelper;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class CompactTask
implements Callable<Journal> {
    protected static final Logger log = Logger.getLogger(CompactTask.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected final Journal oldJournal;
    protected final File outFile;
    protected final long commitTime;
    protected final ICommitRecord commitRecord;
    protected final AtomicReference<Throwable> firstCause = new AtomicReference();
    protected final AtomicInteger startCount = new AtomicInteger(0);
    protected final AtomicInteger doneCount = new AtomicInteger(0);

    public CompactTask(Journal src, File outFile, long commitTime) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (outFile == null) {
            throw new IllegalArgumentException();
        }
        if (commitTime <= 0L) {
            throw new IllegalArgumentException();
        }
        if (commitTime > src.getLastCommitTime()) {
            throw new IllegalArgumentException();
        }
        this.oldJournal = src;
        this.outFile = outFile;
        this.commitTime = commitTime;
        this.commitRecord = src.getCommitRecord(commitTime);
    }

    @Override
    public Journal call() throws Exception {
        Journal newJournal = this.createJournal();
        try {
            this.copyIndices(newJournal);
            newJournal.commit();
            return newJournal;
        }
        catch (Throwable t) {
            try {
                newJournal.close();
            }
            catch (Throwable t2) {
                log.warn((Object)"Could not close the new journal", t2);
            }
            throw new RuntimeException(t);
        }
    }

    protected Journal createJournal() {
        BufferMode bufferMode;
        Properties p = this.oldJournal.getProperties();
        p.setProperty(Journal.Options.FILE, this.outFile.getAbsolutePath());
        if (p.getProperty(Journal.Options.CREATE_TEMP_FILE) != null) {
            p.setProperty(Journal.Options.CREATE_TEMP_FILE, "false");
        }
        if (p.getProperty(Journal.Options.BUFFER_MODE) != null && !(bufferMode = BufferMode.valueOf(p.getProperty(Journal.Options.BUFFER_MODE))).isStable()) {
            p.setProperty(Journal.Options.BUFFER_MODE, BufferMode.Disk.toString());
        }
        return new Journal(p);
    }

    protected void copyIndices(Journal newJournal) {
        long begin = System.currentTimeMillis();
        int nindices = (int)this.oldJournal.getName2Addr(this.commitTime).rangeCount(null, null);
        Iterator<String> nitr = this.oldJournal.indexNameScan(null, this.commitTime);
        final ThreadPoolExecutor service = (ThreadPoolExecutor)Executors.newFixedThreadPool(3, DaemonThreadFactory.defaultThreadFactory());
        while (nitr.hasNext()) {
            String name = nitr.next();
            service.submit(new CopyIndexTask(newJournal, name));
        }
        try {
            new ShutdownHelper(service, 60L, TimeUnit.SECONDS){

                @Override
                protected void logTimeout() {
                    if (INFO) {
                        log.info((Object)("Waiting on task(s): elapsed=" + TimeUnit.NANOSECONDS.toMillis(this.elapsed()) + "ms, #active=" + service.getActiveCount()));
                    }
                }
            };
        }
        catch (InterruptedException e) {
            service.shutdownNow();
            throw new RuntimeException(e);
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (INFO) {
            log.info((Object)("Copied " + nindices + " in " + elapsed + "ms"));
        }
    }

    protected class CopyIndexTask
    implements Callable<Void> {
        protected final Journal newJournal;
        private final String name;

        public CopyIndexTask(Journal newJournal, String name) {
            if (newJournal == null) {
                throw new IllegalArgumentException();
            }
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.newJournal = newJournal;
            this.name = name;
        }

        @Override
        public Void call() throws Exception {
            try {
                CompactTask.this.startCount.incrementAndGet();
                if (INFO) {
                    log.info((Object)("Start: name=" + this.name));
                }
                BTree oldBTree = (BTree)CompactTask.this.oldJournal.getIndexWithCommitRecord(this.name, CompactTask.this.commitRecord);
                long entryCount = oldBTree.rangeCount();
                IndexMetadata indexMetadata = oldBTree.getIndexMetadata().clone();
                indexMetadata.write(this.newJournal);
                long oldCounter = oldBTree.getCounter().get();
                if (INFO) {
                    log.info((Object)("name=" + this.name + ", entryCount=" + entryCount + ", checkpoint=" + oldBTree.getCheckpoint()));
                }
                Checkpoint overflowCheckpoint = indexMetadata.overflowCheckpoint(oldBTree.getCheckpoint());
                overflowCheckpoint.write(this.newJournal);
                BTree newBTree = BTree.load(this.newJournal, overflowCheckpoint.getCheckpointAddr(), false);
                long newCounter = newBTree.getCounter().get();
                assert (newCounter == oldCounter) : "expected oldCounter=" + oldCounter + ", but found newCounter=" + newCounter;
                if (DEBUG) {
                    log.debug((Object)("Copying data to new journal: name=" + this.name + ", entryCount=" + entryCount));
                }
                newBTree.rangeCopy(oldBTree, null, null, true);
                this.newJournal.registerIndex(this.name, newBTree);
                if (DEBUG) {
                    log.debug((Object)("Done with index: name=" + this.name));
                }
                CompactTask.this.doneCount.incrementAndGet();
            }
            catch (Throwable t) {
                CompactTask.this.firstCause.compareAndSet(null, t);
            }
            return null;
        }
    }
}

