/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import cern.colt.Arrays;
import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.bfs.GlobalFileSystemHelper;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BTreeCounters;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.ReadCommittedView;
import com.bigdata.config.IntegerValidator;
import com.bigdata.config.LongValidator;
import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.CounterSet;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.HAStatusEnum;
import com.bigdata.ha.HATXSGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.msg.HAGatherReleaseTimeRequest;
import com.bigdata.ha.msg.HANotifyReleaseTimeRequest;
import com.bigdata.ha.msg.HANotifyReleaseTimeResponse;
import com.bigdata.ha.msg.IHAGatherReleaseTimeRequest;
import com.bigdata.ha.msg.IHANotifyReleaseTimeRequest;
import com.bigdata.ha.msg.IHANotifyReleaseTimeResponse;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.AbstractLocalTransactionManager;
import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.CompactTask;
import com.bigdata.journal.ConcurrencyManager;
import com.bigdata.journal.GangliaPlugIn;
import com.bigdata.journal.HttpPlugin;
import com.bigdata.journal.IBufferStrategy;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.IConcurrencyManager;
import com.bigdata.journal.ILocalTransactionManager;
import com.bigdata.journal.IPlugIn;
import com.bigdata.journal.IResourceLockService;
import com.bigdata.journal.IResourceManager;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.JournalTransactionService;
import com.bigdata.journal.PlatformStatsPlugIn;
import com.bigdata.journal.QueueStatsPlugIn;
import com.bigdata.journal.ResourceLockService;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.journal.TemporaryStoreFactory;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.journal.Tx;
import com.bigdata.journal.ValidationError;
import com.bigdata.journal.WORMStrategy;
import com.bigdata.journal.WriteExecutorService;
import com.bigdata.journal.jini.ha.HAJournal;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumException;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.relation.locator.IResourceLocator;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.StaleLocatorReason;
import com.bigdata.rwstore.IHistoryManager;
import com.bigdata.rwstore.IRawTx;
import com.bigdata.service.AbstractTransactionService;
import com.bigdata.service.DataService;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.sparse.GlobalRowStoreHelper;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.DaemonThreadFactory;
import com.bigdata.util.concurrent.LatchedExecutor;
import com.bigdata.util.concurrent.ShutdownHelper;
import com.bigdata.util.concurrent.ThreadPoolExecutorBaseStatisticsTask;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class Journal
extends AbstractJournal
implements IConcurrencyManager,
IResourceManager {
    private static final Logger log = Logger.getLogger(Journal.class);
    private static final Logger txLog = Logger.getLogger((String)"com.bigdata.txLog");
    private final AbstractLocalTransactionManager localTransactionManager;
    private final ConcurrencyManager concurrencyManager;
    private final boolean isGroupCommit;
    private final AtomicReference<GlobalRowStoreHelper> globalRowStoreHelper = new AtomicReference();
    private final AtomicReference<GlobalFileSystemHelper> globalFileSystemHelper = new AtomicReference();
    private final TemporaryStoreFactory tempStoreFactory;
    private final IResourceLocator<?> resourceLocator;
    private final ResourceLockService resourceLockManager;
    private final ThreadPoolExecutor executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicReference<IPlugIn<Journal, ThreadPoolExecutorBaseStatisticsTask>> pluginQueueStats = new AtomicReference();
    private final AtomicReference<IPlugIn<Journal, AbstractStatisticsCollector>> pluginPlatformStats = new AtomicReference();
    private final AtomicReference<IPlugIn<Journal, ?>> pluginHttpd = new AtomicReference();
    private final AtomicReference<IPlugIn<Journal, ?>> pluginGanglia = new AtomicReference();
    private final LatchedExecutor readService;
    private final ConcurrentHashMap<String, BTreeCounters> indexCounters = new ConcurrentHashMap();
    private final Semaphore unisolatedSemaphore = new Semaphore(1, false);

    public Journal(Properties properties) {
        this(properties, null);
    }

    public Journal(Properties properties, Quorum<HAGlue, QuorumService<HAGlue>> quorum) {
        super(properties, quorum);
        this.isGroupCommit = Boolean.parseBoolean(properties.getProperty(Options.GROUP_COMMIT, "false"));
        this.tempStoreFactory = new TemporaryStoreFactory(properties);
        this.executorService = (ThreadPoolExecutor)Executors.newCachedThreadPool(new DaemonThreadFactory(this.getClass().getName() + ".executorService"));
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(this.getClass().getName() + ".sampleService"));
        int readPoolSize = Integer.valueOf(properties.getProperty(Options.READ_POOL_SIZE, "0"));
        this.readService = readPoolSize > 0 ? new LatchedExecutor(this.executorService, readPoolSize) : null;
        this.resourceLocator = this.newResourceLocator();
        this.resourceLockManager = new ResourceLockService();
        this.localTransactionManager = this.newLocalTransactionManager();
        this.concurrencyManager = new ConcurrencyManager(properties, this.localTransactionManager, this);
        this.getExecutorService().execute(new StartDeferredTasksTask());
        if (this.isGroupCommit() && !(this instanceof HAJournal) && this.getRootBlockView().getCommitCounter() == 0L) {
            this.getGlobalRowStore();
            this.commit();
        }
    }

    private Properties checkProperties(Properties properties) {
        if (this.getBufferStrategy() instanceof WORMStrategy) {
            properties.setProperty(AbstractTransactionService.Options.MIN_RELEASE_AGE, "9223372036854775807");
        }
        return properties;
    }

    protected IResourceLocator<?> newResourceLocator() {
        int cacheCapacity = this.getProperty(Options.LOCATOR_CACHE_CAPACITY, "20", IntegerValidator.GT_ZERO);
        long cacheTimeout = this.getProperty(Options.LOCATOR_CACHE_TIMEOUT, "60000", LongValidator.GTE_ZERO);
        return new DefaultResourceLocator(this, null, cacheCapacity, cacheTimeout);
    }

    private long newConsensusProtocolTimestamp() {
        return ((AbstractJournal.BasicHA)this.getQuorum().getClient().getService()).nextTimestamp();
    }

    protected JournalTransactionService newTransactionService() {
        InnerJournalTransactionService abstractTransactionService = new InnerJournalTransactionService();
        return abstractTransactionService;
    }

    protected AbstractLocalTransactionManager newLocalTransactionManager() {
        final JournalTransactionService abstractTransactionService = this.newTransactionService();
        abstractTransactionService.start();
        return new AbstractLocalTransactionManager(){

            @Override
            public AbstractTransactionService getTransactionService() {
                return abstractTransactionService;
            }

            @Override
            public void shutdown() {
                ((JournalTransactionService)this.getTransactionService()).shutdown();
                super.shutdown();
            }

            @Override
            public void shutdownNow() {
                ((JournalTransactionService)this.getTransactionService()).shutdownNow();
                super.shutdownNow();
            }
        };
    }

    @Override
    public AbstractLocalTransactionManager getLocalTransactionManager() {
        return this.localTransactionManager;
    }

    @Override
    public boolean isGroupCommit() {
        return this.isGroupCommit;
    }

    @Override
    public CounterSet getCounters() {
        QueryEngine queryEngine;
        ThreadPoolExecutorBaseStatisticsTask t;
        CounterSet root = new CounterSet();
        AbstractStatisticsCollector t2 = this.getPlatformStatisticsCollector();
        if (t2 != null) {
            root.attach(t2.getCounters());
        }
        CounterSet tmp = root.makePath("JVM");
        tmp.attach(AbstractStatisticsCollector.getMemoryCounterSet());
        tmp = root.makePath("Journal");
        tmp.attach(super.getCounters());
        CounterSet indexCounters = this.getIndexCounters();
        if (indexCounters != null) {
            tmp.makePath("Index Manager").attach(indexCounters);
        }
        tmp.makePath("Concurrency Manager").attach(this.concurrencyManager.getCounters());
        tmp.makePath("Transaction Manager").attach(this.localTransactionManager.getCounters());
        IPlugIn<Journal, ThreadPoolExecutorBaseStatisticsTask> plugin = this.pluginQueueStats.get();
        if (plugin != null && (t = plugin.getService()) != null) {
            tmp.makePath("Executor Service").attach(t.getCounters());
        }
        if ((queryEngine = QueryEngineFactory.getExistingQueryController(this)) != null) {
            CounterSet tmp2 = root.makePath("Query Engine");
            tmp2.attach(queryEngine.getCounters());
        }
        return root;
    }

    @Override
    public File getTmpDir() {
        return this.tmpDir;
    }

    @Override
    public File getDataDir() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getParentFile();
    }

    @Override
    public IRawStore openStore(UUID uuid) {
        if (uuid == this.getRootBlockView().getUUID()) {
            return this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractBTree[] getIndexSources(String name, long timestamp) {
        BTree btree;
        if (timestamp == 0L) {
            btree = this.getIndex(name);
        } else {
            if (timestamp == -1L) {
                throw new UnsupportedOperationException("Read-committed view");
            }
            long ts = Math.abs(timestamp);
            btree = (BTree)super.getIndex(name, ts);
            if (btree != null) assert (btree.getLastCommitTime() != 0L);
        }
        if (btree == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No such index: name=" + name + ", timestamp=" + timestamp));
            }
            return null;
        }
        return new AbstractBTree[]{btree};
    }

    @Override
    public final AbstractJournal getLiveJournal() {
        return this;
    }

    @Override
    public final AbstractJournal getJournal(long timestamp) {
        return this;
    }

    public Future<Journal> compact(File outFile) {
        return this.executorService.submit(new CompactTask(this, outFile, this.getLastCommitTime()));
    }

    @Override
    public void dropIndex(String name) {
        BTreeCounters btreeCounters = this.getIndexCounters(name);
        super.dropIndex(name);
        if (btreeCounters != null) {
            this.indexCounters.remove(name, btreeCounters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILocalBTreeView getIndex(String name, long timestamp) {
        ILocalBTreeView tmp;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        boolean isReadWriteTx = TimestampUtility.isReadWriteTx(timestamp);
        Tx tx = (Tx)this.getTransactionManager().getTx(timestamp);
        if (isReadWriteTx) {
            if (tx == null) {
                log.warn((Object)("Unknown transaction: name=" + name + ", tx=" + timestamp));
                return null;
            }
            tx.lock.lock();
            try {
                if (!tx.isActive()) {
                    log.warn((Object)("Transaction not active: name=" + name + ", tx=" + timestamp + ", prepared=" + tx.isPrepared() + ", complete=" + tx.isComplete() + ", aborted=" + tx.isAborted()));
                    ILocalBTreeView iLocalBTreeView = null;
                    return iLocalBTreeView;
                }
            }
            finally {
                tx.lock.unlock();
            }
        }
        if (isReadWriteTx && tx == null) {
            log.warn((Object)("No such transaction: name=" + name + ", tx=" + timestamp));
            return null;
        }
        boolean readOnly = TimestampUtility.isReadOnly(timestamp);
        if (isReadWriteTx) {
            ILocalBTreeView isolatedIndex = tx.getIndex(name);
            if (isolatedIndex == null) {
                log.warn((Object)("No such index: name=" + name + ", tx=" + timestamp));
                return null;
            }
            tmp = isolatedIndex;
        } else if (readOnly) {
            if (timestamp == -1L) {
                tmp = new ReadCommittedView(this, name);
            } else if (tx != null) {
                AbstractBTree[] sources = this.getIndexSources(name, tx.getReadsOnCommitTime());
                if (sources == null) {
                    log.warn((Object)("No such index: name=" + name + ", timestamp=" + timestamp));
                    return null;
                }
                assert (sources[0].isReadOnly());
                tmp = (BTree)sources[0];
            } else {
                AbstractBTree[] sources = this.getIndexSources(name, timestamp);
                if (sources == null) {
                    log.warn((Object)("No such index: name=" + name + ", timestamp=" + timestamp));
                    return null;
                }
                assert (sources[0].isReadOnly());
                tmp = (BTree)sources[0];
            }
        } else {
            assert (timestamp == 0L);
            AbstractBTree[] sources = this.getIndexSources(name, 0L);
            if (sources == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("No such index: name=" + name + ", timestamp=" + timestamp));
                }
                return null;
            }
            assert (!sources[0].isReadOnly());
            tmp = (BTree)sources[0];
        }
        tmp.getMutableBTree().setBTreeCounters(this.getIndexCounters(name));
        return tmp;
    }

    @Override
    public AbstractBTree[] getIndexSources(String name, long timestamp, BTree btree) {
        return new AbstractBTree[]{btree};
    }

    public final long newTx(long timestamp) {
        try {
            return this.getTransactionService().newTx(timestamp);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public final void abort(long tx) {
        try {
            this.getTransactionService().abort(tx);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final long commit(long tx) throws ValidationError {
        try {
            return this.getTransactionService().commit(tx);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final long nextTimestamp() {
        return this.localTransactionManager.nextTimestamp();
    }

    public ConcurrencyManager getConcurrencyManager() {
        return this.concurrencyManager;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isOpen()) {
            return;
        }
        this.localTransactionManager.shutdown();
        IPlugIn<Journal, Object> plugIn = this.pluginGanglia.get();
        if (plugIn != null) {
            plugIn.stopService(false);
        }
        if ((plugIn = this.pluginQueueStats.get()) != null) {
            plugIn.stopService(false);
        }
        if ((plugIn = this.pluginPlatformStats.get()) != null) {
            plugIn.stopService(false);
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        if ((plugIn = this.pluginHttpd.get()) != null) {
            plugIn.stopService(false);
        }
        try {
            new ShutdownHelper(this.executorService, 1000L, TimeUnit.MILLISECONDS){

                @Override
                protected void logTimeout() {
                    log.warn((Object)("Waiting on task(s): elapsed=" + TimeUnit.NANOSECONDS.toMillis(this.elapsed()) + "ms, #active=" + Journal.this.executorService.getActiveCount()));
                }
            };
        }
        catch (InterruptedException ex) {
            log.warn((Object)("Immediate shutdown: " + ex));
            this.shutdownNow();
            return;
        }
        this.concurrencyManager.shutdown();
        super.shutdown();
    }

    @Override
    public synchronized void shutdownNow() {
        if (!this.isOpen()) {
            return;
        }
        IPlugIn<Journal, Object> plugIn = this.pluginGanglia.get();
        if (plugIn != null) {
            plugIn.stopService(true);
        }
        if ((plugIn = this.pluginQueueStats.get()) != null) {
            plugIn.stopService(true);
        }
        if ((plugIn = this.pluginPlatformStats.get()) != null) {
            plugIn.stopService(true);
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        if ((plugIn = this.pluginHttpd.get()) != null) {
            plugIn.stopService(false);
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.concurrencyManager != null) {
            this.concurrencyManager.shutdownNow();
        }
        if (this.localTransactionManager != null) {
            this.localTransactionManager.shutdownNow();
        }
        super.shutdownNow();
    }

    @Override
    protected void _close() {
        super._close();
        if (this.tempStoreFactory != null) {
            this.tempStoreFactory.closeAll();
        }
    }

    @Override
    public <T> FutureTask<T> submit(AbstractTask<T> task) {
        return this.concurrencyManager.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends AbstractTask<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.concurrencyManager.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends AbstractTask<T>> tasks) throws InterruptedException {
        return this.concurrencyManager.invokeAll(tasks);
    }

    @Override
    public IResourceManager getResourceManager() {
        return this.concurrencyManager.getResourceManager();
    }

    @Override
    public ILocalTransactionManager getTransactionManager() {
        return this.localTransactionManager;
    }

    public ITransactionService getTransactionService() {
        return this.localTransactionManager.getTransactionService();
    }

    @Override
    public WriteExecutorService getWriteService() {
        return this.concurrencyManager.getWriteService();
    }

    @Override
    public boolean shouldOverflow() {
        return false;
    }

    @Override
    public boolean isOverflowEnabled() {
        return false;
    }

    @Override
    public Future<Object> overflow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getIndexSegmentFile(IndexMetadata indexMetadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IBigdataFederation<?> getFederation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataService getDataService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UUID getDataServiceUUID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StaleLocatorReason getIndexPartitionGone(String name) {
        return null;
    }

    @Override
    public SparseRowStore getGlobalRowStore() {
        return this.getGlobalRowStoreHelper().getGlobalRowStore();
    }

    @Override
    public SparseRowStore getGlobalRowStore(long timestamp) {
        return this.getGlobalRowStoreHelper().get(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GlobalRowStoreHelper getGlobalRowStoreHelper() {
        GlobalRowStoreHelper t = this.globalRowStoreHelper.get();
        if (t == null) {
            AtomicReference<GlobalRowStoreHelper> atomicReference = this.globalRowStoreHelper;
            synchronized (atomicReference) {
                t = this.globalRowStoreHelper.get();
                if (t == null) {
                    t = new GlobalRowStoreHelper(this);
                    this.globalRowStoreHelper.set(t);
                }
            }
        }
        return this.globalRowStoreHelper.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigdataFileSystem getGlobalFileSystem() {
        GlobalFileSystemHelper t = this.globalFileSystemHelper.get();
        if (t == null) {
            AtomicReference<GlobalFileSystemHelper> atomicReference = this.globalFileSystemHelper;
            synchronized (atomicReference) {
                t = this.globalFileSystemHelper.get();
                if (t == null) {
                    t = new GlobalFileSystemHelper(this);
                    this.globalFileSystemHelper.set(t);
                }
            }
        }
        return this.globalFileSystemHelper.get().getGlobalFileSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void discardCommitters() {
        super.discardCommitters();
        AtomicReference<Object> atomicReference = this.globalRowStoreHelper;
        synchronized (atomicReference) {
            this.globalRowStoreHelper.set(null);
        }
        atomicReference = this.globalFileSystemHelper;
        synchronized (atomicReference) {
            this.globalFileSystemHelper.set(null);
        }
    }

    @Override
    public TemporaryStore getTempStore() {
        return this.tempStoreFactory.getTempStore();
    }

    @Override
    public IResourceLocator<?> getResourceLocator() {
        this.assertOpen();
        return this.resourceLocator;
    }

    @Override
    public IResourceLockService getResourceLockService() {
        this.assertOpen();
        return this.resourceLockManager;
    }

    @Override
    public ExecutorService getExecutorService() {
        this.assertOpen();
        return this.executorService;
    }

    public AbstractStatisticsCollector getPlatformStatisticsCollector() {
        IPlugIn<Journal, AbstractStatisticsCollector> plugin = this.pluginPlatformStats.get();
        if (plugin == null) {
            return null;
        }
        AbstractStatisticsCollector t = plugin.getService();
        return t;
    }

    public Object getGangliaService() {
        IPlugIn<Journal, ?> plugin = this.pluginGanglia.get();
        if (plugin == null) {
            return null;
        }
        return plugin.getService();
    }

    public LatchedExecutor getReadExecutor() {
        return this.readService;
    }

    @Override
    public ScheduledFuture<?> addScheduledTask(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Scheduling task: task=" + task.getClass() + ", initialDelay=" + initialDelay + ", delay=" + delay + ", unit=" + (Object)((Object)unit)));
        }
        return this.scheduledExecutorService.scheduleWithFixedDelay(task, initialDelay, delay, unit);
    }

    @Override
    public final boolean getCollectPlatformStatistics() {
        return Boolean.valueOf(this.properties.getProperty(Options.COLLECT_PLATFORM_STATISTICS, "false"));
    }

    @Override
    public final boolean getCollectQueueStatistics() {
        return Boolean.valueOf(this.properties.getProperty(Options.COLLECT_QUEUE_STATISTICS, "false"));
    }

    @Override
    public final int getHttpdPort() {
        return Integer.valueOf(this.properties.getProperty(Options.HTTPD_PORT, "-1"));
    }

    @Override
    public BTreeCounters getIndexCounters(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        BTreeCounters t = this.indexCounters.get(name);
        if (t == null) {
            t = new BTreeCounters();
            BTreeCounters oldval = this.indexCounters.putIfAbsent(name, t);
            if (oldval != null) {
                t = oldval;
            } else if (log.isInfoEnabled()) {
                log.info((Object)("New counters: indexPartitionName=" + name));
            }
        }
        assert (t != null);
        return t;
    }

    public void acquireUnisolatedConnection() throws InterruptedException {
        this.unisolatedSemaphore.acquire();
        if (log.isDebugEnabled()) {
            log.debug((Object)("acquired semaphore: availablePermits=" + this.unisolatedSemaphore.availablePermits()));
        }
        if (this.unisolatedSemaphore.availablePermits() != 0) {
            throw new IllegalStateException();
        }
    }

    public void releaseUnisolatedConnection() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("releasing semaphore: availablePermits=" + this.unisolatedSemaphore.availablePermits()));
        }
        if (this.unisolatedSemaphore.availablePermits() != 0) {
            throw new IllegalStateException();
        }
        this.unisolatedSemaphore.release();
    }

    private class StartDeferredTasksTask
    implements Runnable {
        private final Logger log = Logger.getLogger(StartDeferredTasksTask.class);

        private StartDeferredTasksTask() {
        }

        @Override
        public void run() {
            try {
                this.startDeferredTasks();
            }
            catch (Throwable t) {
                this.log.error((Object)t, t);
                return;
            }
        }

        protected void startDeferredTasks() throws IOException {
            IPlugIn<Journal, ThreadPoolExecutorBaseStatisticsTask> tmp = new QueueStatsPlugIn();
            tmp.startService(Journal.this);
            Journal.this.pluginQueueStats.set(tmp);
            tmp = new PlatformStatsPlugIn();
            tmp.startService(Journal.this);
            Journal.this.pluginPlatformStats.set(tmp);
            tmp = new HttpPlugin();
            tmp.startService(Journal.this);
            Journal.this.pluginHttpd.set(tmp);
            if (Journal.this.getPlatformStatisticsCollector() != null) {
                tmp = new GangliaPlugIn();
                tmp.startService(Journal.this);
                if (tmp.isRunning()) {
                    Journal.this.pluginGanglia.set(tmp);
                }
            }
        }
    }

    public static interface IJournalCounters
    extends ConcurrencyManager.IConcurrencyManagerCounters,
    ResourceManager.IResourceManagerCounters {
        public static final String concurrencyManager = "Concurrency Manager";
        public static final String indexManager = "Index Manager";
        public static final String transactionManager = "Transaction Manager";
        public static final String executorService = "Executor Service";
        public static final String queryEngine = "Query Engine";
    }

    private class InnerJournalTransactionService
    extends JournalTransactionService {
        private final ConcurrentHashMap<Long, IRawTx> m_rawTxs;
        private final ReentrantLock barrierLock;
        private final AtomicReference<BarrierState> barrierRef;

        protected InnerJournalTransactionService() {
            super(Journal.this.checkProperties(Journal.this.properties), Journal.this);
            this.m_rawTxs = new ConcurrentHashMap();
            this.barrierLock = new ReentrantLock();
            this.barrierRef = new AtomicReference();
            long lastCommitTime = Journal.this.getLastCommitTime();
            if (lastCommitTime != 0L) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Startup: lastCommitTime=" + lastCommitTime));
                }
                this.updateReleaseTimeForBareCommit(lastCommitTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runWithBarrierLock(Runnable r) {
            block8: {
                this.barrierLock.lock();
                try {
                    AbstractJournal.haLog.info((Object)"Will run with barrier lock.");
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        try {
                            AbstractJournal.haLog.error((Object)t, t);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            AbstractJournal.haLog.info((Object)"Did run with barrier lock.");
                        }
                    }
                    AbstractJournal.haLog.info((Object)"Did run with barrier lock.");
                }
                finally {
                    this.barrierLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IHANotifyReleaseTimeResponse updateReleaseTimeConsensus(long newCommitCounter, long newCommitTime, UUID[] joinedServiceIds, long timeout, TimeUnit units) throws IOException, InterruptedException, TimeoutException, BrokenBarrierException {
            long nanos;
            long begin = System.nanoTime();
            long remaining = nanos = units.toNanos(timeout);
            long token = Journal.this.getQuorum().token();
            if (AbstractJournal.haLog.isInfoEnabled()) {
                AbstractJournal.haLog.info((Object)("GATHER PROTOCOL: commitCounter=" + newCommitCounter + ", token=" + token + ", joinedServiceIds=" + Arrays.toString((Object[])joinedServiceIds)));
            }
            this.barrierLock.lock();
            try {
                Journal.this.getQuorum().assertLeader(token);
                BarrierState barrierState = new BarrierState(newCommitCounter, newCommitTime, joinedServiceIds);
                if (!this.barrierRef.compareAndSet(null, barrierState)) {
                    throw new IllegalStateException();
                }
                try {
                    remaining = nanos - (System.nanoTime() - begin);
                    barrierState.messageFollowers(token, remaining);
                }
                finally {
                    if (!this.barrierRef.compareAndSet(barrierState, null)) {
                        throw new AssertionError();
                    }
                }
                if (barrierState.cause != null) {
                    throw new RuntimeException(barrierState.cause);
                }
                IHANotifyReleaseTimeResponse consensus = barrierState.consensus;
                if (consensus == null) {
                    throw new RuntimeException("No consensus");
                }
                long consensusValue = consensus.getCommitTime();
                long newReleaseTime = Math.max(0L, consensusValue - 1L);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Advancing releaseTime on leader: " + newReleaseTime));
                }
                this.setReleaseTime(newReleaseTime);
                IHANotifyReleaseTimeResponse iHANotifyReleaseTimeResponse = consensus;
                return iHANotifyReleaseTimeResponse;
            }
            finally {
                this.barrierLock.unlock();
            }
        }

        @Override
        protected boolean isReleaseTimeConsensusProtocol() {
            HAStatusEnum haStatus = this.getHAStatus();
            return haStatus != null && haStatus != HAStatusEnum.NotReady;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setReleaseTime(long newValue) {
            if (newValue < 0L) {
                throw new IllegalArgumentException();
            }
            this.lock.lock();
            try {
                super.setReleaseTime(newValue);
            }
            finally {
                this.lock.unlock();
            }
        }

        protected IHANotifyReleaseTimeRequest newHANotifyReleaseTimeRequest(UUID serviceId, long newCommitCounter, long newCommitTime) {
            long effectiveReleaseTimeForHA = this.getEffectiveReleaseTimeForHA();
            ICommitRecord commitRecord = Journal.this.getEarliestVisibleCommitRecordForHA(effectiveReleaseTimeForHA);
            long commitCounter = commitRecord == null ? 0L : commitRecord.getCommitCounter();
            long commitTime = commitRecord == null ? 0L : commitRecord.getTimestamp();
            long now = Journal.this.newConsensusProtocolTimestamp();
            HANotifyReleaseTimeRequest req = new HANotifyReleaseTimeRequest(serviceId, commitTime, commitCounter, now, false, newCommitCounter, newCommitTime);
            if (log.isTraceEnabled()) {
                log.trace((Object)("releaseTime=" + this.getReleaseTime() + ",effectiveReleaseTimeForHA=" + effectiveReleaseTimeForHA + ",rootBlock=" + Journal.this.getRootBlockView() + ",req=" + req));
            }
            return req;
        }

        @Override
        public Callable<IHANotifyReleaseTimeResponse> newGatherMinimumVisibleCommitTimeTask(HAGlue leader, UUID serviceId, IHAGatherReleaseTimeRequest req) {
            return new GatherTask(leader, serviceId, req);
        }

        @Override
        public void gatherMinimumVisibleCommitTime(IHAGatherReleaseTimeRequest req) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IHANotifyReleaseTimeResponse notifyEarliestCommitTime(IHANotifyReleaseTimeRequest req) throws IOException, InterruptedException, BrokenBarrierException {
            BarrierState barrierState = this.barrierRef.get();
            if (barrierState == null) {
                throw new IllegalStateException();
            }
            try {
                if (AbstractJournal.haLog.isInfoEnabled()) {
                    AbstractJournal.haLog.info((Object)("resp=" + req));
                }
                Journal.this.getQuorum().assertLeader(barrierState.token);
                if (barrierState.newCommitCounter != req.getNewCommitCounter()) {
                    throw new RuntimeException("Wrong newCommitCounter: expected=" + barrierState.newCommitCounter + ", actual=" + req.getNewCommitCounter());
                }
                if (barrierState.newCommitTime != req.getNewCommitTime()) {
                    throw new RuntimeException("Wrong newCommitTime: expected=" + barrierState.newCommitTime + ", actual=" + req.getNewCommitTime());
                }
                UUID followerId = req.getServiceUUID();
                barrierState.followerResponses.put(followerId, req);
            }
            catch (RuntimeException e) {
                AbstractJournal.haLog.error((Object)e, (Throwable)e);
                barrierState.barrier.reset();
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (AbstractJournal.haLog.isInfoEnabled()) {
                        AbstractJournal.haLog.info((Object)("Awaiting barrier: #followerResponses=" + barrierState.followerResponses.size() + ", #parties=" + barrierState.barrier.getParties() + ", #joinedUUIDs=" + barrierState.joinedServiceIds.length));
                    }
                }
                finally {
                    barrierState.barrier.await();
                }
            }
            Throwable t = barrierState.cause;
            if (t != null) {
                AbstractJournal.haLog.error((Object)t, t);
                throw new RuntimeException(t);
            }
            IHANotifyReleaseTimeResponse resp = barrierState.consensus;
            if (resp == null) {
                AbstractJournal.haLog.error((Object)"No consensus");
            }
            return resp;
        }

        private final HAStatusEnum getHAStatus() {
            HAGlue localService;
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = Journal.this.getQuorum();
            if (quorum == null) {
                return null;
            }
            try {
                localService = (HAGlue)quorum.getClient().getService();
            }
            catch (IllegalStateException ex) {
                return null;
            }
            try {
                return localService.getHAStatus();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long newTx(long timestamp) {
            if (TimestampUtility.isReadWriteTx(timestamp)) {
                throw new IllegalArgumentException();
            }
            HAStatusEnum haStatus = this.getHAStatus();
            if (haStatus == null) {
                return this._newTx(timestamp);
            }
            if (haStatus == HAStatusEnum.NotReady) {
                throw new QuorumException();
            }
            if (timestamp == 0L && haStatus != HAStatusEnum.Leader) {
                throw new QuorumException("Not quorum leader");
            }
            if (timestamp == 0L || timestamp == -1L) {
                return this._newTx(timestamp);
            }
            this.lock.lock();
            try {
                long now = this.nextTimestamp();
                long minReleaseAge = this.getMinReleaseAge();
                long ageOfTxView = now - timestamp;
                if (ageOfTxView < minReleaseAge) {
                    long l = this._newTx(timestamp);
                    return l;
                }
                AbstractTransactionService.TxState state = this.getEarliestActiveTx();
                if (state != null && state.getReadsOnCommitTime() <= timestamp) {
                    long l = this._newTx(timestamp);
                    return l;
                }
                IRootBlockView rootBlock = Journal.this.getRootBlockView();
                if (rootBlock.getCommitCounter() == 0L) {
                    long l = this._newTx(timestamp);
                    return l;
                }
                if (rootBlock.getLastCommitTime() <= timestamp) {
                    long l = this._newTx(timestamp);
                    return l;
                }
            }
            finally {
                this.lock.unlock();
            }
            this.barrierLock.lock();
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"NewTx with barrierLock");
                }
                long l = this._newTx(timestamp);
                return l;
            }
            finally {
                this.barrierLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final long _newTx(long timestamp) {
            try (IRawTx tx = null;){
                IBufferStrategy bufferStrategy = Journal.this.getBufferStrategy();
                if (bufferStrategy instanceof IHistoryManager) {
                    tx = ((IHistoryManager)((Object)bufferStrategy)).newTx();
                }
                long l = super.newTx(timestamp);
                return l;
            }
        }

        @Override
        public long commit(long tx) {
            AbstractTransactionService.TxState state = this.getTxState(tx);
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = Journal.this.getQuorum();
            if (quorum != null && state != null && !state.isReadOnly()) {
                long token = Journal.this.getQuorumToken();
                Journal.this.getQuorum().assertLeader(token);
            }
            return super.commit(tx);
        }

        @Override
        protected void activateTx(AbstractTransactionService.TxState state) {
            IBufferStrategy bufferStrategy;
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("OPEN : txId=" + state.tx + ", readsOnCommitTime=" + state.getReadsOnCommitTime()));
            }
            if ((bufferStrategy = Journal.this.getBufferStrategy()) instanceof IHistoryManager) {
                IRawTx tx = ((IHistoryManager)((Object)bufferStrategy)).newTx();
                if (this.m_rawTxs.put(state.tx, tx) != null) {
                    throw new IllegalStateException("Unexpected existing RawTx");
                }
            }
            super.activateTx(state);
        }

        @Override
        protected void deactivateTx(AbstractTransactionService.TxState state) {
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("CLOSE: txId=" + state.tx + ", readsOnCommitTime=" + state.getReadsOnCommitTime()));
            }
            super.deactivateTx(state);
            IRawTx tx = this.m_rawTxs.remove(state.tx);
            if (tx != null) {
                tx.close();
            }
        }

        @Override
        public void abortAllTx() {
            super.abortAllTx();
            Journal.this.concurrencyManager.abortAllTx();
        }

        private class GatherTask
        implements Callable<IHANotifyReleaseTimeResponse> {
            private final HAGlue leader;
            private final UUID serviceId;
            private final IHAGatherReleaseTimeRequest req;
            private volatile boolean didNotifyLeader = false;

            public GatherTask(HAGlue leader, UUID serviceId, IHAGatherReleaseTimeRequest req) {
                if (leader == null) {
                    throw new IllegalArgumentException();
                }
                if (serviceId == null) {
                    throw new IllegalArgumentException();
                }
                if (req == null) {
                    throw new IllegalArgumentException();
                }
                this.leader = leader;
                this.serviceId = serviceId;
                this.req = req;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IHANotifyReleaseTimeResponse call() throws Exception {
                if (AbstractJournal.haLog.isInfoEnabled()) {
                    AbstractJournal.haLog.info((Object)"Running gather on follower");
                }
                this.didNotifyLeader = false;
                this.preconditionTest();
                InnerJournalTransactionService.this.barrierLock.lock();
                try {
                    this.preconditionTest();
                    IHANotifyReleaseTimeResponse iHANotifyReleaseTimeResponse = this.doRunWithBarrierLock();
                    InnerJournalTransactionService.this.barrierLock.unlock();
                    return iHANotifyReleaseTimeResponse;
                }
                catch (Throwable throwable) {
                    try {
                        InnerJournalTransactionService.this.barrierLock.unlock();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        log.error((Object)t, t);
                        if (!this.didNotifyLeader) {
                            try {
                                HANotifyReleaseTimeRequest resp = new HANotifyReleaseTimeRequest(this.serviceId, 0L, 0L, InnerJournalTransactionService.this.nextTimestamp(), true, this.req.getNewCommitCounter(), this.req.getNewCommitTime());
                                log.warn((Object)("Sending mock response for gather protocol: cause=" + t));
                                this.leader.notifyEarliestCommitTime(resp);
                            }
                            catch (Throwable t2) {
                                log.error((Object)t2, t2);
                            }
                        }
                        throw new Exception(t);
                    }
                }
            }

            private void preconditionTest() {
                long token = this.req.token();
                Journal.this.getQuorum().assertQuorum(token);
                Journal.this.assertHAReady(token);
                QuorumService<HAGlue> quorumService = Journal.this.getQuorum().getClient();
                if (!quorumService.isFollower(token)) {
                    throw new QuorumException();
                }
                long localCommitCounter = Journal.this.getRootBlockView().getCommitCounter();
                if (this.req.getNewCommitCounter() != localCommitCounter + 1L) {
                    throw new RuntimeException("leader is preparing for commitCounter=" + this.req.getNewCommitCounter() + ", but follower is at localCommitCounter=" + localCommitCounter);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private IHANotifyReleaseTimeResponse doRunWithBarrierLock() throws Exception {
                IHANotifyReleaseTimeRequest req2 = InnerJournalTransactionService.this.newHANotifyReleaseTimeRequest(this.serviceId, this.req.getNewCommitCounter(), this.req.getNewCommitTime());
                this.didNotifyLeader = true;
                IHANotifyReleaseTimeResponse consensusReleaseTime = this.leader.notifyEarliestCommitTime(req2);
                InnerJournalTransactionService.this.lock.lock();
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Validating consensus releaseTime on follower: consensus=" + consensusReleaseTime));
                    }
                    AbstractTransactionService.TxState txState = InnerJournalTransactionService.this.getEarliestActiveTx();
                    long t2 = consensusReleaseTime.getCommitTime();
                    if (txState != null && txState.getReadsOnCommitTime() < t2) {
                        throw new AssertionError((Object)("The releaseTime consensus would release a commit point with active readers: consensus=" + consensusReleaseTime + ", earliestActiveTx=" + txState));
                    }
                    long newReleaseTime = Math.max(0L, consensusReleaseTime.getCommitTime() - 1L);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Advancing releaseTime on follower: " + newReleaseTime));
                    }
                    InnerJournalTransactionService.this.setReleaseTime(newReleaseTime);
                }
                finally {
                    InnerJournalTransactionService.this.lock.unlock();
                }
                return consensusReleaseTime;
            }
        }
    }

    private class BarrierState
    implements Runnable {
        private final long token;
        private final long newCommitCounter;
        private final long newCommitTime;
        private final QuorumService<HAGlue> quorumService;
        private final UUID[] joinedServiceIds;
        private final CyclicBarrier barrier;
        private final long timestampOnLeader;
        private final UUID leaderId;
        private final IHANotifyReleaseTimeRequest leadersValue;
        volatile Throwable cause = null;
        private final Map<UUID, IHANotifyReleaseTimeRequest> followerResponses = new ConcurrentHashMap<UUID, IHANotifyReleaseTimeRequest>();
        private IHANotifyReleaseTimeRequest minimumResponse = null;
        protected volatile IHANotifyReleaseTimeResponse consensus = null;

        private HATXSGlue getService(UUID serviceId) {
            return (HATXSGlue)this.quorumService.getService(serviceId);
        }

        public BarrierState(long newCommitCounter, long newCommitTime, UUID[] joinedServiceIds) {
            this.token = Journal.this.getQuorum().token();
            this.newCommitCounter = newCommitCounter;
            this.newCommitTime = newCommitTime;
            Journal.this.getQuorum().assertLeader(this.token);
            this.quorumService = Journal.this.getQuorum().getClient();
            this.joinedServiceIds = joinedServiceIds;
            this.leaderId = this.quorumService.getServiceId();
            this.leadersValue = ((InnerJournalTransactionService)Journal.this.getTransactionService()).newHANotifyReleaseTimeRequest(this.leaderId, newCommitCounter, newCommitTime);
            this.timestampOnLeader = this.leadersValue.getTimestamp();
            int nparties = joinedServiceIds.length;
            this.barrier = new CyclicBarrier(nparties, this);
        }

        @Override
        public void run() {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("leader: " + this.leadersValue));
                }
                long timeLeader = this.leadersValue.getTimestamp();
                long timeNow = Journal.this.newConsensusProtocolTimestamp();
                this.minimumResponse = this.leadersValue;
                for (IHANotifyReleaseTimeRequest response : this.followerResponses.values()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("follower: " + response));
                    }
                    if (response.isMock()) {
                        log.warn((Object)("Ignoring mock response: " + response));
                        continue;
                    }
                    UUID followerId = response.getServiceUUID();
                    if (this.minimumResponse.getPinnedCommitCounter() > response.getPinnedCommitCounter()) {
                        this.minimumResponse = response;
                    }
                    Journal.this.assertBefore(this.leaderId, followerId, timeLeader, response.getTimestamp());
                    Journal.this.assertBefore(followerId, this.leaderId, response.getTimestamp(), timeNow);
                }
                this.consensus = new HANotifyReleaseTimeResponse(this.minimumResponse.getPinnedCommitTime(), this.minimumResponse.getPinnedCommitCounter());
                if (log.isInfoEnabled()) {
                    log.info((Object)("consensus: " + this.consensus));
                }
            }
            catch (Throwable t) {
                this.cause = t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void messageFollowers(final long token, long timeoutNanos) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException {
            long nanos;
            long begin = System.nanoTime();
            long remaining = nanos = timeoutNanos;
            Journal.this.getQuorum().assertLeader(token);
            final LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
            try {
                void var13_9;
                HAGatherReleaseTimeRequest msg = new HAGatherReleaseTimeRequest(token, this.timestampOnLeader, this.leaderId, this.newCommitCounter, this.newCommitTime);
                boolean bl = true;
                while (var13_9 < this.joinedServiceIds.length) {
                    UUID serviceId = this.joinedServiceIds[var13_9];
                    futures.add(Journal.this.getExecutorService().submit(new StartGatherOnFollowerTask(serviceId, msg)));
                    ++var13_9;
                }
                final Quorum<HAGlue, QuorumService<HAGlue>> quorum = Journal.this.getQuorum();
                long initialDelay = 100L;
                long delay = 100L;
                ScheduledFuture<?> scheduledFuture = Journal.this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            quorum.assertLeader(token);
                            if (Journal.this.getHAStatus() != HAStatusEnum.Leader) {
                                throw new QuorumException();
                            }
                            BarrierState.this.assertServicesStillJoined(quorum);
                            for (Future f : futures) {
                                if (!f.isDone()) continue;
                                f.get();
                            }
                        }
                        catch (Throwable ex) {
                            if (InnerCause.isInnerCause(ex, InterruptedException.class)) {
                                return;
                            }
                            BarrierState.this.logErrorAndResetBarrier(ex);
                        }
                    }
                }, 100L, 100L, TimeUnit.MILLISECONDS);
                remaining = nanos - (System.nanoTime() - begin);
                try {
                    this.barrier.await(remaining, TimeUnit.NANOSECONDS);
                }
                finally {
                    scheduledFuture.cancel(true);
                }
            }
            finally {
                for (Future future : futures) {
                    boolean done = false;
                    try {
                        future.get(10L, TimeUnit.MILLISECONDS);
                        done = true;
                    }
                    catch (Exception ex) {
                    }
                    finally {
                        if (!done) {
                            future.cancel(true);
                        }
                    }
                    try {
                        future.get();
                    }
                    catch (CancellationException e) {
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)e);
                    }
                    catch (ExecutionException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
                if (this.consensus == null) {
                    log.error((Object)"Forcing barrier break");
                    this.barrier.reset();
                }
            }
        }

        private void logErrorAndResetBarrier(Throwable ex) {
            log.error((Object)ex, ex);
            if (!this.barrier.isBroken()) {
                log.error((Object)"Forcing barrier break");
                this.barrier.reset();
            }
        }

        private void assertServicesStillJoined(Quorum<HAGlue, QuorumService<HAGlue>> quorum) throws QuorumException {
            UUID[] tmp = quorum.getJoined();
            for (UUID serviceId : this.joinedServiceIds) {
                boolean found = false;
                for (UUID t : tmp) {
                    if (!serviceId.equals(t)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new QuorumException("Service leave during consensus protocol: " + serviceId);
            }
        }

        private final class StartGatherOnFollowerTask
        implements Callable<Void> {
            private final UUID serviceId;
            private final IHAGatherReleaseTimeRequest msg;

            public StartGatherOnFollowerTask(UUID serviceId, IHAGatherReleaseTimeRequest msg) {
                this.serviceId = serviceId;
                this.msg = msg;
            }

            @Override
            public Void call() throws Exception {
                HATXSGlue service = BarrierState.this.getService(this.serviceId);
                service.gatherMinimumVisibleCommitTime(this.msg);
                return null;
            }
        }
    }

    public static interface Options
    extends com.bigdata.journal.Options,
    ConcurrencyManager.Options,
    TemporaryStoreFactory.Options,
    QueueStatsPlugIn.Options,
    PlatformStatsPlugIn.Options,
    HttpPlugin.Options {
        public static final String GROUP_COMMIT = Journal.class.getName() + ".groupCommit";
        public static final String DEFAULT_GROUP_COMMIT = "false";
        public static final String LOCATOR_CACHE_CAPACITY = Journal.class.getName() + ".locatorCacheCapacity";
        public static final String DEFAULT_LOCATOR_CACHE_CAPACITY = "20";
        public static final String LOCATOR_CACHE_TIMEOUT = Journal.class.getName() + ".locatorCacheTimeout";
        public static final String DEFAULT_LOCATOR_CACHE_TIMEOUT = "60000";
        public static final String READ_POOL_SIZE = Journal.class.getName() + ".readPoolSize";
        public static final String DEFAULT_READ_POOL_SIZE = "0";
    }
}

