/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.counters.CounterSet;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumRead;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.msg.HARebuildRequest;
import com.bigdata.ha.msg.IHALogRequest;
import com.bigdata.ha.msg.IHARebuildRequest;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.writecache.WriteCacheService;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.FileMetadata;
import com.bigdata.journal.ForceEnum;
import com.bigdata.journal.IBufferStrategy;
import com.bigdata.journal.ICommitter;
import com.bigdata.journal.IHABufferStrategy;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RWAddressManager;
import com.bigdata.journal.StoreState;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumException;
import com.bigdata.rawstore.AbstractRawStore;
import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rwstore.IRWStrategy;
import com.bigdata.rwstore.IRawTx;
import com.bigdata.rwstore.RWStore;
import com.bigdata.util.ChecksumError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class RWStrategy
extends AbstractRawStore
implements IBufferStrategy,
IHABufferStrategy,
IRWStrategy {
    private static final transient Logger log = Logger.getLogger(RWStrategy.class);
    private final IAddressManager m_am;
    private final RWStore m_store;
    private final UUID m_uuid;
    private final long m_initialExtent;
    private final Quorum<?, ?> m_quorum;

    RWStrategy(FileMetadata fileMetadata, Quorum<?, ?> quorum) {
        if (fileMetadata == null) {
            throw new IllegalArgumentException();
        }
        this.m_uuid = fileMetadata.rootBlock.getUUID();
        this.m_quorum = quorum;
        this.m_store = new RWStore(fileMetadata, quorum);
        this.m_am = new RWAddressManager(this.m_store);
        this.m_initialExtent = fileMetadata.file.length();
    }

    @Override
    public ByteBuffer readRootBlock(boolean rootBlock0) {
        return this.m_store.readRootBlock(rootBlock0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(long addr) {
        try {
            return this.readFromLocalStore(addr);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ChecksumError e) {
            try {
                log.error((Object)(e + " : addr=" + this.toString(addr)), (Throwable)e);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            RWStore.StoreCounters c = (RWStore.StoreCounters)this.m_store.getStoreCounters().acquire();
            try {
                ++c.checksumErrorCount;
            }
            finally {
                c.release();
            }
            if (this.m_quorum != null && this.m_quorum.isHighlyAvailable() && this.m_quorum.isQuorumMet()) {
                try {
                    byte[] a = ((QuorumRead)((Object)this.m_quorum.getMember())).readFromQuorum(this.m_uuid, addr);
                    return ByteBuffer.wrap(a);
                }
                catch (Throwable t) {
                    throw new RuntimeException("While handling: " + e, t);
                }
            }
            throw e;
        }
    }

    @Override
    public long write(ByteBuffer data) {
        return this.write(data, null);
    }

    @Override
    public long write(ByteBuffer data, IAllocationContext context) {
        if (data == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (data.hasArray() && data.arrayOffset() != 0) {
            throw new AssertionError();
        }
        int nbytes = data.remaining();
        if (nbytes == 0) {
            throw new IllegalArgumentException("Zero bytes remaining in buffer");
        }
        long rwaddr = this.m_store.alloc(data.array(), nbytes, context);
        data.position(nbytes);
        long retaddr = this.encodeAddr(rwaddr, nbytes);
        return retaddr;
    }

    private long encodeAddr(long alloc, int nbytes) {
        alloc <<= 32;
        return alloc += (long)nbytes;
    }

    private int decodeAddr(long addr) {
        return (int)(addr >>= 32);
    }

    private int decodeSize(long addr) {
        return (int)(addr & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void delete(long addr) {
        this.delete(addr, null);
    }

    @Override
    public void delete(long addr, IAllocationContext context) {
        int rwaddr = this.decodeAddr(addr);
        int sze = this.decodeSize(addr);
        if ((long)rwaddr == 0L) {
            throw new IllegalArgumentException("Address is 0L");
        }
        if (sze == 0) {
            throw new IllegalArgumentException("Bad record size");
        }
        this.m_store.free(rwaddr, sze, context);
    }

    @Override
    public void detachContext(IAllocationContext context) {
        this.m_store.detachContext(context);
    }

    @Override
    public void abortContext(IAllocationContext context) {
        this.m_store.abortContext(context);
    }

    @Override
    public void closeForWrites() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BufferMode getBufferMode() {
        return BufferMode.DiskRW;
    }

    @Override
    public CounterSet getCounters() {
        return this.m_store.getCounters();
    }

    @Override
    public long getExtent() {
        return this.m_store.getStoreFile().length();
    }

    @Override
    public int getHeaderSize() {
        return 688;
    }

    @Override
    public long getInitialExtent() {
        return this.m_initialExtent;
    }

    @Override
    public long getMaximumExtent() {
        return 0L;
    }

    @Override
    public boolean useChecksums() {
        return true;
    }

    @Override
    public long getNextOffset() {
        return this.m_store.getNextOffset();
    }

    @Override
    public long getUserExtent() {
        return this.m_store.getFileStorage();
    }

    @Override
    public long transferTo(RandomAccessFile out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void truncate(long extent) {
        this.m_store.establishExtent(extent);
    }

    @Override
    public void writeRootBlock(IRootBlockView rootBlock, ForceEnum forceOnCommit) {
        this.m_store.writeRootBlock(rootBlock, forceOnCommit);
    }

    private void assertOpen() {
        if (!this.m_store.isOpen()) {
            throw new IllegalStateException("Not open");
        }
    }

    @Override
    public void close() {
        this.assertOpen();
        this.m_store.close();
    }

    @Override
    public void deleteResources() {
        if (this.m_store.isOpen()) {
            throw new IllegalStateException("Open");
        }
        File file = this.m_store.getStoreFile();
        if (file.exists() && !file.delete()) {
            log.warn((Object)("Unable to delete file: " + file));
        }
    }

    @Override
    public void destroy() {
        this.m_store.close();
        this.deleteResources();
    }

    @Override
    public void commit() {
        this.m_store.commit();
    }

    @Override
    public void abort() {
        this.m_store.reset();
    }

    @Override
    public void force(boolean metadata) {
        try {
            this.m_store.flushWrites(metadata);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public File getFile() {
        return this.m_store.getStoreFile();
    }

    @Override
    public IResourceMetadata getResourceMetadata() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UUID getUUID() {
        return this.m_uuid;
    }

    @Override
    public boolean isFullyBuffered() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.m_store.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public long size() {
        return this.m_store.getFileStorage();
    }

    @Override
    public IAddressManager getAddressManager() {
        return this.m_am;
    }

    @Override
    public int getByteCount(long addr) {
        return this.m_am.getByteCount(addr);
    }

    @Override
    public long getOffset(long addr) {
        return this.m_am.getOffset(addr);
    }

    @Override
    public long toAddr(int nbytes, long offset) {
        return this.m_am.toAddr(nbytes, offset);
    }

    @Override
    public String toString(long addr) {
        return this.m_am.toString(addr);
    }

    @Override
    public boolean requiresCommit(IRootBlockView block) {
        return this.m_store.requiresCommit();
    }

    @Override
    public boolean isDirty() {
        return this.m_store.requiresCommit();
    }

    @Override
    public long getMetaBitsAddr() {
        return this.m_store.getMetaBitsAddr();
    }

    @Override
    public long getMetaStartAddr() {
        return this.m_store.getMetaStartAddr();
    }

    @Override
    public int getMaxRecordSize() {
        return this.m_store.getMaxAllocSize() - 4;
    }

    @Override
    public int getOffsetBits() {
        return 0;
    }

    @Override
    public RWStore getStore() {
        return this.m_store;
    }

    @Override
    public long getPhysicalAddress(long addr) {
        int rwaddr = this.decodeAddr(addr);
        return this.m_store.physicalAddress(rwaddr);
    }

    @Override
    public void writeRawBuffer(IHAWriteMessage msg, IBufferAccess b) throws IOException, InterruptedException {
        this.m_store.writeRawBuffer(msg, b);
    }

    @Override
    public Future<Void> sendHALogBuffer(IHALogRequest req, IHAWriteMessage msg, IBufferAccess b) throws IOException, InterruptedException {
        return this.m_store.sendHALogBuffer(req, msg, b);
    }

    @Override
    public Future<Void> sendRawBuffer(IHARebuildRequest req, long sequence, long quorumToken, long fileExtent, long offset, int nbytes, ByteBuffer b) throws IOException, InterruptedException {
        return this.m_store.sendRawBuffer(req, sequence, quorumToken, fileExtent, offset, nbytes, b);
    }

    @Override
    public void writeOnStream(OutputStream os, AbstractJournal.ISnapshotData snapshotData, Quorum<HAGlue, QuorumService<HAGlue>> quorum, long token) throws IOException, QuorumException {
        try {
            this.m_store.writeOnStream(os, snapshotData, quorum, token);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object snapshotAllocators() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void computeDigest(Object snapshot, MessageDigest digest) throws DigestException, IOException {
        this.m_store.computeDigest(snapshot, digest);
    }

    @Override
    public ByteBuffer readFromLocalStore(long addr) throws InterruptedException {
        int rwaddr = this.decodeAddr(addr);
        int sze = this.decodeSize(addr);
        if ((long)rwaddr == 0L) {
            throw new IllegalArgumentException("Address is 0L");
        }
        if (sze == 0) {
            throw new IllegalArgumentException("Bad record size");
        }
        return this.m_store.getData((long)rwaddr, sze);
    }

    @Override
    public void setExtentForLocalStore(long extent) throws IOException, InterruptedException {
        this.m_store.establishExtent(extent);
    }

    public boolean lockAddress(long addr) {
        this.m_store.lockAddress(this.decodeAddr(addr));
        return true;
    }

    @Override
    public long getLastReleaseTime() {
        return this.m_store.getLastReleaseTime();
    }

    @Override
    public int checkDeferredFrees(AbstractJournal journal) {
        int totalFreed = this.m_store.checkDeferredFrees(journal);
        if (totalFreed > 0 && log.isInfoEnabled()) {
            log.info((Object)("Freed " + totalFreed + " deferralls on commit"));
        }
        return totalFreed;
    }

    @Override
    public boolean isCommitted(long addr) {
        return this.m_store.isCommitted(this.decodeAddr(addr));
    }

    public boolean inWriteCache(long addr) {
        return this.m_store.inWriteCache(this.decodeAddr(addr));
    }

    @Override
    public IRawTx newTx() {
        return this.m_store.newTx();
    }

    @Override
    public void registerContext(IAllocationContext context) {
        this.m_store.registerContext(context);
    }

    @Override
    public void registerExternalCache(ConcurrentWeakValueCache<Long, ICommitter> historicalIndexCache, int byteCount) {
        this.m_store.registerExternalCache(historicalIndexCache, byteCount);
    }

    @Override
    public long saveDeferrals() {
        return this.m_store.saveDeferrals();
    }

    @Override
    public InputStream getInputStream(long addr) {
        return this.m_store.getInputStream(addr);
    }

    @Override
    public IPSOutputStream getOutputStream() {
        return this.m_store.getOutputStream();
    }

    @Override
    public IPSOutputStream getOutputStream(IAllocationContext context) {
        return this.m_store.getOutputStream(context);
    }

    @Override
    public void resetFromHARootBlock(IRootBlockView rootBlock) {
        this.m_store.resetFromHARootBlock(rootBlock);
    }

    @Override
    public long getBlockSequence() {
        return this.m_store.getBlockSequence();
    }

    @Override
    public long getCurrentBlockSequence() {
        return this.m_store.getCurrentBlockSequence();
    }

    @Override
    public ByteBuffer readRaw(long position, ByteBuffer transfer) {
        return this.m_store.readRaw(position, transfer);
    }

    @Override
    public void writeRawBuffer(HARebuildRequest req, IHAWriteMessage msg, ByteBuffer transfer) throws IOException {
        if (req == null) {
            throw new IllegalArgumentException();
        }
        this.m_store.writeRaw(msg.getFirstOffset(), transfer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Transfer rebuild: " + msg.getSequence() + ", address: " + msg.getFirstOffset()));
        }
    }

    @Override
    public Lock getCommitLock() {
        return this.m_store.getCommitLock();
    }

    @Override
    public void postCommit() {
        this.m_store.postCommit();
    }

    @Override
    public void postHACommit(IRootBlockView rootBlock) {
        this.m_store.postHACommit(rootBlock);
    }

    @Override
    public WriteCacheService getWriteCacheService() {
        return this.m_store.getWriteCacheService();
    }

    @Override
    public StoreState getStoreState() {
        return this.m_store.getStoreState();
    }
}

