/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IReopenChannel;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockException;
import com.bigdata.journal.RootBlockView;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.util.ChecksumUtility;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import org.apache.log4j.Logger;

public class RootBlockUtility {
    private static final Logger log = Logger.getLogger(RootBlockUtility.class);
    public final IRootBlockView rootBlock0;
    public final IRootBlockView rootBlock1;
    public final IRootBlockView rootBlock;

    public RootBlockUtility(IReopenChannel<FileChannel> opener, File file, boolean validateChecksum, boolean alternateRootBlock, boolean ignoreBadRootBlock) throws IOException {
        ChecksumUtility checker = validateChecksum ? ChecksumUtility.threadChk.get() : null;
        ByteBuffer tmp0 = ByteBuffer.allocate(340);
        ByteBuffer tmp1 = ByteBuffer.allocate(340);
        FileChannelUtility.readAll(opener, tmp0, 8L);
        FileChannelUtility.readAll(opener, tmp1, 348L);
        tmp0.position(0);
        tmp1.position(0);
        RootBlockView rootBlock0 = null;
        RootBlockView rootBlock1 = null;
        try {
            rootBlock0 = new RootBlockView(true, tmp0, checker);
            if (log.isInfoEnabled()) {
                log.info((Object)("rootBlock0: " + rootBlock0));
            }
        }
        catch (RootBlockException ex) {
            log.error((Object)("Bad root block zero: " + ex));
        }
        try {
            rootBlock1 = new RootBlockView(false, tmp1, checker);
            if (log.isInfoEnabled()) {
                log.info((Object)("rootBlock1: " + rootBlock1));
            }
        }
        catch (RootBlockException ex) {
            log.error((Object)("Bad root block one: " + ex));
        }
        if (rootBlock0 == null && rootBlock1 == null) {
            throw new RuntimeException("Both root blocks are bad - journal is not usable: " + file);
        }
        this.rootBlock0 = rootBlock0;
        this.rootBlock1 = rootBlock1;
        this.rootBlock = RootBlockUtility.chooseRootBlock(rootBlock0, rootBlock1, ignoreBadRootBlock, alternateRootBlock);
    }

    public RootBlockUtility(IRootBlockView rb0, IRootBlockView rb1) {
        this.rootBlock0 = rb0;
        this.rootBlock1 = rb1;
        this.rootBlock = RootBlockUtility.chooseRootBlock(this.rootBlock0, this.rootBlock1, false, false);
    }

    public static IRootBlockView chooseRootBlock(IRootBlockView rootBlock0, IRootBlockView rootBlock1) {
        return RootBlockUtility.chooseRootBlock(rootBlock0, rootBlock1, false, false);
    }

    public IRootBlockView chooseRootBlock() {
        return RootBlockUtility.chooseRootBlock(this.rootBlock0, this.rootBlock1, false, false);
    }

    public static IRootBlockView chooseRootBlock(IRootBlockView rootBlock0, IRootBlockView rootBlock1, boolean alternateRootBlock, boolean ignoreBadRootBlock) {
        IRootBlockView rootBlock;
        long cc1;
        if (!(ignoreBadRootBlock || rootBlock0 != null && rootBlock1 != null)) {
            throw new RuntimeException("Bad root block(s): rootBlock0 is " + (rootBlock0 == null ? "bad" : "ok") + ", rootBlock1=" + (rootBlock1 == null ? "bad" : "ok"));
        }
        if (alternateRootBlock) {
            if (rootBlock0 == null || rootBlock1 == null) {
                throw new RuntimeException("Can not use alternative root block since one root block is damaged.");
            }
            log.warn((Object)"Using alternate root block");
        }
        long cc0 = rootBlock0 == null ? -1L : rootBlock0.getCommitCounter();
        long l = cc1 = rootBlock1 == null ? -1L : rootBlock1.getCommitCounter();
        if (rootBlock0 == null) {
            rootBlock = rootBlock1;
        } else if (rootBlock1 == null) {
            rootBlock = rootBlock0;
        } else {
            IRootBlockView iRootBlockView = cc0 > cc1 ? (alternateRootBlock ? rootBlock1 : rootBlock0) : (rootBlock = alternateRootBlock ? rootBlock0 : rootBlock1);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("chosenRoot: " + rootBlock));
        }
        return rootBlock;
    }

    public RootBlockUtility(BufferMode bufferMode, int offsetBits, long createTime, long quorumToken, UUID storeUUID) {
        if (bufferMode == null) {
            throw new IllegalArgumentException("BufferMode is required.");
        }
        if (createTime == 0L) {
            throw new IllegalArgumentException("Create time may not be zero.");
        }
        if (storeUUID == null) {
            throw new IllegalArgumentException("Store UUID is required.");
        }
        ChecksumUtility checker = ChecksumUtility.threadChk.get();
        long nextOffset = 0L;
        long closeTime = 0L;
        long commitCounter = 0L;
        long firstCommitTime = 0L;
        long lastCommitTime = 0L;
        long commitRecordAddr = 0L;
        long commitRecordIndexAddr = 0L;
        StoreTypeEnum stenum = bufferMode.getStoreType();
        long blockSequence = 0L;
        this.rootBlock0 = new RootBlockView(true, offsetBits, 0L, 0L, 0L, 0L, 0L, 0L, storeUUID, 0L, quorumToken, 0L, 0L, stenum, createTime, 0L, 3, checker);
        this.rootBlock1 = new RootBlockView(false, offsetBits, 0L, 0L, 0L, 0L, 0L, 0L, storeUUID, 0L, quorumToken, 0L, 0L, stenum, createTime, 0L, 3, checker);
        this.rootBlock = this.rootBlock0;
    }

    public static void main(String[] args) throws IOException {
        File file;
        if (args.length == 0) {
            System.err.println("usage: <filename>");
            System.exit(1);
        }
        if (!(file = new File(args[0])).exists()) {
            System.err.println("Not found: " + file);
            System.exit(1);
        }
        IReopenChannel<FileChannel> opener = new IReopenChannel<FileChannel>(){
            private static final String fileMode = "r";
            private RandomAccessFile raf = null;

            @Override
            public String toString() {
                return file.toString();
            }

            @Override
            public FileChannel reopenChannel() throws IOException {
                if (this.raf != null && this.raf.getChannel().isOpen()) {
                    return this.raf.getChannel();
                }
                this.raf = new RandomAccessFile(file, fileMode);
                return this.raf.getChannel();
            }
        };
        boolean validateChecksum = true;
        boolean alternateRootBlock = false;
        boolean ignoreBadRootBlock = true;
        RootBlockUtility u = new RootBlockUtility(opener, file, true, false, true);
        System.out.println("rootBlock0: " + u.rootBlock0);
        System.out.println("rootBlock1: " + u.rootBlock1);
        System.out.println("Current root block is rootBlock" + (u.rootBlock == u.rootBlock0 ? "0" : "1"));
    }
}

