/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.LRUNexus;
import com.bigdata.counters.CounterSet;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.DiskOnlyStrategy;
import com.bigdata.journal.FileMetadata;
import com.bigdata.journal.ForceEnum;
import com.bigdata.mdi.AbstractResourceMetadata;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.rawstore.AbstractRawWormStore;
import com.bigdata.rawstore.IMRMW;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class TemporaryRawStore
extends AbstractRawWormStore
implements IMRMW {
    private static final Logger log = Logger.getLogger(TemporaryRawStore.class);
    private final DiskOnlyStrategy buf;
    private final UUID uuid = UUID.randomUUID();
    private final long createTime;
    static final AtomicInteger nopen = new AtomicInteger();
    static final AtomicInteger nclose = new AtomicInteger();

    protected static File getTempFile() {
        try {
            File file = File.createTempFile("bigdata", ".tmp");
            file.deleteOnExit();
            return file;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static File getTempFile(File tmpDir) {
        try {
            if (tmpDir.exists() || !tmpDir.mkdirs()) {
                // empty if block
            }
            File file = File.createTempFile("bigdata", ".tmp", tmpDir);
            file.deleteOnExit();
            return file;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final UUID getUUID() {
        return this.uuid;
    }

    public TemporaryRawStore() {
        this(42);
    }

    public TemporaryRawStore(int offsetBits) {
        this(0L, offsetBits, TemporaryRawStore.getTempFile());
    }

    public TemporaryRawStore(long maximumExtent, int offsetBits, File file) {
        super(offsetBits);
        long initialExtent;
        if (log.isInfoEnabled()) {
            log.info((Object)("offsetBits=" + offsetBits + ", file=" + file));
        }
        this.createTime = System.currentTimeMillis();
        long overflowExtent = initialExtent = (long)DirectBufferPool.INSTANCE.getBufferCapacity();
        FileMetadata md = new FileMetadata(file, BufferMode.Temporary, false, initialExtent, overflowExtent, true, true, true, false, ForceEnum.No, offsetBits, true, 3, false, this.createTime, -1L, false, null);
        this.buf = new DiskOnlyStrategy(maximumExtent, md);
        nopen.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            DiskOnlyStrategy diskOnlyStrategy = this.buf;
            synchronized (diskOnlyStrategy) {
                if (this.buf.isOpen()) {
                    this.close();
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Finalized temp store");
                    }
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)("Ignoring: " + t), t);
        }
        super.finalize();
    }

    public String toString() {
        return this.getClass().getName() + "{file=" + this.getFile() + "}";
    }

    @Override
    public final File getFile() {
        return this.buf.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DiskOnlyStrategy diskOnlyStrategy = this.buf;
        synchronized (diskOnlyStrategy) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Closing temp store");
            }
            try {
                if (!this.buf.isOpen()) {
                    throw new IllegalStateException();
                }
                this.buf.destroy();
                nclose.incrementAndGet();
            }
            finally {
                if (LRUNexus.INSTANCE != null) {
                    try {
                        LRUNexus.INSTANCE.deleteCache(this.getUUID());
                    }
                    catch (Throwable t) {
                        log.error((Object)t, t);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteResources() {
        DiskOnlyStrategy diskOnlyStrategy = this.buf;
        synchronized (diskOnlyStrategy) {
            if (this.buf.isOpen()) {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public final IResourceMetadata getResourceMetadata() {
        File file = this.buf.getFile();
        String fileStr = file == null ? "" : file.toString();
        return new ResourceMetadata(this, fileStr);
    }

    public final DiskOnlyStrategy getBufferStrategy() {
        return this.buf;
    }

    @Override
    public final void destroy() {
        if (this.isOpen()) {
            this.close();
        }
    }

    @Override
    public final void force(boolean metadata) {
        this.buf.force(metadata);
    }

    @Override
    public final long size() {
        return this.buf.size();
    }

    protected final void assertOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public final boolean isOpen() {
        return this.buf.isOpen();
    }

    @Override
    public final boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    @Override
    public final boolean isStable() {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        return false;
    }

    @Override
    public final boolean isFullyBuffered() {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        return false;
    }

    @Override
    public final ByteBuffer read(long addr) {
        return this.buf.read(addr);
    }

    @Override
    public final long write(ByteBuffer data) {
        return this.buf.write(data);
    }

    public final int getMaxRecordSize() {
        return this.buf.getAddressManager().getMaxByteCount();
    }

    @Override
    public CounterSet getCounters() {
        return this.buf.getCounters();
    }

    @Override
    public void delete(long addr) {
    }

    static final class ResourceMetadata
    extends AbstractResourceMetadata {
        private static final long serialVersionUID = 1L;

        public ResourceMetadata() {
        }

        public ResourceMetadata(TemporaryRawStore store, String fileStr) {
            super(fileStr, store.uuid, store.createTime, 0L);
        }

        @Override
        public boolean isJournal() {
            return false;
        }

        @Override
        public boolean isIndexSegment() {
            return false;
        }
    }
}

