/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.concurrent.NonBlockingLockManagerWithNewDesign;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.CommitException;
import com.bigdata.journal.IResourceManager;
import com.bigdata.journal.ITask;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.journal.ValidationError;
import com.bigdata.resources.OverflowManager;
import com.bigdata.resources.StaleLocatorException;
import com.bigdata.service.DataService;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.WriteTaskCounters;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class WriteExecutorService
extends ThreadPoolExecutor {
    private static final Logger log = Logger.getLogger(WriteExecutorService.class);
    protected static final Logger overflowLog = Logger.getLogger(OverflowManager.class);
    final boolean trackActiveSetInMDC = false;
    private final WeakReference<IResourceManager> resourceManagerRef;
    private final String serviceName;
    private final NonBlockingLockManagerWithNewDesign<String> lockManager;
    protected final long groupCommitTimeout;
    protected final long overflowLockRequestTimeout;
    private final AtomicInteger paused = new AtomicInteger();
    private final ReentrantLock exclusiveLock = new ReentrantLock();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition unpaused = this.lock.newCondition();
    private final Condition waiting = this.lock.newCondition();
    private final Condition commit = this.lock.newCondition();
    private final AtomicLong rejectedExecutionCount = new AtomicLong();
    private final AtomicInteger nrunning = new AtomicInteger(0);
    private final AtomicInteger nready = new AtomicInteger(0);
    private final ConcurrentHashMap<Thread, AbstractTask<?>> active = new ConcurrentHashMap();
    private final Map<Thread, AbstractTask<?>> commitGroup = new LinkedHashMap();
    private final AtomicInteger nwrites = new AtomicInteger(0);
    private final AtomicBoolean groupCommit = new AtomicBoolean(false);
    private final AtomicBoolean abort = new AtomicBoolean(false);
    private final AtomicReference<Throwable> firstCauseRef = new AtomicReference();
    private int maxPoolSize = 0;
    private long maxRunning = 0L;
    private long maxCommitWaitingTime = 0L;
    private long maxCommitServiceTime = 0L;
    private int maxCommitGroupSize = 0;
    private int commitGroupSize = 0;
    private long byteCountPerCommit = 0L;
    private AtomicLong ngroupCommits = new AtomicLong();
    private long naborts = 0L;
    private long failedTaskCount = 0L;
    private long successTaskCount = 0L;
    private long committedTaskCount = 0L;
    private long noverflow = 0L;
    protected final AtomicInteger activeTaskCountWithLocksHeld = new AtomicInteger(0);

    public NonBlockingLockManagerWithNewDesign<String> getLockManager() {
        return this.lockManager;
    }

    public WriteExecutorService(IResourceManager resourceManager, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit keepAliveUnit, BlockingQueue<Runnable> queue, ThreadFactory threadFactory, long groupCommitTimeout, long overflowLockRequestTimeout) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, keepAliveUnit, queue, threadFactory);
        String serviceName;
        if (resourceManager == null) {
            throw new IllegalArgumentException();
        }
        if (groupCommitTimeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (overflowLockRequestTimeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.groupCommitTimeout = groupCommitTimeout;
        this.overflowLockRequestTimeout = overflowLockRequestTimeout;
        this.lockManager = new MyLockManager<String>(maximumPoolSize, 3, true, this);
        this.resourceManagerRef = new WeakReference<IResourceManager>(resourceManager);
        this.setRejectedExecutionHandler(new MyRejectedExecutionHandler(this.rejectedExecutionCount));
        try {
            DataService dataService = resourceManager.getDataService();
            serviceName = dataService.getServiceName();
        }
        catch (UnsupportedOperationException ex) {
            serviceName = "";
        }
        this.serviceName = serviceName;
    }

    public long getRejectedExecutionCount() {
        return this.rejectedExecutionCount.get();
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getMaxRunning() {
        return this.maxRunning;
    }

    public long getMaxCommitWaitingTime() {
        return this.maxCommitWaitingTime;
    }

    public long getMaxCommitServiceTime() {
        return this.maxCommitServiceTime;
    }

    public int getInternalLockQueueLength() {
        return this.lock.getQueueLength();
    }

    public int getCommitGroupSize() {
        return this.commitGroupSize;
    }

    public int getMaxCommitGroupSize() {
        return this.maxCommitGroupSize;
    }

    public long getGroupCommitCount() {
        return this.ngroupCommits.get();
    }

    public long getByteCountPerCommit() {
        return this.byteCountPerCommit;
    }

    public long getAbortCount() {
        return this.naborts;
    }

    public long getTaskFailedCount() {
        return this.failedTaskCount;
    }

    public long getTaskSuccessCount() {
        return this.successTaskCount;
    }

    public long getTaskCommittedCount() {
        return this.committedTaskCount;
    }

    public long getOverflowCount() {
        return this.noverflow;
    }

    public int getActiveTaskCountWithLocksHeld() {
        return this.activeTaskCountWithLocksHeld.get();
    }

    public int getReadyCount() {
        return this.nready.get();
    }

    private boolean isPaused() {
        return this.paused.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause() {
        this.lock.lock();
        try {
            if (this.paused.incrementAndGet() == 0 && log.isDebugEnabled()) {
                log.debug((Object)"Pausing write service");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.lock.lock();
        try {
            if (this.paused.get() == 0) {
                throw new IllegalStateException("Not paused");
            }
            if (this.paused.decrementAndGet() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Resuming write service");
                }
                this.unpaused.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.lock.lock();
        try {
            while (this.isPaused()) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
        finally {
            this.lock.unlock();
        }
        super.beforeExecute(t, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeTask(Thread t, AbstractTask<?> r) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (r == null) {
            throw new NullPointerException();
        }
        this.nready.incrementAndGet();
        this.lock.lock();
        try {
            int nrunning = this.nrunning.incrementAndGet();
            this.maxRunning = (long)nrunning > this.maxRunning ? (long)nrunning : this.maxRunning;
            int poolSize = this.getPoolSize();
            this.maxPoolSize = poolSize > this.maxPoolSize ? poolSize : this.maxPoolSize;
            this.active.put(t, r);
            MDC.put((String)"taskState", (Object)"running");
            MDC.put((String)"commitCounter", (Object)("commitCounter=" + this.ngroupCommits));
            if (log.isInfoEnabled()) {
                log.info((Object)("nrunning=" + nrunning));
            }
        }
        finally {
            this.lock.unlock();
            this.nready.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterTask(AbstractTask<?> r, Throwable t) {
        if (r == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            int nrunning = this.nrunning.decrementAndGet();
            MDC.remove((String)"taskState");
            if (log.isInfoEnabled()) {
                log.info((Object)("nrunning=" + nrunning));
            }
            assert (nrunning >= 0);
            if (t == null) {
                int nwrites = this.nwrites.incrementAndGet();
                assert (nwrites > 0);
                this.commitGroup.put(Thread.currentThread(), r);
                ++this.successTaskCount;
                MDC.put((String)"taskState", (Object)"waitingOnCommit");
                if (!this.groupCommit()) {
                    AbstractJournal journal;
                    IResourceManager rm = this.getResourceManager();
                    AbstractJournal abstractJournal = journal = rm == null ? null : rm.getLiveJournal();
                    if (journal != null && journal.isOpen()) {
                        throw new RuntimeException("Commit failed: " + r, this.firstCauseRef.get());
                    }
                    throw new IllegalStateException("Journal is closed: " + r);
                }
            } else {
                ++this.failedTaskCount;
                MDC.put((String)"taskState", (Object)"failure");
                if (InnerCause.isInnerCause(t, ValidationError.class)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Validation failed: task=" + r));
                    }
                } else if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                    log.warn((Object)("Task interrupted: task=" + r));
                } else if (InnerCause.isInnerCause(t, NoSuchIndexException.class)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("No such index: task=" + r));
                    }
                } else if (InnerCause.isInnerCause(t, StaleLocatorException.class)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Stale locator: task=" + r));
                    }
                } else {
                    log.warn((Object)("Task failed: task=" + r));
                }
            }
        }
        finally {
            ITask tmp = this.active.remove(Thread.currentThread());
            MDC.remove((String)"taskState");
            MDC.remove((String)"commitCounter");
            this.lock.unlock();
            assert (tmp == r) : "Expecting " + r + ", but was " + tmp;
            r.taskCounters.queuingNanoTime.addAndGet(System.nanoTime() - r.nanoTime_submitTask);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WriteExecutorService");
        sb.append("{ paused=" + this.paused);
        sb.append(", nrunning=" + this.nrunning);
        sb.append(", concurrentTaskCount=" + this.activeTaskCountWithLocksHeld);
        sb.append(", activeTaskSetSize=" + this.active.size());
        sb.append(", nwrites=" + this.nwrites);
        sb.append(", groupCommitFlag=" + this.groupCommit);
        sb.append(", abortFlag=" + this.abort);
        sb.append(", lockHeldByCurrentThread=" + this.lock.isHeldByCurrentThread());
        sb.append(", lockHoldCount=" + this.lock.getHoldCount());
        sb.append(", lockQueueLength=" + this.lock.getQueueLength());
        if (this.lock.isHeldByCurrentThread()) {
            sb.append(", lockWaitQueueLength(unpaused)=" + this.lock.getWaitQueueLength(this.unpaused));
            sb.append(", lockWaitQueueLength(waiting)=" + this.lock.getWaitQueueLength(this.waiting));
            sb.append(", lockWaitQueueLength(commit)=" + this.lock.getWaitQueueLength(this.commit));
        }
        sb.append(", activeCount=" + this.getActiveCount());
        sb.append(", queueSize=" + this.getQueue().size());
        sb.append(", poolSize=" + this.getPoolSize());
        sb.append(", largestPoolSize=" + this.getLargestPoolSize());
        sb.append(", maxPoolSize=" + this.maxPoolSize);
        sb.append(", maxRunning=" + this.maxRunning);
        sb.append(", maxCommitLatency=" + this.maxCommitServiceTime);
        sb.append(", maxLatencyUntilCommit=" + this.maxCommitWaitingTime);
        sb.append(", groupCommitCount=" + this.ngroupCommits);
        sb.append(", abortCount=" + this.naborts);
        sb.append(", failedTaskCount=" + this.failedTaskCount);
        sb.append(", successTaskCount=" + this.successTaskCount);
        sb.append(", committedTaskCount=" + this.committedTaskCount);
        sb.append(", overflowCount=" + this.noverflow);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void shutdown() {
        this.lockManager.shutdown();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.lockManager.shutdownNow();
        return super.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean groupCommit() {
        if (WriteExecutorService.log.isDebugEnabled()) {
            WriteExecutorService.log.debug((Object)"begin");
        }
        if (!WriteExecutorService.$assertionsDisabled && !this.lock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        currentThread = Thread.currentThread();
        r = this.active.get(currentThread);
        if (this.abort.get()) {
            if (WriteExecutorService.log.isInfoEnabled()) {
                WriteExecutorService.log.info((Object)"Abort in progress.");
            }
            this.waiting.signalAll();
            throw new RuntimeException("Aborted.");
        }
        if (!this.groupCommit.compareAndSet(false, true)) {
            if (WriteExecutorService.log.isDebugEnabled()) {
                WriteExecutorService.log.debug((Object)"Already executing in another thread");
            }
            this.waiting.signalAll();
            try {
                this.commit.await();
                MDC.put((String)"commitCounter", (Object)("commitCounter=" + this.ngroupCommits));
                return true;
            }
            catch (InterruptedException ex) {
                WriteExecutorService.log.warn((Object)("Task interrupted awaiting group commit: " + r));
                currentThread.interrupt();
                return false;
            }
        }
        rm = this.getResourceManager();
        locked = false;
        try {
            if (!WriteExecutorService.$assertionsDisabled && !this.lock.isHeldByCurrentThread()) {
                throw new AssertionError();
            }
            if (!WriteExecutorService.$assertionsDisabled && !this.groupCommit.get()) {
                throw new AssertionError();
            }
            taskCounters = (WriteTaskCounters)r.getTaskCounters();
            if (!WriteExecutorService.$assertionsDisabled && taskCounters == null) {
                throw new AssertionError();
            }
            nanoTime_beginWait = System.nanoTime();
            if (WriteExecutorService.log.isInfoEnabled()) {
                WriteExecutorService.log.info((Object)("This thread will run group commit: " + currentThread + " : " + r));
            }
            if ((shouldOverflow = this.isShouldOverflow(rm)) && WriteExecutorService.overflowLog.isInfoEnabled()) {
                WriteExecutorService.overflowLog.info((Object)"Should overflow - will try to pause the write service.");
            }
            beginWait = System.currentTimeMillis();
            if (shouldOverflow) {
                try {
                    locked = this.tryLock(this.overflowLockRequestTimeout, TimeUnit.MILLISECONDS);
                    if (locked) ** GOTO lbl54
                    WriteExecutorService.log.error((Object)("Could not obtain exclusive lock: timeout=" + this.overflowLockRequestTimeout + ", service=" + this.serviceName));
                }
                catch (InterruptedException ex) {
                    WriteExecutorService.log.warn((Object)"Interrupted awaiting exclusive write lock.");
                    var12_15 = false;
                    this.groupCommit.set(false);
                    if (locked) {
                        this.unlock();
                    }
                    return var12_15;
                }
            } else {
                this.waitForRunningTasks(this.groupCommitTimeout, TimeUnit.MILLISECONDS);
            }
lbl54:
            // 3 sources

            endWait = System.currentTimeMillis();
            latencyUntilCommit = endWait - beginWait;
            if (latencyUntilCommit > this.maxCommitWaitingTime) {
                this.maxCommitWaitingTime = latencyUntilCommit;
            }
            nwrites = this.nwrites.get();
            if (WriteExecutorService.log.isInfoEnabled()) {
                WriteExecutorService.log.info((Object)("Committing store: commitGroupSize=" + nwrites + ", #running=" + this.nrunning + ", active=" + this.active.entrySet()));
            }
            beginCommit = System.currentTimeMillis();
            taskCounters.commitWaitingNanoTime.addAndGet(System.nanoTime() - nanoTime_beginWait);
            nanoTime_beginCommit = System.nanoTime();
            try {
                if (!this.commit(locked)) {
                    var14_19 = false;
                    return var14_19;
                }
            }
            finally {
                taskCounters.commitServiceNanoTime.addAndGet(System.nanoTime() - nanoTime_beginCommit);
            }
            this.committedTaskCount += (long)nwrites;
            commitLatency = System.currentTimeMillis() - beginCommit;
            if (commitLatency > this.maxCommitServiceTime) {
                this.maxCommitServiceTime = commitLatency;
            }
            this.commitGroupSize = nwrites;
            if (nwrites > this.maxCommitGroupSize) {
                this.maxCommitGroupSize = nwrites;
            }
            if (WriteExecutorService.log.isInfoEnabled()) {
                WriteExecutorService.log.info((Object)("Commit Ok : commitLatency=" + commitLatency + ", maxCommitLatency=" + this.maxCommitServiceTime + ", shouldOverflow=" + shouldOverflow));
            }
            if (shouldOverflow && this.nrunning.get() == 0) {
                if (WriteExecutorService.log.isInfoEnabled()) {
                    WriteExecutorService.log.info((Object)("Will do overflow now: nrunning=" + this.nrunning));
                }
                MDC.put((String)"taskState", (Object)"doSyncOverflow");
                this.overflow(rm);
                MDC.put((String)"taskState", (Object)"didSyncOverflow");
                if (WriteExecutorService.log.isInfoEnabled()) {
                    WriteExecutorService.log.info((Object)"Did overflow.");
                }
            }
            var16_22 = true;
            return var16_22;
        }
        catch (Throwable t) {
            WriteExecutorService.log.error((Object)("Problem with commit? : " + this.serviceName + " : " + t), t);
            this.abort();
            var6_9 = false;
            return var6_9;
        }
        finally {
            this.groupCommit.set(false);
            if (locked) {
                this.unlock();
            }
        }
    }

    private void waitForRunningTasks(long timeout, TimeUnit unit) throws InterruptedException {
        long lastTime;
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        long beginWait = lastTime = System.nanoTime();
        long nanos = unit.toNanos(timeout);
        int nwaits = 0;
        while (nanos > 0L && this.nrunning.get() > 0) {
            this.waiting.await(nanos, TimeUnit.NANOSECONDS);
            long now = System.nanoTime();
            nanos -= now - lastTime;
            lastTime = now;
            ++nwaits;
        }
        if (log.isInfoEnabled()) {
            int queueSize = this.getQueue().size();
            int nrunning = this.nrunning.get();
            int commitGroupSize = this.nwrites.get();
            int corePoolSize = this.getCorePoolSize();
            int maxPoolSize = this.getMaximumPoolSize();
            int poolSize = this.getPoolSize();
            long elapsedWait = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginWait);
            log.info((Object)("Not waiting any longer: commitGroupSize=" + commitGroupSize + ", nwaits=" + nwaits + ", elapsed(ms)=" + elapsedWait + ", queueSize=" + queueSize + ", nrunning=" + nrunning + ", corePoolSize=" + corePoolSize + ", poolSize=" + poolSize + ", maxPoolSize=" + maxPoolSize));
        }
    }

    private boolean isShouldOverflow(IResourceManager rm) {
        if (rm == null || !rm.isOpen()) {
            return false;
        }
        return rm.isOverflowEnabled() && rm.shouldOverflow();
    }

    private IResourceManager getResourceManager() {
        return (IResourceManager)this.resourceManagerRef.get();
    }

    private void overflow(IResourceManager rm) {
        assert (this.lock.isHeldByCurrentThread());
        assert (this.nrunning.get() == 0);
        try {
            rm.overflow();
            ++this.noverflow;
        }
        catch (Throwable t) {
            log.error((Object)("Overflow error: " + this.serviceName + " : " + t), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("timeout=" + timeout + ", unit=" + (Object)((Object)unit)));
        }
        long lastTime = System.nanoTime();
        long nanos = unit.toNanos(timeout);
        boolean granted = false;
        this.lock.lock();
        try {
            if (!this.exclusiveLock.tryLock(nanos, TimeUnit.NANOSECONDS)) {
                log.error((Object)("Exclusive write lock not granted: timeout=" + unit.toMillis(timeout) + "ms"));
                boolean bl = false;
                return bl;
            }
            long now = System.nanoTime();
            nanos -= now - lastTime;
            lastTime = now;
            try {
                this.pause();
                granted = this.quiesce(nanos, TimeUnit.NANOSECONDS);
                if (!granted) {
                    log.error((Object)("Exclusive write lock not granted: timeout=" + unit.toMillis(timeout) + "ms"));
                }
                boolean bl = granted;
                if (!granted) {
                    this.resume();
                    this.exclusiveLock.unlock();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (!granted) {
                    this.resume();
                    this.exclusiveLock.unlock();
                }
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        this.lock.lock();
        try {
            this.exclusiveLock.unlock();
            this.resume();
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean quiesce(long timeout, TimeUnit unit) throws InterruptedException {
        long now;
        long lastTime;
        if (!this.isPaused()) {
            throw new IllegalStateException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        long nanos = unit.toNanos(timeout);
        long beginNanos = lastTime = System.nanoTime();
        int nwaits = 0;
        int beforeCount = this.nrunning.get();
        while ((nanos -= (now = System.nanoTime()) - (lastTime = now)) > 0L) {
            if (this.nrunning.get() == 0) {
                return true;
            }
            this.waiting.awaitNanos(nanos);
            ++nwaits;
        }
        AbstractTask[] a = this.active.values().toArray(new AbstractTask[0]);
        Object[] b = new TaskAndTime[a.length];
        long maxElapsedRunning = 0L;
        for (int i = 0; i < a.length; ++i) {
            b[i] = new TaskAndTime(a[i], lastTime);
            Object t = b[i];
            if (((TaskAndTime)t).state != TaskAndTime.State.Running || ((TaskAndTime)t).elapsedRunTime < maxElapsedRunning) continue;
            maxElapsedRunning = ((TaskAndTime)t).elapsedRunTime;
        }
        Arrays.sort(b);
        log.error((Object)("Timeout! : timeout=" + unit.toMillis(timeout) + "ms,elapsed=" + TimeUnit.NANOSECONDS.toMillis(lastTime - beginNanos) + "ms,nwaits=" + nwaits + ",runningBefore=" + beforeCount + ",runningNow=" + this.nrunning.get() + ",maxElapsedRunning=" + maxElapsedRunning + ",::runningTasks=" + Arrays.toString(b)));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commit(boolean locked) {
        assert (this.lock.isHeldByCurrentThread());
        this.firstCauseRef.set(null);
        IResourceManager rm = this.getResourceManager();
        if (rm == null || !rm.isOpen()) {
            log.warn((Object)"ResourceManager not open?");
            this.resetState();
            return false;
        }
        AbstractJournal journal = rm.getLiveJournal();
        if (!journal.isOpen()) {
            log.warn((Object)"Journal not open?");
            this.resetState();
            return false;
        }
        try {
            if (locked && overflowLog.isDebugEnabled()) {
                overflowLog.debug((Object)("before: " + journal.getRootBlockView()));
            }
            long byteCountBefore = journal.getRootBlockView().getNextOffset();
            long timestamp = journal.commit();
            long byteCountAfter = journal.getRootBlockView().getNextOffset();
            if (timestamp == 0L) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Nothing to commit");
                }
                boolean bl = true;
                return bl;
            }
            this.byteCountPerCommit = byteCountAfter - byteCountBefore;
            assert (this.nwrites.get() == this.commitGroup.size());
            for (AbstractTask<?> task : this.commitGroup.values()) {
                task.commitTime = timestamp;
                try {
                    task.afterTaskHook(false);
                }
                catch (Throwable t) {
                    log.error((Object)t, t);
                }
            }
            this.ngroupCommits.incrementAndGet();
            MDC.put((String)"commitCounter", (Object)("commitCounter=" + this.ngroupCommits));
            MDC.put((String)"taskState", (Object)"didCommit");
            if (log.isInfoEnabled()) {
                log.info((Object)("commit: #writes=" + this.nwrites + ", timestamp=" + timestamp));
            }
            if (locked) {
                if (overflowLog.isInfoEnabled()) {
                    overflowLog.info((Object)("commit: #writes=" + this.nwrites + ", timestamp=" + timestamp + ", paused!"));
                }
                if (overflowLog.isDebugEnabled()) {
                    overflowLog.debug((Object)("after : " + journal.getRootBlockView()));
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            CommitException ex = new CommitException("Commit failed - will abort: " + this.serviceName + " : " + t, t);
            this.firstCauseRef.compareAndSet(null, ex);
            log.error((Object)ex);
            this.abort();
            boolean bl = false;
            return bl;
        }
        finally {
            this.resetState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort() {
        if (!this.abort.compareAndSet(false, true)) {
            throw new IllegalStateException("Abort already in progress.");
        }
        assert (this.lock.isHeldByCurrentThread());
        IResourceManager rm = this.getResourceManager();
        boolean interrupted = false;
        Thread thread = Thread.currentThread();
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)"Interrupting tasks awaiting commit.");
            }
            Iterator<Map.Entry<Thread, AbstractTask<?>>> itr = this.active.entrySet().iterator();
            int ninterrupted = 0;
            while (itr.hasNext()) {
                Map.Entry<Thread, AbstractTask<?>> entry = itr.next();
                entry.getValue().aborted = true;
                try {
                    entry.getValue().afterTaskHook(true);
                }
                catch (Throwable t) {
                    log.error((Object)t, t);
                }
                if (thread == entry.getKey()) continue;
                entry.getKey().interrupt();
                ++ninterrupted;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Interrupted " + ninterrupted + " tasks."));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Waiting for running tasks to complete: nrunning=" + this.nrunning));
            }
            while (this.nrunning.get() > 0) {
                try {
                    this.waiting.await();
                }
                catch (InterruptedException ex) {
                    log.warn((Object)"Interrupted awaiting running tasks - continuing.");
                    interrupted = true;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Doing abort: nrunning=" + this.nrunning));
            }
            assert (this.nrunning.get() == 0);
            AbstractJournal journal = rm.getLiveJournal();
            if (journal.isOpen()) {
                journal.abort();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"Did abort");
            }
        }
        catch (Throwable t) {
            if (rm == null) {
                log.error((Object)("Abort with collected journal: " + this.serviceName), t);
            } else {
                AbstractJournal journal = rm.getLiveJournal();
                if (journal.isOpen()) {
                    log.error((Object)("Problem with abort? : " + this.serviceName + " : " + t), t);
                }
            }
        }
        finally {
            ++this.naborts;
            this.abort.set(false);
            this.resetState();
        }
        if (interrupted) {
            thread.interrupt();
        }
    }

    private void resetState() {
        try {
            this.nwrites.set(0);
            this.commitGroup.clear();
            this.commit.signalAll();
        }
        catch (Throwable t) {
            log.error((Object)("Problem with resetState? : " + this.serviceName + " : " + t), t);
        }
    }

    private static class TaskAndTime
    implements Comparable<TaskAndTime> {
        private final long now;
        private final AbstractTask<?> task;
        private final long elapsedRunTime;
        private final long startAge;
        private final State state;

        public String toString() {
            return "TaskAndTime{" + this.task.toString() + ",elapsedRunTime=" + TimeUnit.NANOSECONDS.toMillis(this.elapsedRunTime) + ",startAge=" + TimeUnit.NANOSECONDS.toMillis(this.startAge) + ",state=" + (Object)((Object)this.state) + "}";
        }

        TaskAndTime(AbstractTask<?> task, long now) {
            this.task = task;
            this.now = now;
            if (task.nanoTime_finishedWork != 0L) {
                this.elapsedRunTime = task.nanoTime_finishedWork - task.nanoTime_beginWork;
                this.state = State.Done;
            } else if (task.nanoTime_beginWork == 0L) {
                this.elapsedRunTime = 0L;
                this.state = State.Waiting;
            } else {
                this.elapsedRunTime = now - task.nanoTime_beginWork;
                this.state = State.Running;
            }
            this.startAge = now - task.nanoTime_beginWork;
        }

        @Override
        public int compareTo(TaskAndTime o) {
            if (this.elapsedRunTime < o.elapsedRunTime) {
                return 1;
            }
            if (this.elapsedRunTime > o.elapsedRunTime) {
                return -1;
            }
            return 0;
        }

        private static enum State {
            Waiting,
            Running,
            Done;

        }
    }

    private static class MyRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final AtomicLong rejectedExecutionCount;

        public MyRejectedExecutionHandler(AtomicLong rejectedExecutionCount) {
            this.rejectedExecutionCount = rejectedExecutionCount;
        }

        @Override
        public void rejectedExecution(Runnable arg0, ThreadPoolExecutor arg1) {
            this.rejectedExecutionCount.incrementAndGet();
            throw new RejectedExecutionException();
        }
    }

    private static class MyLockManager<R extends Comparable<R>>
    extends NonBlockingLockManagerWithNewDesign<R> {
        private final WeakReference<WriteExecutorService> serviceRef;

        public MyLockManager(int capacity, int maxLockTries, boolean predeclareLocks, WriteExecutorService service) {
            super(capacity, maxLockTries, predeclareLocks);
            this.serviceRef = new WeakReference<WriteExecutorService>(service);
        }

        @Override
        protected void ready(Runnable r) {
            WriteExecutorService service = (WriteExecutorService)this.serviceRef.get();
            if (service == null) {
                throw new RejectedExecutionException();
            }
            service.execute(r);
        }
    }
}

