/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.Banner;
import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.PIDUtil;
import com.bigdata.ha.RunState;
import com.bigdata.jini.lookup.entry.Hostname;
import com.bigdata.jini.lookup.entry.ServiceUUID;
import com.bigdata.jini.util.JiniUtil;
import com.bigdata.journal.jini.ha.HAClient;
import com.bigdata.service.IService;
import com.bigdata.service.IServiceShutdown;
import com.bigdata.service.jini.JiniClientConfig;
import com.sun.jini.start.LifeCycle;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.lookup.ServiceIDListener;
import net.jini.lookup.entry.Name;
import org.apache.log4j.Logger;

public abstract class AbstractServer
implements Runnable,
LeaseListener,
ServiceIDListener,
DiscoveryListener {
    private static final Logger log = Logger.getLogger(AbstractServer.class);
    private final AtomicReference<ServiceID> serviceIDRef = new AtomicReference();
    private File serviceDir;
    private File serviceIdFile;
    private final int pid;
    private File pidFile;
    private RandomAccessFile lockFileRAF = null;
    private FileLock fileLock;
    private File lockFile;
    private final HAClient haClient;
    private JoinManager joinManager;
    private volatile LookupDiscoveryManager lookupDiscoveryManager = null;
    protected final Configuration config;
    private final JiniClientConfig jiniClientConfig;
    private final List<Entry> entries;
    private String serviceName;
    private Exporter exporter;
    private Remote impl;
    private Remote proxy;
    private String hostname;
    private LifeCycle lifeCycle;
    private final AtomicReference<RunState> runState;
    private final AtomicBoolean keepAlive = new AtomicBoolean(true);
    private final ReentrantLock discoveryEventLock = new ReentrantLock();
    private final Condition discoveryEvent = this.discoveryEventLock.newCondition();

    public final String getServiceName() {
        return this.serviceName;
    }

    protected String getHostName() {
        return this.hostname;
    }

    public Remote getProxy() {
        return this.proxy;
    }

    public Remote getRemoteImpl() {
        return this.impl;
    }

    public ServiceID getServiceID() {
        return this.serviceIDRef.get();
    }

    public File getServiceDir() {
        return this.serviceDir;
    }

    protected final int getPID() {
        return this.pid;
    }

    protected boolean isPersistent() {
        return true;
    }

    protected JoinManager getJoinManager() {
        return this.joinManager;
    }

    protected final HAClient getHAClient() {
        return this.haClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discarded(DiscoveryEvent e) {
        try {
            this.discoveryEventLock.lockInterruptibly();
            try {
                this.discoveryEvent.signalAll();
            }
            finally {
                this.discoveryEventLock.unlock();
            }
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discovered(DiscoveryEvent e) {
        try {
            this.discoveryEventLock.lockInterruptibly();
            try {
                this.discoveryEvent.signalAll();
            }
            finally {
                this.discoveryEventLock.unlock();
            }
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    public static final void setSecurityManager() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            System.setSecurityManager(new SecurityManager());
            if (log.isInfoEnabled()) {
                log.info((Object)"Set security manager");
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Security manager already in place: " + sm.getClass()));
        }
    }

    protected void fatal(String msg, Throwable t) {
        log.fatal((Object)msg, t);
        try {
            this.shutdownNow(false);
        }
        catch (Throwable t2) {
            log.error((Object)this, t2);
        }
        throw new RuntimeException(msg, t);
    }

    private AbstractServer(String[] args) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractServer(String[] args, LifeCycle lifeCycle) {
        this.runState = new AtomicReference<RunState>(RunState.Start);
        Banner.banner();
        if (lifeCycle == null) {
            throw new IllegalArgumentException();
        }
        this.lifeCycle = lifeCycle;
        AbstractServer.setSecurityManager();
        this.pid = PIDUtil.getPID();
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(false, this));
        LinkedList<Entry> entries = null;
        String COMPONENT = this.getClass().getName();
        try {
            block25: {
                ServiceID tmp;
                block26: {
                    this.haClient = new HAClient(args);
                    this.config = ConfigurationProvider.getInstance((String[])args);
                    this.jiniClientConfig = new JiniClientConfig(JiniClientConfig.Options.NAMESPACE, this.config);
                    entries = new LinkedList<Entry>(Arrays.asList(this.jiniClientConfig.entries));
                    if (log.isInfoEnabled()) {
                        log.info((Object)this.jiniClientConfig.toString());
                    }
                    this.serviceDir = (File)this.config.getEntry(COMPONENT, "serviceDir", File.class);
                    if (this.serviceDir != null && !this.serviceDir.exists()) {
                        log.warn((Object)("Creating: " + this.serviceDir));
                        this.serviceDir.mkdirs();
                    }
                    this.serviceIdFile = new File(this.serviceDir, "service.id");
                    if (this.serviceIdFile.exists()) {
                        ServiceID tmp2;
                        try {
                            tmp2 = AbstractServer.readServiceId(this.serviceIdFile);
                        }
                        catch (IOException ex) {
                            this.fatal("Could not read serviceID from existing file: " + this.serviceIdFile + ": " + this, ex);
                            throw new AssertionError();
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Existing service instance: serviceID=" + tmp2));
                        }
                        this.setServiceID(tmp2);
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)"New service instance.");
                    }
                    this.lockFile = new File(this.serviceDir, ".lock");
                    this.acquireFileLock();
                    this.pidFile = new File(this.serviceDir, "pid");
                    this.writePIDFile(this.pidFile);
                    String serviceName = null;
                    String hostname = null;
                    ServiceID serviceID = this.getServiceID();
                    UUID serviceUUID = serviceID == null ? null : JiniUtil.serviceID2UUID(serviceID);
                    for (Entry e : entries) {
                        if (e instanceof Name && serviceName == null) {
                            serviceName = ((Name)e).name;
                        }
                        if (e instanceof Hostname && hostname == null) {
                            hostname = ((Hostname)e).hostname;
                        }
                        if (!(e instanceof ServiceUUID) || serviceUUID != null) continue;
                        serviceUUID = ((ServiceUUID)e).serviceUUID;
                    }
                    if (serviceName == null) {
                        String defaultName;
                        serviceName = defaultName = this.getClass().getName() + "@" + AbstractStatisticsCollector.fullyQualifiedHostName + "#" + this.hashCode();
                        entries.add((Entry)new Name(serviceName));
                    }
                    this.serviceName = serviceName;
                    if (hostname == null) {
                        hostname = AbstractStatisticsCollector.fullyQualifiedHostName;
                        entries.add((Entry)new Hostname(hostname));
                    }
                    this.hostname = hostname;
                    if (serviceUUID == null) break block26;
                    tmp = JiniUtil.uuid2ServiceID(serviceUUID);
                    ServiceID existingServiceID = this.getServiceID();
                    if (existingServiceID != null) {
                        if (!existingServiceID.equals((Object)tmp)) {
                            throw new ConfigurationException("ServiceID in Configuration does not agree with the value in " + this.serviceIdFile + " : Configuration=" + tmp + ", but expected =" + existingServiceID);
                        }
                    } else {
                        this.setServiceID(JiniUtil.uuid2ServiceID(serviceUUID));
                    }
                    if (!this.serviceIdFile.exists()) {
                        this.writeServiceIDOnFile(tmp);
                        break block25;
                    } else {
                        try {
                            ServiceID tmp2 = AbstractServer.readServiceId(this.serviceIdFile);
                            if (!tmp.equals((Object)tmp2)) {
                                throw new RuntimeException("Entry has ServiceID=" + tmp + ", but file as ServiceID=" + tmp2);
                            }
                            break block25;
                        }
                        catch (IOException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                }
                if (!this.serviceIdFile.exists()) {
                    tmp = JiniUtil.uuid2ServiceID(UUID.randomUUID());
                    this.setServiceID(tmp);
                    this.writeServiceIDOnFile(tmp);
                }
            }
            this.entries = entries;
            this.exporter = (Exporter)this.config.getEntry(this.getClass().getName(), "exporter", Exporter.class, (Object)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory()));
            return;
        }
        catch (ConfigurationException ex) {
            this.fatal("Configuration error: " + this, ex);
            throw new AssertionError();
        }
    }

    public String toString() {
        ServiceID serviceID = this.serviceIDRef.get();
        return this.getClass().getName() + "{serviceName=" + this.serviceName + ", hostname=" + this.hostname + ", serviceUUID=" + (serviceID == null ? "null" : "" + JiniUtil.serviceID2UUID(serviceID)) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireFileLock() {
        block9: {
            try {
                this.lockFileRAF = new RandomAccessFile(this.lockFile, "rw");
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not open: file=" + this.lockFile, ex);
            }
            try {
                this.fileLock = this.lockFileRAF.getChannel().tryLock();
                if (this.fileLock != null) break block9;
                try {
                    this.lockFileRAF.close();
                }
                catch (Throwable t) {
                }
                finally {
                    this.lockFileRAF = null;
                }
                throw new RuntimeException("Service already running: file=" + this.lockFile);
            }
            catch (IOException ex) {
                log.warn((Object)("FileLock not supported: file=" + this.lockFile), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePIDFile(File file) {
        try {
            String pidStr = Integer.toString(this.pid);
            try (FileOutputStream os = new FileOutputStream(file);){
                os.getChannel().truncate(0L);
                os.write(pidStr.getBytes("ASCII"));
                os.flush();
            }
        }
        catch (IOException ex) {
            log.warn((Object)("Could not write pid: file=" + file), (Throwable)ex);
        }
    }

    private void startLookupDiscoveryManager(Configuration config) throws ConfigurationException, IOException {
        if (this.lookupDiscoveryManager == null) {
            log.info((Object)"Starting lookup discovery.");
            String[] groups = this.jiniClientConfig.groups;
            LookupLocator[] lookupLocators = this.jiniClientConfig.locators;
            this.lookupDiscoveryManager = new LookupDiscoveryManager(groups, lookupLocators, null, config);
        }
    }

    protected ServiceRegistrar[] awaitServiceRegistrars(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        long nanos;
        if (this.lookupDiscoveryManager == null) {
            throw new IllegalStateException();
        }
        long begin = System.nanoTime();
        long remaining = nanos = unit.toNanos(timeout);
        ServiceRegistrar[] registrars = null;
        while ((registrars == null || registrars.length == 0) && remaining > 0L) {
            registrars = this.lookupDiscoveryManager.getRegistrars();
            Thread.sleep(100L);
            long elapsed = System.nanoTime() - begin;
            remaining = nanos - elapsed;
        }
        if (registrars == null || registrars.length == 0) {
            throw new RuntimeException("Could not discover ServiceRegistrar(s)");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Found " + registrars.length + " service registrars"));
        }
        return registrars;
    }

    private synchronized void exportProxy(Remote impl) throws ConfigurationException, IOException {
        try {
            this.proxy = this.exporter.export(impl);
            if (log.isInfoEnabled()) {
                log.info((Object)("EXPORTED PROXY: Proxy is " + this.proxy + "(" + this.proxy.getClass() + ")"));
            }
        }
        catch (ExportException ex) {
            this.fatal("Export error: " + this, ex);
            throw new AssertionError();
        }
        try {
            assert (this.proxy != null) : "No proxy?";
            Entry[] attributes = this.entries.toArray(new Entry[0]);
            ServiceID serviceID = this.getServiceID();
            this.joinManager = serviceID != null ? new JoinManager((Object)this.proxy, attributes, serviceID, (DiscoveryManagement)this.lookupDiscoveryManager, new LeaseRenewalManager(), this.config) : new JoinManager((Object)this.proxy, attributes, (ServiceIDListener)this, (DiscoveryManagement)this.lookupDiscoveryManager, new LeaseRenewalManager(), this.config);
        }
        catch (Exception ex) {
            this.fatal("JoinManager: " + this, ex);
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean unexport(boolean force) {
        boolean unexported = false;
        if (this.proxy != null) {
            log.warn((Object)("UNEXPORT PROXY: force=" + force + ", proxy=" + this.proxy));
            try {
                if (this.exporter.unexport(force)) {
                    unexported = true;
                } else {
                    log.warn((Object)("Proxy was not unexported? : " + this));
                }
            }
            finally {
                this.proxy = null;
            }
        }
        if (this.joinManager != null) {
            try {
                this.joinManager.terminate();
            }
            catch (Throwable ex) {
                log.error((Object)("Could not terminate the join manager: " + this), ex);
            }
            finally {
                this.joinManager = null;
            }
        }
        return unexported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceID readServiceId(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            ServiceID serviceID = new ServiceID((DataInput)new DataInputStream(is));
            if (log.isInfoEnabled()) {
                log.info((Object)("Read ServiceID=" + serviceID + "(" + JiniUtil.serviceID2UUID(serviceID) + ") from " + file));
            }
            ServiceID serviceID2 = serviceID;
            return serviceID2;
        }
    }

    private void setServiceID(ServiceID newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        if (!this.serviceIDRef.compareAndSet(null, newValue)) {
            throw new IllegalStateException("ServiceID may not be changed: ServiceID=" + this.serviceIDRef.get() + ", proposed=" + newValue);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("serviceID=" + newValue + ", serviceUUID=" + JiniUtil.serviceID2UUID(newValue)));
        }
    }

    public synchronized void serviceIDNotify(ServiceID serviceID) {
        this.setServiceID(serviceID);
        assert (this.serviceIdFile != null) : "serviceIdFile not defined?";
        this.writeServiceIDOnFile(serviceID);
        LinkedList<Entry> attributes = new LinkedList<Entry>(Arrays.asList(this.joinManager.getAttributes()));
        Iterator itr = attributes.iterator();
        while (itr.hasNext()) {
            Entry e = (Entry)itr.next();
            if (!(e instanceof ServiceUUID)) continue;
            itr.remove();
        }
        attributes.add((Entry)new ServiceUUID(JiniUtil.serviceID2UUID(serviceID)));
        this.joinManager.setAttributes(attributes.toArray(new Entry[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeServiceIDOnFile(ServiceID serviceID) {
        try (DataOutputStream dout = new DataOutputStream(new FileOutputStream(this.serviceIdFile));){
            serviceID.writeBytes((DataOutput)dout);
            dout.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)("ServiceID saved: file=" + this.serviceIdFile + ", serviceID=" + serviceID + ", serviceUUID=" + JiniUtil.serviceID2UUID(serviceID)));
            }
        }
        catch (Exception ex) {
            log.error((Object)("Could not save ServiceID : " + this), (Throwable)ex);
        }
    }

    public void notify(LeaseRenewalEvent event) {
        log.warn((Object)("Lease could not be renewed: " + this + " : " + event));
        try {
            JoinManager joinManager = this.joinManager;
            if (joinManager != null) {
                ServiceRegistrar[] a = joinManager.getJoinSet();
                if (a.length == 0) {
                    log.error((Object)"Service not registered with any service registrars");
                } else if (log.isInfoEnabled()) {
                    log.info((Object)("Service remains registered with " + a.length + " service registrars"));
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Problem obtaining joinSet? : " + this), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutdownNow(boolean destroy) {
        block33: {
            if (!this.runState.compareAndSet(RunState.Start, RunState.ShuttingDown) && !this.runState.compareAndSet(RunState.Running, RunState.ShuttingDown)) {
                return;
            }
            this.beforeShutdownHook(destroy);
            try {
                Object tmp;
                try {
                    this.unexport(true);
                }
                catch (Throwable ex) {
                    log.error((Object)("Problem unexporting service: " + this), ex);
                }
                if (destroy && this.impl != null && this.impl instanceof IService) {
                    tmp = (IService)this.impl;
                    try {
                        tmp.destroy();
                    }
                    catch (Throwable ex) {
                        log.error((Object)("Problem with service destroy: " + this), ex);
                    }
                }
                if (this.impl != null && this.impl instanceof IServiceShutdown) {
                    try {
                        tmp = (IServiceShutdown)((Object)this.impl);
                        if (tmp != null && tmp.isOpen()) {
                            tmp.shutdownNow();
                        }
                    }
                    catch (Throwable ex) {
                        log.error((Object)("Problem with service shutdown: " + this), ex);
                    }
                }
                this.impl = null;
                try {
                    this.terminate();
                }
                catch (Throwable ex) {
                    log.error((Object)("Could not terminate async threads (jini, zookeeper): " + this), ex);
                }
                if (this.lifeCycle != null) {
                    try {
                        this.lifeCycle.unregister((Object)this);
                    }
                    catch (Throwable ex) {
                        log.error((Object)("Could not unregister lifeCycle: " + this), ex);
                    }
                    finally {
                        this.lifeCycle = null;
                    }
                }
                if (destroy) {
                    this.recursiveDelete(this.serviceDir);
                    if (this.serviceIdFile.exists() && !this.serviceIdFile.delete()) {
                        log.warn((Object)("Could not delete: " + this.serviceIdFile));
                    }
                    if (this.pidFile.exists() && !this.pidFile.delete()) {
                        log.warn((Object)("Could not delete: " + this.pidFile));
                    }
                }
                if (this.lockFileRAF != null && this.lockFileRAF.getChannel().isOpen()) {
                    try {
                        this.lockFileRAF.close();
                    }
                    catch (IOException ex) {
                        log.warn((Object)this, (Throwable)ex);
                    }
                }
                if (destroy && this.lockFile.exists() && !this.lockFile.delete()) {
                    log.warn((Object)("Could not delete: " + this.serviceDir));
                }
                if (destroy && this.serviceDir.exists() && !this.serviceDir.delete()) {
                    log.warn((Object)("Could not delete: " + this.serviceDir));
                }
                if (this.keepAlive == null || !this.keepAlive.compareAndSet(true, false)) break block33;
                AtomicBoolean atomicBoolean = this.keepAlive;
                synchronized (atomicBoolean) {
                    this.keepAlive.notifyAll();
                }
            }
            finally {
                this.runState.set(RunState.Shutdown);
            }
        }
    }

    protected void beforeShutdownHook(boolean destroy) {
    }

    public RunState getRunState() {
        return this.runState.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void terminate() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Terminating service management threads.");
        }
        if (this.haClient != null && this.haClient.isConnected()) {
            this.haClient.disconnect(false);
        }
        if (this.lookupDiscoveryManager != null) {
            try {
                this.lookupDiscoveryManager.terminate();
            }
            catch (Throwable ex) {
                log.error((Object)("Could not terminate the lookup discovery manager: " + this), ex);
            }
            finally {
                this.lookupDiscoveryManager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Started server.");
        }
        try {
            Thread.currentThread().setName(this.getClass().getName());
        }
        catch (SecurityException ex) {
            log.warn((Object)("Could not set thread name: " + ex));
        }
        try {
            this.startLookupDiscoveryManager(this.config);
            this.impl = this.newService(this.config);
            this.exportProxy(this.impl);
            this.startUpHook();
        }
        catch (Throwable t) {
            this.fatal("Startup failure", t);
            throw new AssertionError();
        }
        if (this.runState.compareAndSet(RunState.Start, RunState.Running)) {
            String msg = "Service is running: class=" + this.getClass().getName() + ", name=" + this.getServiceName();
            System.out.println(msg);
            if (log.isInfoEnabled()) {
                log.info((Object)msg);
            }
            AtomicBoolean atomicBoolean = this.keepAlive;
            synchronized (atomicBoolean) {
                while (this.keepAlive.get()) {
                    try {
                        this.keepAlive.wait();
                    }
                    catch (InterruptedException ex) {
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)ex.getLocalizedMessage());
                    }
                }
            }
        }
        System.out.println("Service is down: class=" + this.getClass().getName() + ", name=" + this.getServiceName());
    }

    protected void startUpHook() {
    }

    private void recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] children = f.listFiles(this.getFileFilter());
            for (int i = 0; i < children.length; ++i) {
                this.recursiveDelete(children[i]);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing: " + f));
        }
        if (f.exists() && !f.delete()) {
            log.warn((Object)("Could not remove: " + f));
        }
    }

    protected FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return false;
            }
        };
    }

    protected void runShutdown(boolean destroy) {
        ShutdownThread t = new ShutdownThread(destroy, this);
        t.setDaemon(true);
        t.start();
    }

    protected abstract Remote newService(Configuration var1) throws Exception;

    private static class ShutdownThread
    extends Thread {
        private final boolean destroy;
        private final AbstractServer server;

        public ShutdownThread(boolean destroy, AbstractServer server) {
            super("shutdownThread");
            if (server == null) {
                throw new IllegalArgumentException();
            }
            this.destroy = destroy;
            this.server = server;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            String msg = this.server.toString();
            log.warn((Object)("Will " + (this.destroy ? "destroy" : "shutdown") + " service: " + msg));
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                this.server.shutdownNow(this.destroy);
                log.warn((Object)("Service " + (this.destroy ? "destroyed" : "shutdown") + ": " + msg));
            }
            catch (Throwable t) {
                log.error((Object)("Problem " + (this.destroy ? "destroying" : "shutting down") + " service: " + msg), t);
            }
        }
    }

    public static interface ConfigurationOptions
    extends HAClient.ConfigurationOptions {
        public static final String SERVICE_DIR = "serviceDir";
        public static final String EXPORTER = "exporter";
    }
}

