/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal.jini.ha;

import com.bigdata.ha.msg.HASnapshotRequest;
import com.bigdata.ha.msg.IHASnapshotRequest;
import com.bigdata.ha.msg.IHASnapshotResponse;
import com.bigdata.journal.jini.ha.HAJournal;
import com.bigdata.journal.jini.ha.ISnapshotPolicy;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Formatter;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DefaultSnapshotPolicy
implements ISnapshotPolicy {
    private static final transient Logger log = Logger.getLogger(DefaultSnapshotPolicy.class);
    private final int timeOfDay;
    private final int percentLogSize;

    public static String toHHMM(long delay) {
        int hh = (int)TimeUnit.MILLISECONDS.toHours(delay);
        int mm = (int)(TimeUnit.MILLISECONDS.toMinutes(delay) % 60L);
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("%02d:%02d", hh, mm);
        f.flush();
        f.close();
        String str = sb.toString();
        return str;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("%04d", this.timeOfDay);
        f.flush();
        f.close();
        String todStr = sb.toString();
        return DefaultSnapshotPolicy.class.getSimpleName() + "{timeOfDay=" + todStr + ", percentLogSize=" + this.percentLogSize + "%}" + ", countdown=" + DefaultSnapshotPolicy.toHHMM(DefaultSnapshotPolicy.delay(this.timeOfDay));
    }

    public DefaultSnapshotPolicy() {
        this(200, 50);
    }

    public DefaultSnapshotPolicy(int timeOfDay, int percentLogSize) {
        if (timeOfDay < 0) {
            throw new IllegalArgumentException();
        }
        if (percentLogSize < 0 || percentLogSize > 400) {
            throw new IllegalArgumentException("percentage must be in [0:400]");
        }
        this.timeOfDay = timeOfDay;
        this.percentLogSize = percentLogSize;
    }

    @Override
    public void init(HAJournal jnl) {
        long initialDelay = DefaultSnapshotPolicy.delay(this.timeOfDay);
        long delay = TimeUnit.DAYS.toMillis(1L);
        if (log.isInfoEnabled()) {
            log.info((Object)("initialDelay=" + DefaultSnapshotPolicy.toHHMM(initialDelay)));
        }
        jnl.addScheduledTask(new SnapshotTask(jnl), initialDelay, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public IHASnapshotRequest newSnapshotRequest() {
        return new HASnapshotRequest(this.percentLogSize);
    }

    private static long delay(int tod) {
        long tzAdjust;
        long minuteMillis = 60000L;
        long dayMillis = 86400000L;
        int todHours = tod / 100;
        int todMinutes = tod % 100;
        long todMillis = (long)(todHours * 60 + todMinutes) * 60000L;
        long now = System.currentTimeMillis();
        long startOfDay = now - now % 86400000L - (tzAdjust = (long)Calendar.getInstance().getTimeZone().getRawOffset());
        long targetTime = startOfDay + todMillis;
        long delayMs = targetTime - now;
        if (delayMs < 0L) {
            return delayMs + 86400000L;
        }
        return delayMs;
    }

    private class SnapshotTask
    implements Runnable {
        private final WeakReference<HAJournal> ref;

        public SnapshotTask(HAJournal jnl) {
            this.ref = new WeakReference<HAJournal>(jnl);
        }

        @Override
        public void run() {
            try {
                HAJournal jnl = (HAJournal)this.ref.get();
                if (jnl == null) {
                    return;
                }
                Future<IHASnapshotResponse> f = jnl.getSnapshotManager().takeSnapshot(DefaultSnapshotPolicy.this.newSnapshotRequest());
                if (f != null) {
                    f.get();
                }
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
        }
    }
}

